/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.conversion.IConverter;

public class IdentityConverter
implements IConverter<Object, Object> {
    private Class<?> fromType;
    private Class<?> toType;
    private Class<?>[][] primitiveMap = new Class[][]{{Integer.TYPE, Integer.class}, {Short.TYPE, Short.class}, {Long.TYPE, Long.class}, {Double.TYPE, Double.class}, {Byte.TYPE, Byte.class}, {Float.TYPE, Float.class}, {Boolean.TYPE, Boolean.class}, {Character.TYPE, Character.class}};

    public IdentityConverter(Class<?> type) {
        this.fromType = type;
        this.toType = type;
    }

    public IdentityConverter(Class<?> fromType, Class<?> toType) {
        this.fromType = fromType;
        this.toType = toType;
    }

    @Override
    public Object convert(Object source) {
        if (this.toType.isPrimitive() && source == null) {
            throw new BindingException("Cannot convert null to a primitive");
        }
        if (source != null) {
            Class<?> sourceClass = source.getClass();
            if (this.toType.isPrimitive() || sourceClass.isPrimitive()) {
                if (sourceClass.equals(this.toType) || this.isPrimitiveTypeMatchedWithBoxed(sourceClass, this.toType)) {
                    return source;
                }
                throw new BindingException("Boxed and unboxed types do not match");
            }
            if (!this.toType.isAssignableFrom(sourceClass)) {
                throw new BindingException(String.valueOf(sourceClass.getName()) + " is not assignable to " + this.toType.getName());
            }
        }
        return source;
    }

    public boolean isPrimitiveTypeMatchedWithBoxed(Class<?> sourceClass, Class<?> toClass) {
        Class<?>[][] classArray = this.primitiveMap;
        int n = this.primitiveMap.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] primitiveTuple = classArray[n2];
            if (toClass.equals(primitiveTuple[0]) && sourceClass.equals(primitiveTuple[1])) {
                return true;
            }
            if (sourceClass.equals(primitiveTuple[0]) && toClass.equals(primitiveTuple[1])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Object getFromType() {
        return this.fromType;
    }

    @Override
    public Object getToType() {
        return this.toType;
    }
}

