/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;

public final class IOUtil {
    private static final int BUFFER_SIZE = 8192;
    private static final Charset UTF_8 = Charset.forName("utf-8");

    public static boolean delete(File file) {
        boolean result = true;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                result &= IOUtil.delete(files[i]);
                ++i;
            }
        }
        return result &= file.delete();
    }

    public static void copy(File source, File destination) {
        try {
            FileInputStream inputStream = new FileInputStream(source);
            try {
                IOUtil.copy(inputStream, destination);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (IOException ioe) {
            IOUtil.handleCopyException(source, destination, ioe);
        }
    }

    public static void copy(InputStream source, File destination) {
        byte[] buffer = new byte[8192];
        destination.getParentFile().mkdirs();
        try {
            FileOutputStream outputStream = new FileOutputStream(destination, false);
            try {
                int bytesRead = source.read(buffer);
                while (bytesRead != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                    bytesRead = source.read(buffer);
                }
            }
            finally {
                ((OutputStream)outputStream).close();
            }
        }
        catch (IOException ioe) {
            IOUtil.handleCopyException(destination, ioe);
        }
    }

    public static String readContent(InputStream inputStream) {
        StringBuffer result = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(inputStream, UTF_8);
        char[] buffer = new char[8192];
        try {
            int bytesRead = reader.read(buffer);
            while (bytesRead != -1) {
                result.append(buffer, 0, bytesRead);
                bytesRead = reader.read(buffer);
            }
        }
        catch (IOException ioe) {
            IOUtil.handleReadException(ioe);
        }
        return result.toString();
    }

    public static void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException shouldNotHappen) {
            String msg = "Failed to close input stream.";
            throw new RuntimeException(msg, shouldNotHappen);
        }
    }

    private static void handleCopyException(File destination, IOException ioe) {
        String text = "Failed to copy content to ''{0}''.";
        String msg = MessageFormat.format(text, destination);
        throw new RuntimeException(msg, ioe);
    }

    private static void handleCopyException(File source, File destination, IOException ioe) {
        String text = "Failed to copy file from ''{0}'' to ''{1}''.";
        Object[] args = new Object[]{source, destination};
        String msg = MessageFormat.format(text, args);
        throw new RuntimeException(msg, ioe);
    }

    private static void handleReadException(IOException ioe) {
        String msg = "Failed to read from input stream.";
        throw new RuntimeException(msg, ioe);
    }

    private IOUtil() {
    }
}

