/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.shortcut;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.rap.ui.internal.launch.rwt.shortcut.RunnableContextHelper;
import org.eclipse.rap.ui.internal.launch.rwt.util.StringArrays;

class EntryPointSearchEngine {
    private static final int SCOPE_CONSTRAINTS = 11;
    private final RunnableContextHelper runnableContextHelper;
    private final EntryPointCollector entryPointCollector;
    private IJavaSearchScope searchScope;

    EntryPointSearchEngine(IRunnableContext runnableContext) {
        this.runnableContextHelper = new RunnableContextHelper(runnableContext);
        this.entryPointCollector = new EntryPointCollector();
    }

    IType[] search(IJavaElement[] javaElements) throws CoreException, InterruptedException {
        this.searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)11);
        this.entryPointCollector.clear();
        RunnableContextHelper.IContextRunnable contextRunnable = new RunnableContextHelper.IContextRunnable(){

            public void run(IProgressMonitor monitor) throws Exception {
                EntryPointSearchEngine.this.search(monitor);
            }
        };
        this.runnableContextHelper.runInContext(contextRunnable);
        return this.entryPointCollector.getResult();
    }

    private void search(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Searching for entry points...", 100);
        try {
            int matchRule = 8;
            SearchPattern pattern = SearchPattern.createPattern((String)"createUI() int", (int)1, (int)0, (int)matchRule);
            SearchParticipant[] participants = EntryPointSearchEngine.getSearchParticipants();
            SubProgressMonitor searchMonitor = new SubProgressMonitor(monitor, 100);
            SearchEngine searchEngine = new SearchEngine();
            searchEngine.search(pattern, participants, this.searchScope, (SearchRequestor)this.entryPointCollector, (IProgressMonitor)searchMonitor);
        }
        finally {
            monitor.done();
        }
    }

    private static SearchParticipant[] getSearchParticipants() {
        return new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
    }

    private static class EntryPointCollector
    extends SearchRequestor {
        private final List<IType> collectedTypes = new LinkedList<IType>();

        void clear() {
            this.collectedTypes.clear();
        }

        IType[] getResult() {
            return this.collectedTypes.toArray(new IType[this.collectedTypes.size()]);
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            IMethod method;
            IType type;
            Object enclosingElement = match.getElement();
            if (enclosingElement instanceof IMethod && EntryPointCollector.isIEntryPointType(type = (method = (IMethod)enclosingElement).getDeclaringType())) {
                this.collectedTypes.add(type);
            }
        }

        private static boolean isIEntryPointType(IType type) throws JavaModelException {
            return new TypeInspector(type).isIEntryPointType();
        }
    }

    private static class TypeInspector {
        private static final String[] NO_PARAMETERS = new String[0];
        private final IType type;

        TypeInspector(IType type) {
            this.type = type;
        }

        boolean isIEntryPointType() throws JavaModelException {
            return this.type.isClass() && this.implementsIEntryPoint() && this.hasCreateUIMethod();
        }

        private boolean hasCreateUIMethod() {
            IMethod method = this.type.getMethod("createUI", NO_PARAMETERS);
            return method.exists();
        }

        private boolean implementsIEntryPoint() throws JavaModelException {
            String[] superInterfaceNames = this.type.getSuperInterfaceNames();
            return StringArrays.contains(superInterfaceNames, "IEntryPoint");
        }
    }
}

