/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.application;

import java.io.File;
import javax.servlet.ServletContext;
import org.eclipse.rwt.application.ApplicationConfiguration;
import org.eclipse.rwt.internal.AdapterManager;
import org.eclipse.rwt.internal.application.ApplicationContextConfigurator;
import org.eclipse.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rwt.internal.branding.BrandingManager;
import org.eclipse.rwt.internal.engine.RWTConfiguration;
import org.eclipse.rwt.internal.engine.RWTConfigurationImpl;
import org.eclipse.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterFactory;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerRegistry;
import org.eclipse.rwt.internal.resources.JSLibraryConcatenator;
import org.eclipse.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rwt.internal.service.ApplicationStoreImpl;
import org.eclipse.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rwt.internal.service.ServiceManager;
import org.eclipse.rwt.internal.service.SettingStoreManager;
import org.eclipse.rwt.internal.service.StartupPage;
import org.eclipse.rwt.internal.textsize.ProbeStore;
import org.eclipse.rwt.internal.textsize.TextSizeStorage;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.service.IApplicationStore;
import org.eclipse.swt.internal.graphics.FontDataFactory;
import org.eclipse.swt.internal.graphics.ImageDataFactory;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.graphics.InternalImageFactory;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.DisplaysHolder;
import org.eclipse.swt.internal.widgets.displaykit.ClientResources;

public class ApplicationContext {
    static IResourceManager testResourceManager;
    static boolean skipResoureRegistration;
    static boolean skipResoureDeletion;
    private ThemeManager themeManager;
    private final RWTConfiguration rwtConfiguration;
    private final ResourceManagerImpl resourceManager;
    private final BrandingManager brandingManager;
    private final PhaseListenerRegistry phaseListenerRegistry;
    private final LifeCycleFactory lifeCycleFactory;
    private final EntryPointManager entryPointManager;
    private final AdapterManager adapterManager;
    private final LifeCycleAdapterFactory lifeCycleAdapterFactory;
    private final SettingStoreManager settingStoreManager;
    private final ServiceManager serviceManager;
    private final ResourceRegistry resourceRegistry;
    private final JSLibraryConcatenator jsLibraryConcatenator;
    private final ApplicationStoreImpl applicationStore = new ApplicationStoreImpl();
    private final ResourceFactory resourceFactory;
    private final ImageFactory imageFactory;
    private final InternalImageFactory internalImageFactory;
    private final ImageDataFactory imageDataFactory;
    private final FontDataFactory fontDataFactory;
    private final StartupPage startupPage;
    private final DisplaysHolder displaysHolder;
    private final TextSizeStorage textSizeStorage;
    private final ProbeStore probeStore;
    private final ServletContext servletContext;
    private final ApplicationContextConfigurator contextConfigurator;
    private boolean activated;

    public ApplicationContext(ApplicationConfiguration applicationConfiguration, ServletContext servletContext) {
        this.rwtConfiguration = new RWTConfigurationImpl();
        this.resourceManager = new ResourceManagerImpl(this.rwtConfiguration);
        this.phaseListenerRegistry = new PhaseListenerRegistry();
        this.entryPointManager = new EntryPointManager();
        this.lifeCycleFactory = new LifeCycleFactory(this.phaseListenerRegistry);
        this.themeManager = new ThemeManager();
        this.brandingManager = new BrandingManager();
        this.resourceFactory = new ResourceFactory();
        this.imageFactory = new ImageFactory();
        this.internalImageFactory = new InternalImageFactory();
        this.imageDataFactory = new ImageDataFactory(this.resourceManager);
        this.fontDataFactory = new FontDataFactory();
        this.adapterManager = new AdapterManager();
        this.lifeCycleAdapterFactory = new LifeCycleAdapterFactory();
        this.settingStoreManager = new SettingStoreManager();
        this.resourceRegistry = new ResourceRegistry();
        this.startupPage = new StartupPage(this.resourceRegistry);
        this.serviceManager = this.createServiceManager();
        this.displaysHolder = new DisplaysHolder();
        this.jsLibraryConcatenator = new JSLibraryConcatenator(this.resourceManager);
        this.textSizeStorage = new TextSizeStorage();
        this.probeStore = new ProbeStore(this.textSizeStorage);
        this.servletContext = servletContext;
        this.contextConfigurator = new ApplicationContextConfigurator(applicationConfiguration, servletContext);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void activate() {
        this.checkIsActivated();
        this.activated = true;
        try {
            this.doActivate();
        }
        catch (RuntimeException rte) {
            this.activated = false;
            throw rte;
        }
    }

    public void deactivate() {
        this.checkIsNotActivated();
        try {
            this.doDeactivate();
        }
        finally {
            this.activated = false;
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public RWTConfiguration getConfiguration() {
        return this.rwtConfiguration;
    }

    public IResourceManager getResourceManager() {
        return testResourceManager != null ? testResourceManager : this.resourceManager;
    }

    public EntryPointManager getEntryPointManager() {
        return this.entryPointManager;
    }

    public BrandingManager getBrandingManager() {
        return this.brandingManager;
    }

    public SettingStoreManager getSettingStoreManager() {
        return this.settingStoreManager;
    }

    public PhaseListenerRegistry getPhaseListenerRegistry() {
        return this.phaseListenerRegistry;
    }

    public AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    public LifeCycleAdapterFactory getLifeCycleAdapterFactory() {
        return this.lifeCycleAdapterFactory;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public JSLibraryConcatenator getJSLibraryConcatenator() {
        return this.jsLibraryConcatenator;
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public LifeCycleFactory getLifeCycleFactory() {
        return this.lifeCycleFactory;
    }

    public IApplicationStore getApplicationStore() {
        return this.applicationStore;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public ImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public InternalImageFactory getInternalImageFactory() {
        return this.internalImageFactory;
    }

    public ImageDataFactory getImageDataFactory() {
        return this.imageDataFactory;
    }

    public FontDataFactory getFontDataFactory() {
        return this.fontDataFactory;
    }

    public StartupPage getStartupPage() {
        return this.startupPage;
    }

    public DisplaysHolder getDisplaysHolder() {
        return this.displaysHolder;
    }

    public TextSizeStorage getTextSizeStorage() {
        return this.textSizeStorage;
    }

    public ProbeStore getProbeStore() {
        return this.probeStore;
    }

    private void checkIsNotActivated() {
        if (!this.activated) {
            throw new IllegalStateException("The ApplicationContext has not been activated.");
        }
    }

    private void checkIsActivated() {
        if (this.activated) {
            throw new IllegalStateException("The ApplicationContext has already been activated.");
        }
    }

    private void doActivate() {
        this.themeManager.initialize();
        this.contextConfigurator.configure(this);
        this.activateInstances();
    }

    private void activateInstances() {
        ApplicationContextUtil.runWith(this, new Runnable(){

            public void run() {
                ApplicationContext.this.doActivateInstances();
            }
        });
    }

    private void doActivateInstances() {
        this.lifeCycleFactory.activate();
        this.jsLibraryConcatenator.startJSConcatenation();
        this.themeManager.activate();
        if (!skipResoureRegistration) {
            new ClientResources(this.getResourceManager(), this.themeManager).registerResources();
        }
        this.jsLibraryConcatenator.activate();
    }

    private void doDeactivate() {
        this.deactivateInstances();
        this.contextConfigurator.reset(this);
    }

    private void deactivateInstances() {
        ApplicationContextUtil.runWith(this, new Runnable(){

            public void run() {
                ApplicationContext.this.doDeactivateInstances();
            }
        });
    }

    private void doDeactivateInstances() {
        this.jsLibraryConcatenator.deactivate();
        this.lifeCycleFactory.deactivate();
        this.serviceManager.clear();
        this.themeManager.deactivate();
        if (!skipResoureDeletion) {
            File resourcesDir = new File(this.rwtConfiguration.getContextDirectory(), "rwt-resources");
            ApplicationContextUtil.delete(resourcesDir);
        }
    }

    private ServiceManager createServiceManager() {
        return new ServiceManager(new LifeCycleServiceHandler(this.lifeCycleFactory, this.startupPage));
    }
}

