/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ResourceTranslatorHelper {
    private static final Class[] PARAM_TYPE_ALGORITHM = new Class[]{Runnable.class};
    private static final String METHOD_SET_TRANSLATOR_ALGORITHM = "setTranslatorAlgorithm";
    private static final String FIELD_ALGORITHM_IO = "algorithmIO";
    private static final Class CLASS_REGISTRY_FACTORY = RegistryFactory.class;

    public static void registerAlgorithm() {
        if (ResourceTranslatorHelper.isRWTLocalSpecificTranslationAllowed()) {
            try {
                Object[] param = new Object[]{new TranslatorAlgorithm()};
                ResourceTranslatorHelper.getAlgorithmSetter().invoke(null, param);
            }
            catch (Exception shouldNotHappen) {
                shouldNotHappen.printStackTrace();
            }
        }
    }

    private static boolean isRWTLocalSpecificTranslationAllowed() {
        boolean result = false;
        try {
            ResourceTranslatorHelper.getAlgorithmIO();
            ResourceTranslatorHelper.getAlgorithmSetter();
            result = true;
        }
        catch (Exception exception) {}
        return result;
    }

    private static Method getAlgorithmSetter() throws NoSuchMethodException {
        String name = METHOD_SET_TRANSLATOR_ALGORITHM;
        Class[] type = PARAM_TYPE_ALGORITHM;
        return CLASS_REGISTRY_FACTORY.getDeclaredMethod(name, type);
    }

    private static Field getAlgorithmIO() throws NoSuchFieldException {
        return CLASS_REGISTRY_FACTORY.getDeclaredField(FIELD_ALGORITHM_IO);
    }

    private ResourceTranslatorHelper() {
    }

    private static final class TranslatorAlgorithm
    implements Runnable {
        private TranslatorAlgorithm() {
        }

        public void run() {
            String result = this.getKey();
            ResourceBundle bundle = null;
            if (ContextProvider.hasContext()) {
                bundle = this.getResourceBundle();
            }
            if (bundle != null) {
                result = ResourceTranslator.getResourceString(null, (String)this.getKey(), (ResourceBundle)bundle);
            }
            this.getIOHandle().set(result);
        }

        private ResourceBundle getResourceBundle() {
            Bundle bundle = Platform.getBundle((String)this.getSymbolicName());
            BundleContext bundleContext = bundle.getBundleContext();
            String id = BundleLocalization.class.getName();
            ServiceReference reference = bundleContext.getServiceReference(id);
            BundleLocalization localization = (BundleLocalization)bundleContext.getService(reference);
            return localization.getLocalization(bundle, RWT.getLocale().toString());
        }

        private String getKey() {
            return ((String[])this.getIOHandle().get())[0];
        }

        private String getSymbolicName() {
            return ((String[])this.getIOHandle().get())[1];
        }

        private ThreadLocal getIOHandle() {
            ThreadLocal io = null;
            try {
                io = (ThreadLocal)ResourceTranslatorHelper.getAlgorithmIO().get(null);
            }
            catch (Exception shouldNotHappen) {
                shouldNotHappen.printStackTrace();
            }
            return io;
        }
    }
}

