/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rap.ui.internal.intro.ErrorUtil;
import org.eclipse.rap.ui.internal.intro.target.InstallTargetDialog;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.eclipse.rap.ui.internal.intro.target.TargetSwitcher;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class InstallRAPTargetHandler
extends AbstractHandler {
    private static final ISchedulingRule INSTALL_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell shell = workbench.getActiveWorkbenchWindow().getShell();
        InstallTargetDialog dialog = new InstallTargetDialog(shell);
        int result = dialog.open();
        if (result == 0) {
            InstallRAPTargetHandler.execute(dialog.shouldSwitchTarget(), dialog.getTargetRepository(), dialog.getTargetQualifier(), dialog.getRootIUs());
        }
        return null;
    }

    public static void execute(final boolean switchTarget, final String targetRepository, final String targetQualifier, final String[] rootIUs) {
        Job installTargetJob = new Job(IntroMessages.TargetProvider_Installing){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.CANCEL_STATUS;
                try {
                    TargetSwitcher.install(targetRepository, rootIUs, targetQualifier, switchTarget, monitor);
                    result = Status.OK_STATUS;
                }
                catch (CoreException e) {
                    String msg = IntroMessages.InstallRAPTargetHandler_InstallFailed;
                    result = ErrorUtil.createErrorStatus(msg, e);
                }
                return result;
            }
        };
        installTargetJob.setUser(true);
        installTargetJob.setRule(INSTALL_RULE);
        installTargetJob.schedule();
    }
}

