/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.internal.graphics.GCOperation;
import org.eclipse.swt.internal.graphics.IGCAdapter;

public final class GCAdapter
implements IGCAdapter {
    private final List gcOperations = new LinkedList();
    private boolean forceRedraw;

    public void addGCOperation(GCOperation operation) {
        this.gcOperations.add(operation);
    }

    public GCOperation[] getGCOperations() {
        GCOperation[] result = new GCOperation[this.gcOperations.size()];
        this.gcOperations.toArray(result);
        return result;
    }

    public void clearGCOperations() {
        this.gcOperations.clear();
    }

    public GCOperation[] getTrimmedGCOperations() {
        int counter = 0;
        boolean stop = false;
        GCOperation[] operations = this.getGCOperations();
        int i = operations.length - 1;
        while (i >= 0 && !stop) {
            if (GCAdapter.isDrawOperation(operations[i])) {
                stop = true;
            } else {
                ++counter;
            }
            --i;
        }
        GCOperation[] result = new GCOperation[operations.length - counter];
        System.arraycopy(operations, 0, result, 0, result.length);
        return result;
    }

    public void setForceRedraw(boolean forceRedraw) {
        this.forceRedraw = forceRedraw;
    }

    public boolean getForceRedraw() {
        return this.forceRedraw;
    }

    private static boolean isDrawOperation(GCOperation operation) {
        return !(operation instanceof GCOperation.SetProperty) && !(operation instanceof GCOperation.SetFont);
    }
}

