/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.theme.JsonArray;
import org.eclipse.rwt.internal.theme.JsonObject;
import org.eclipse.rwt.internal.theme.JsonValue;
import org.eclipse.rwt.internal.theme.QxAnimation;
import org.eclipse.rwt.internal.theme.QxBorder;
import org.eclipse.rwt.internal.theme.QxBoxDimensions;
import org.eclipse.rwt.internal.theme.QxColor;
import org.eclipse.rwt.internal.theme.QxCursor;
import org.eclipse.rwt.internal.theme.QxDimension;
import org.eclipse.rwt.internal.theme.QxFont;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxShadow;
import org.eclipse.rwt.internal.theme.QxType;

public final class ThemePropertyAdapterRegistry {
    private static ThemePropertyAdapterRegistry instance = new ThemePropertyAdapterRegistry();
    private final Map map = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    private ThemePropertyAdapterRegistry() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.QxAnimation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz, new AnimationPropertyAdapter());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.rwt.internal.theme.QxBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz2, new DirectPropertyAdapter());
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.rwt.internal.theme.QxBorder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz3, new BorderPropertyAdapter());
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.rwt.internal.theme.QxBoxDimensions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz4, new BoxDimensionsPropertyAdapter());
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.rwt.internal.theme.QxColor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz5, new ColorPropertyAdapter());
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.rwt.internal.theme.QxCursor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz6, new CursorPropertyAdapter());
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.rwt.internal.theme.QxDimension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz7, new DimensionPropertyAdapter());
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.eclipse.rwt.internal.theme.QxFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz8, new DirectPropertyAdapter());
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.eclipse.rwt.internal.theme.QxFont");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz9, new FontPropertyAdapter());
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("org.eclipse.rwt.internal.theme.QxIdentifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz10, new DirectPropertyAdapter());
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("org.eclipse.rwt.internal.theme.QxImage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz11, new ImagePropertyAdapter());
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("org.eclipse.rwt.internal.theme.QxShadow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.map.put(clazz12, new ShadowPropertyAdapter());
    }

    public static ThemePropertyAdapterRegistry getInstance() {
        return instance;
    }

    public ThemePropertyAdapter getPropertyAdapter(Class key) {
        return (ThemePropertyAdapter)this.map.get(key);
    }

    public static class AnimationPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "animations";
        }

        public JsonValue getValue(QxType value) {
            QxAnimation animation = (QxAnimation)value;
            JsonObject result = new JsonObject();
            int j = 0;
            while (j < animation.animations.length) {
                QxAnimation.Animation currentAnimation = animation.animations[j];
                JsonArray currentAnimationArray = new JsonArray();
                currentAnimationArray.append(currentAnimation.duration);
                String timingFunction = QxAnimation.toCamelCaseString(currentAnimation.timingFunction);
                currentAnimationArray.append(timingFunction);
                result.append(currentAnimation.name, currentAnimationArray);
                ++j;
            }
            return result;
        }
    }

    public static class BorderPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "borders";
        }

        public JsonValue getValue(QxType value) {
            QxBorder border = (QxBorder)value;
            JsonObject result = new JsonObject();
            result.append("width", border.width);
            result.append("style", border.style);
            result.append("color", border.color);
            return result;
        }
    }

    public static class BoxDimensionsPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "boxdims";
        }

        public JsonValue getValue(QxType value) {
            QxBoxDimensions boxdim = (QxBoxDimensions)value;
            JsonArray result = new JsonArray();
            result.append(boxdim.top);
            result.append(boxdim.right);
            result.append(boxdim.bottom);
            result.append(boxdim.left);
            return result;
        }
    }

    public static class ColorPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "colors";
        }

        public JsonValue getValue(QxType value) {
            QxColor color = (QxColor)value;
            JsonValue result = color.isTransparent() ? JsonValue.valueOf("undefined") : JsonValue.valueOf(QxColor.toHtmlString(color.red, color.green, color.blue));
            return result;
        }
    }

    public static class CursorPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "cursors";
        }

        public JsonValue getValue(QxType value) {
            QxCursor cursor = (QxCursor)value;
            JsonValue result = cursor.isCustomCursor() ? JsonValue.NULL : JsonValue.valueOf(cursor.value);
            return result;
        }
    }

    public static class DimensionPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "dimensions";
        }

        public JsonValue getValue(QxType value) {
            return JsonValue.valueOf(((QxDimension)value).value);
        }
    }

    public static class DirectPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return value.toDefaultString();
        }

        public String getSlot(QxType value) {
            return null;
        }

        public JsonValue getValue(QxType value) {
            return null;
        }
    }

    public static class FontPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "fonts";
        }

        public JsonValue getValue(QxType value) {
            QxFont font = (QxFont)value;
            JsonObject result = new JsonObject();
            result.append("family", JsonArray.valueOf(font.family));
            result.append("size", font.size);
            result.append("bold", font.bold);
            result.append("italic", font.italic);
            return result;
        }
    }

    public static class ImagePropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            QxImage image = (QxImage)value;
            String result = image.isGradient() ? "gradients" : "images";
            return result;
        }

        public JsonValue getValue(QxType value) {
            QxImage image = (QxImage)value;
            JsonValue result = null;
            if (image.isGradient()) {
                JsonObject gradientObject = null;
                gradientObject = new JsonObject();
                JsonArray percents = JsonArray.valueOf(image.gradientPercents);
                gradientObject.append("percents", percents);
                JsonArray colors = JsonArray.valueOf(image.gradientColors);
                gradientObject.append("colors", colors);
                gradientObject.append("vertical", image.vertical);
                result = gradientObject;
            } else if (!image.none) {
                JsonArray imageArray = new JsonArray();
                imageArray.append(image.width);
                imageArray.append(image.height);
                result = imageArray;
            }
            return result;
        }
    }

    public static class ShadowPropertyAdapter
    implements ThemePropertyAdapter {
        public String getKey(QxType value) {
            return Integer.toHexString(value.hashCode());
        }

        public String getSlot(QxType value) {
            return "shadows";
        }

        public JsonValue getValue(QxType value) {
            JsonValue result;
            QxShadow shadow = (QxShadow)value;
            if (shadow.equals(QxShadow.NONE)) {
                result = JsonValue.NULL;
            } else {
                JsonArray array = new JsonArray();
                array.append(shadow.inset);
                array.append(shadow.offsetX);
                array.append(shadow.offsetY);
                array.append(shadow.blur);
                array.append(shadow.spread);
                array.append(shadow.color);
                array.append(shadow.opacity);
                result = array;
            }
            return result;
        }
    }

    public static interface ThemePropertyAdapter {
        public String getSlot(QxType var1);

        public String getKey(QxType var1);

        public JsonValue getValue(QxType var1);
    }
}

