/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.rap.demo.controls.ColorChooser;
import org.eclipse.rap.demo.controls.SimpleFontDialog;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

abstract class ExampleTab {
    private boolean contentCreated;
    private final CTabFolder folder;
    protected final List controls;
    private Composite exmplComp;
    protected Composite styleComp;
    protected Color[] bgColors;
    protected Color[] fgColors;
    private Font font;
    private int fgIndex;
    private int bgIndex;
    private int rbIndex;
    private boolean showBgImage = false;
    private boolean showBgGradient = false;
    private boolean visible = true;
    private boolean enabled = true;
    private Text text;
    private final StringBuffer content = new StringBuffer();
    private SimpleFontDialog fontChooser;
    private ColorChooser fgColorChooser;
    private ColorChooser bgColorChooser;
    private int defaultStyle = 0;
    private final CTabItem item;
    private final Set properties = new HashSet();
    public static final Color BG_COLOR_GREEN = Graphics.getColor((int)154, (int)205, (int)50);
    public static final Color BG_COLOR_BLUE = Graphics.getColor((int)105, (int)89, (int)205);
    public static final Color BG_COLOR_BROWN = Graphics.getColor((int)192, (int)172, (int)137);
    public static final Color FG_COLOR_RED = Graphics.getColor((int)194, (int)0, (int)23);
    public static final Color FG_COLOR_BLUE = Graphics.getColor((int)28, (int)96, (int)141);
    public static final Color FG_COLOR_ORANGE = Graphics.getColor((int)249, (int)158, (int)0);
    public static final Color BGG_COLOR_GREEN = Graphics.getColor((int)0, (int)255, (int)0);
    public static final Color BGG_COLOR_BLUE = Graphics.getColor((int)0, (int)0, (int)255);
    private static final String[] SWT_CURSORS = new String[]{"null", "CURSOR_ARROW", "CURSOR_WAIT", "CURSOR_APPSTARTING", "CURSOR_CROSS", "CURSOR_HELP", "CURSOR_NO", "CURSOR_SIZEALL", "CURSOR_SIZENESW", "CURSOR_SIZENS", "CURSOR_SIZENWSE", "CURSOR_SIZEWE", "CURSOR_SIZEN", "CURSOR_SIZES", "CURSOR_SIZEE", "CURSOR_SIZEW", "CURSOR_SIZENE", "CURSOR_SIZESE", "CURSOR_SIZESW", "CURSOR_SIZENW", "CURSOR_IBEAM", "CURSOR_HAND", "CURSOR_UPARROW"};
    public static Image BG_PATTERN_IMAGE;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rap.demo.controls.ExampleTab");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BG_PATTERN_IMAGE = Graphics.getImage((String)"resources/pattern.png", (ClassLoader)clazz.getClassLoader());
    }

    public ExampleTab(CTabFolder parent, String title) {
        this.folder = parent;
        this.controls = new ArrayList();
        this.item = new CTabItem(this.folder, 0);
        this.item.setText(String.valueOf(title) + " ");
    }

    public void createContents() {
        if (!this.contentCreated) {
            Control sashForm = this.createSashForm();
            this.item.setControl(sashForm);
            this.initColors();
            this.createExampleControls(this.exmplComp);
            this.createStyleControls(this.styleComp);
            this.exmplComp.layout();
            this.styleComp.layout();
            this.contentCreated = true;
        }
    }

    protected void createNew() {
        this.controls.clear();
        this.destroyExampleControls();
        this.createExampleControls(this.exmplComp);
        this.updateVisible();
        this.updateEnabled();
        if (this.fgColorChooser != null) {
            this.updateFgColor();
        }
        if (this.bgColorChooser != null) {
            this.updateBgColor();
        }
        this.updateBgImage();
        this.updateBgGradient();
        if (this.fontChooser != null) {
            this.updateFont();
        }
        this.exmplComp.layout();
    }

    private Control createSashForm() {
        SashForm vertSashForm = new SashForm((Composite)this.folder, 512);
        SashForm horSashForm = new SashForm((Composite)vertSashForm, 256);
        Composite leftComp = new Composite((Composite)horSashForm, 0);
        Composite rightComp = new Composite((Composite)horSashForm, 0);
        Composite footComp = new Composite((Composite)vertSashForm, 0);
        this.createLeft(leftComp);
        this.createRight(rightComp);
        this.createFoot(footComp);
        horSashForm.setWeights(new int[]{60, 40});
        vertSashForm.setWeights(new int[]{95, 5});
        return vertSashForm;
    }

    private void createLeft(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Group exmplGroup = new Group(parent, 0);
        exmplGroup.setLayout((Layout)new FillLayout());
        this.exmplComp = new Composite((Composite)exmplGroup, 0);
    }

    private void createRight(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Group styleGroup = new Group(parent, 0);
        styleGroup.setText("Styles and Parameters");
        styleGroup.setLayout((Layout)new FillLayout());
        this.styleComp = new Composite((Composite)styleGroup, 0);
        this.styleComp.setLayout((Layout)new RowLayout(512));
    }

    private void createFoot(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.text = new Text(parent, 2058);
        this.text.setText("---");
    }

    private void initColors() {
        Color[] colorArray = new Color[4];
        colorArray[1] = BG_COLOR_GREEN;
        colorArray[2] = BG_COLOR_BLUE;
        colorArray[3] = BG_COLOR_BROWN;
        this.bgColors = colorArray;
        Color[] colorArray2 = new Color[4];
        colorArray2[1] = FG_COLOR_RED;
        colorArray2[2] = FG_COLOR_BLUE;
        colorArray2[3] = FG_COLOR_ORANGE;
        this.fgColors = colorArray2;
    }

    protected abstract void createStyleControls(Composite var1);

    protected abstract void createExampleControls(Composite var1);

    protected void setDefaultStyle(int style) {
        this.defaultStyle = style;
    }

    protected Button createStyleButton(String fieldName, int style) {
        return this.createStyleButton(fieldName, style, false);
    }

    protected Button createStyleButton(String name, int style, boolean checked) {
        Button button = new Button(this.styleComp, 32);
        button.setText(name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.createNew();
            }
        });
        button.setData("style", (Object)new Integer(style));
        button.setSelection(checked);
        return button;
    }

    protected Button createPropertyButton(String text) {
        return this.createPropertyButton(text, 32);
    }

    protected Button createPropertyButton(String text, int style) {
        Button button = new Button(this.styleComp, style);
        button.setText(text);
        return button;
    }

    protected Button createPropertyCheckbox(String text, String prop) {
        return this.createPropertyCheckbox(text, prop, false);
    }

    protected Button createPropertyCheckbox(String text, final String prop, boolean checked) {
        final Button button = new Button(this.styleComp, 32);
        button.setText(text);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    ExampleTab.this.properties.add(prop);
                } else {
                    ExampleTab.this.properties.remove(prop);
                }
                ExampleTab.this.createNew();
            }
        });
        return button;
    }

    public final boolean hasCreateProperty(String name) {
        return this.properties.contains(name);
    }

    protected Button createVisibilityButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Visible");
        button.setSelection(this.visible);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.visible = button.getSelection();
                ExampleTab.this.updateVisible();
            }
        });
        return button;
    }

    protected Button createEnablementButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Enabled");
        button.setSelection(this.enabled);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.enabled = button.getSelection();
                ExampleTab.this.updateEnabled();
            }
        });
        return button;
    }

    protected Button createFgColorButton() {
        this.fgColorChooser = new ColorChooser();
        Button button = new Button(this.styleComp, 8);
        button.setText("Foreground");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.fgIndex = (ExampleTab.this.fgIndex + 1) % ExampleTab.this.fgColors.length;
                ExampleTab.this.updateFgColor();
            }
        });
        return button;
    }

    protected Button createBgColorButton() {
        this.bgColorChooser = new ColorChooser();
        Button button = new Button(this.styleComp, 8);
        button.setText("Background");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.bgIndex = (ExampleTab.this.bgIndex + 1) % ExampleTab.this.fgColors.length;
                ExampleTab.this.updateBgColor();
            }
        });
        return button;
    }

    protected Button createBgGradientButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Background Gradient");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.showBgGradient = button.getSelection();
                ExampleTab.this.updateBgGradient();
            }
        });
        return button;
    }

    protected Button createBgImageButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Background Image");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.showBgImage = button.getSelection();
                ExampleTab.this.updateBgImage();
            }
        });
        return button;
    }

    protected Button createFontChooser() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Font");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.fontChooser = new SimpleFontDialog(ExampleTab.this.getShell());
                Control control = (Control)ExampleTab.this.controls.get(0);
                ExampleTab.this.fontChooser.setFont(control.getFont());
                ExampleTab.this.fontChooser.open(new Runnable(this){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        ExampleTab.access$17(9.access$0(this.this$1), ExampleTab.access$16(9.access$0(this.this$1)).getFont());
                        ExampleTab.access$18(9.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ ExampleTab access$0(9 var0) {
                return var0.ExampleTab.this;
            }
        });
        return button;
    }

    protected void createThemeSwitcher(final Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Theme Switcher");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = new Shell(parent.getShell(), 2144);
                shell.setText("Theme Switcher");
                shell.setLayout((Layout)new GridLayout());
                Button themeButton = new Button((Composite)shell, 8);
                themeButton.setText("Switch Theme");
                themeButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    String[] availableThemeIds;
                    final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                        this.availableThemeIds = ThemeUtil.getAvailableThemeIds();
                    }

                    public void widgetSelected(SelectionEvent e) {
                        int index = 0;
                        String currThemeId = ThemeUtil.getCurrentThemeId();
                        int i = 0;
                        while (i < this.availableThemeIds.length) {
                            if (currThemeId.equals(this.availableThemeIds[i])) {
                                index = (i + 1) % this.availableThemeIds.length;
                            }
                            ++i;
                        }
                        String newThemeId = this.availableThemeIds[index];
                        ThemeUtil.setCurrentThemeId((String)newThemeId);
                    }
                });
                shell.pack();
                shell.open();
            }
        });
    }

    protected Combo createCursorCombo() {
        Composite group = new Composite(this.styleComp, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        new Label(group, 0).setText("Cursor");
        final Combo combo = new Combo(group, 8);
        combo.setItems(SWT_CURSORS);
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = null;
                int index = combo.getSelectionIndex();
                if (index > 0) {
                    selection = combo.getItem(index);
                }
                ExampleTab.this.updateCursor(selection);
            }
        });
        return combo;
    }

    protected void cteateRoundedBorderGroup() {
        Group group = new Group(this.styleComp, 0);
        group.setText("Rounded Border");
        group.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)group, 0).setText("Width");
        final Text textWidth = new Text((Composite)group, 2052);
        textWidth.setLayoutData((Object)new GridData(20, -1));
        new Label((Composite)group, 0).setText("Color");
        final Button buttonColor = new Button((Composite)group, 8);
        buttonColor.setLayoutData((Object)new GridData(20, 20));
        buttonColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExampleTab.this.rbIndex = (ExampleTab.this.rbIndex + 1) % ExampleTab.this.bgColors.length;
                if (ExampleTab.this.bgColors[ExampleTab.this.rbIndex] == null) {
                    buttonColor.setText("");
                } else {
                    buttonColor.setText("\u2588");
                }
                buttonColor.setForeground(ExampleTab.this.bgColors[ExampleTab.this.rbIndex]);
            }
        });
        new Label((Composite)group, 0).setText("Radius ");
        Composite radiusGroup = new Composite((Composite)group, 0);
        radiusGroup.setLayout((Layout)new GridLayout(4, false));
        new Label(radiusGroup, 0).setText("T-L");
        final Text textTopLeft = new Text(radiusGroup, 2052);
        textTopLeft.setLayoutData((Object)new GridData(20, -1));
        new Label(radiusGroup, 0).setText("T-R");
        final Text textTopRight = new Text(radiusGroup, 2052);
        textTopRight.setLayoutData((Object)new GridData(20, -1));
        new Label(radiusGroup, 0).setText("B-L");
        final Text textBottomLeft = new Text(radiusGroup, 2052);
        textBottomLeft.setLayoutData((Object)new GridData(20, -1));
        new Label(radiusGroup, 0).setText("B-R");
        final Text textBottomRight = new Text(radiusGroup, 2052);
        textBottomRight.setLayoutData((Object)new GridData(20, -1));
        Button button = new Button((Composite)group, 8);
        button.setText("Set");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int width = ExampleTab.this.parseInt(textWidth.getText());
                Color color = buttonColor.getForeground();
                int topLeft = ExampleTab.this.parseInt(textTopLeft.getText());
                int topRight = ExampleTab.this.parseInt(textTopRight.getText());
                int bottomRight = ExampleTab.this.parseInt(textBottomRight.getText());
                int bottomLeft = ExampleTab.this.parseInt(textBottomLeft.getText());
                ExampleTab.this.updateRoundedBorder(width, color, topLeft, topRight, bottomRight, bottomLeft);
            }
        });
    }

    protected void registerControl(Control control) {
        this.controls.add(control);
    }

    protected void log(String msg) {
        this.content.insert(0, String.valueOf(msg.trim()) + this.text.getLineDelimiter());
        this.text.setText(this.content.toString());
    }

    private void destroyExampleControls() {
        Control[] controls = this.exmplComp.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
    }

    protected int getStyle() {
        int result = 0;
        Control[] ctrls = this.styleComp.getChildren();
        if (ctrls.length == 0) {
            result = this.defaultStyle;
        } else {
            int i = 0;
            while (i < ctrls.length) {
                Object data;
                Button button;
                if (ctrls[i] instanceof Button && (button = (Button)ctrls[i]).getSelection() && (data = button.getData("style")) instanceof Integer) {
                    int style = (Integer)data;
                    result |= style;
                }
                ++i;
            }
        }
        return result;
    }

    private void updateVisible() {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            control.setVisible(this.visible);
        }
    }

    private void updateEnabled() {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            control.setEnabled(this.enabled);
        }
    }

    private void updateFgColor() {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            control.setForeground(this.fgColors[this.fgIndex]);
        }
    }

    private void updateBgColor() {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            control.setBackground(this.bgColors[this.bgIndex]);
        }
    }

    private void updateBgGradient() {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = control.getAdapter((Class)clazz);
            IWidgetGraphicsAdapter gfxAdapter = (IWidgetGraphicsAdapter)adapter;
            if (this.showBgGradient) {
                Color[] gradientColors = new Color[]{BGG_COLOR_BLUE, BGG_COLOR_GREEN, BGG_COLOR_BLUE, BGG_COLOR_GREEN, BGG_COLOR_BLUE};
                int[] nArray = new int[5];
                nArray[1] = 25;
                nArray[2] = 50;
                nArray[3] = 75;
                nArray[4] = 100;
                int[] percents = nArray;
                gfxAdapter.setBackgroundGradient(gradientColors, percents, true);
                continue;
            }
            gfxAdapter.setBackgroundGradient(null, null, true);
        }
    }

    private void updateBgImage() {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            control.setBackgroundImage((Image)(this.showBgImage ? BG_PATTERN_IMAGE : null));
        }
    }

    private void updateFont() {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            control.setFont(this.font);
        }
        if (this.controls.size() > 0) {
            Composite parent = ((Control)this.controls.get(0)).getParent();
            parent.layout(true, true);
        }
    }

    private void updateCursor(String selection) {
        Cursor cursor = null;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.SWT");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> swtClass = clazz;
        if (selection != null) {
            try {
                Field field = swtClass.getField(selection);
                int cursorStyle = field.getInt(swtClass);
                cursor = Display.getCurrent().getSystemCursor(cursorStyle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            control.setCursor(cursor);
        }
    }

    private void updateRoundedBorder(int width, Color color, int topLeft, int topRight, int bottomRight, int bottomLeft) {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = control.getAdapter((Class)clazz);
            IWidgetGraphicsAdapter gfxAdapter = (IWidgetGraphicsAdapter)adapter;
            gfxAdapter.setRoundedBorder(width, color, topLeft, topRight, bottomRight, bottomLeft);
        }
    }

    private int parseInt(String text) {
        int result;
        try {
            result = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            result = -1;
        }
        return result;
    }

    protected Shell getShell() {
        return this.folder.getShell();
    }

    static /* synthetic */ void access$17(ExampleTab exampleTab, Font font) {
        exampleTab.font = font;
    }

    static /* synthetic */ void access$18(ExampleTab exampleTab) {
        exampleTab.updateFont();
    }
}

