/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import com.yahoo.platform.yui.compressor.JavaScriptToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rwt.internal.resources.TokenList;

public final class QxCodeCleaner {
    private final TokenList tokens;
    private final List replacements;

    public QxCodeCleaner(TokenList tokens) {
        this.tokens = tokens;
        this.replacements = new ArrayList();
    }

    public void cleanupQxCode() {
        int pos = 0;
        while (pos < this.tokens.size()) {
            int nextPos = this.removeVariantConditional(pos);
            if (nextPos == pos) {
                nextPos = this.replaceVariantSelection(pos);
            }
            if (nextPos == pos) {
                nextPos = this.replaceBaseCall(pos);
            }
            if (nextPos == pos) {
                // empty if block
            }
            pos = ++nextPos;
        }
        this.doReplacements();
    }

    private int removeVariantConditional(int offset) {
        int endExpr;
        int nextPos = offset;
        VariantConditional conditional = this.readVariantConditional(offset);
        if (conditional != null && QxCodeCleaner.canRemoveVariant(conditional.variant) && (endExpr = this.tokens.readExpression(conditional.end + 1)) != -1) {
            this.markTokensForRemoval(conditional.begin, endExpr);
            nextPos = endExpr + 1;
            if (TokenList.TokenMatcher.ELSE.matches(this.tokens.getToken(nextPos))) {
                int closingBrace;
                this.markTokensForRemoval(nextPos, nextPos);
                if (TokenList.TokenMatcher.LEFT_BRACE.matches(this.tokens.getToken(++nextPos)) && (closingBrace = this.tokens.findClosing(nextPos)) != -1) {
                    this.markTokensForRemoval(nextPos, nextPos);
                    this.markTokensForRemoval(closingBrace, closingBrace);
                    ++nextPos;
                }
            }
        }
        return nextPos;
    }

    private int replaceVariantSelection(int offset) {
        int closingBrace;
        int nextPos = offset;
        VariantSelection selection = this.readVariantSelection(offset);
        if (selection != null && (closingBrace = this.tokens.findClosing(selection.end)) != -1 && TokenList.TokenMatcher.RIGHT_PAREN.matches(this.tokens.getToken(closingBrace + 1))) {
            int endExpression;
            int selectedExpression;
            int closingParen = closingBrace + 1;
            nextPos = selection.end + 1;
            if (QxCodeCleaner.canRemoveVariant(selection.variant) && (selectedExpression = this.tokens.findInObjectLiteral("off", selection.end)) != -1 && (endExpression = this.tokens.readExpression(selectedExpression)) != -1) {
                this.markTokensForRemoval(offset, selectedExpression - 1);
                this.markTokensForRemoval(endExpression + 1, closingParen);
                nextPos = closingParen + 1;
            }
        }
        return nextPos;
    }

    private int replaceBaseCall(int offset) {
        int nextPos = offset;
        Range baseCall = this.readBaseCall(offset);
        if (baseCall != null) {
            JavaScriptToken[] replacement = new JavaScriptToken[]{new JavaScriptToken(38, "arguments"), new JavaScriptToken(104, "."), new JavaScriptToken(38, "callee"), new JavaScriptToken(104, "."), new JavaScriptToken(38, "base"), new JavaScriptToken(104, "."), new JavaScriptToken(38, "call"), new JavaScriptToken(83, "("), new JavaScriptToken(38, "this")};
            this.markRangeForReplacement(baseCall, replacement);
            nextPos = baseCall.end + 1;
        }
        return nextPos;
    }

    private int markTokensForRemoval(int first, int last) {
        this.replacements.add(new Replacement(first, last, null));
        return last - first + 1;
    }

    private void markRangeForReplacement(Range range, JavaScriptToken[] replacementTokens) {
        this.replacements.add(new Replacement(range.begin, range.end, replacementTokens));
    }

    private void doReplacements() {
        Collections.sort(this.replacements, new Comparator(){

            public int compare(Object o1, Object o2) {
                Replacement repl1 = (Replacement)o1;
                Replacement repl2 = (Replacement)o2;
                return repl1.end < repl2.end ? 1 : (repl1.end == repl2.end ? 0 : -1);
            }
        });
        Iterator iterator = this.replacements.iterator();
        while (iterator.hasNext()) {
            Replacement replacement = (Replacement)iterator.next();
            this.tokens.replaceTokens(replacement.begin, replacement.end, replacement.replacement);
        }
    }

    private static boolean canRemoveVariant(String variantName) {
        return "qx.debug".equals(variantName) || "qx.compatibility".equals(variantName) || "qx.aspects".equals(variantName);
    }

    VariantConditional readVariantConditional(int offset) {
        VariantConditional result = null;
        int pos = offset;
        boolean matched = true;
        TokenList.TokenMatcher nameMatcher = TokenList.TokenMatcher.string();
        matched &= TokenList.TokenMatcher.IF.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.LEFT_PAREN.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.name("qx").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.DOT.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.name("core").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.DOT.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.name("Variant").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.DOT.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.name("isSet").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.LEFT_PAREN.matches(this.tokens.getToken(pos++));
        matched &= nameMatcher.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.COMMA.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.string("on").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.RIGHT_PAREN.matches(this.tokens.getToken(pos++));
        if (matched &= TokenList.TokenMatcher.RIGHT_PAREN.matches(this.tokens.getToken(pos++))) {
            result = new VariantConditional(offset, pos - 1, nameMatcher.matchedValue);
        }
        return result;
    }

    VariantSelection readVariantSelection(int offset) {
        VariantSelection result = null;
        int pos = offset;
        boolean matched = true;
        TokenList.TokenMatcher nameMatcher = TokenList.TokenMatcher.string();
        matched &= TokenList.TokenMatcher.name("qx").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.DOT.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.name("core").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.DOT.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.name("Variant").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.DOT.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.name("select").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.LEFT_PAREN.matches(this.tokens.getToken(pos++));
        matched &= nameMatcher.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.COMMA.matches(this.tokens.getToken(pos++));
        if (matched &= TokenList.TokenMatcher.LEFT_BRACE.matches(this.tokens.getToken(pos++))) {
            result = new VariantSelection(offset, pos - 1, nameMatcher.matchedValue);
        }
        return result;
    }

    Range readBaseCall(int offset) {
        Range result = null;
        int pos = offset;
        boolean matched = true;
        TokenList.TokenMatcher nameMatcher = TokenList.TokenMatcher.name("arguments");
        matched &= TokenList.TokenMatcher.literal(42).matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.DOT.matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.name("base").matches(this.tokens.getToken(pos++));
        matched &= TokenList.TokenMatcher.LEFT_PAREN.matches(this.tokens.getToken(pos++));
        if (matched &= nameMatcher.matches(this.tokens.getToken(pos++))) {
            result = new Range(offset, pos - 1);
        }
        return result;
    }

    public static class Range {
        public final int begin;
        public final int end;

        public Range(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }
    }

    public static class Replacement
    extends Range {
        public final JavaScriptToken[] replacement;

        public Replacement(int begin, int end, JavaScriptToken[] replacement) {
            super(begin, end);
            this.replacement = replacement;
        }
    }

    static class VariantConditional
    extends Range {
        public final String variant;

        public VariantConditional(int begin, int end, String variant) {
            super(begin, end);
            this.variant = variant;
        }
    }

    static class VariantSelection
    extends Range {
        public final String variant;

        public VariantSelection(int begin, int end, String variant) {
            super(begin, end);
            this.variant = variant;
        }
    }
}

