/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.AdapterFactory;
import org.eclipse.rwt.internal.util.ParamCheck;

class AdapterFactoryRegistry {
    private final Object lock = new Object();
    private final Map registry = new HashMap();
    static /* synthetic */ Class class$0;

    AdapterFactoryRegistry() {
    }

    void register(Class adaptableClass, AdapterFactory adapterFactory) {
        ParamCheck.notNull(adapterFactory, "adapterFactory");
        ParamCheck.notNull(adaptableClass, "adaptableClass");
        AdapterFactoryRegistry.checkAdaptableClassImplementsAdaptable(adaptableClass);
        this.registerInternal(adaptableClass, adapterFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInternal(Class adaptableClass, AdapterFactory adapterFactory) {
        Object object = this.lock;
        synchronized (object) {
            List<AdapterFactory> adapterFactories;
            if (this.registry.containsKey(adaptableClass)) {
                adapterFactories = (List)this.registry.get(adaptableClass);
            } else {
                adapterFactories = new ArrayList();
                this.registry.put(adaptableClass, adapterFactories);
            }
            if (!adapterFactories.contains(adapterFactory)) {
                adapterFactories.add(adapterFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class[] getAdaptableClasses() {
        Object object = this.lock;
        synchronized (object) {
            Set adaptableClasses = this.registry.keySet();
            Class[] result = new Class[adaptableClasses.size()];
            adaptableClasses.toArray(result);
            return result;
        }
    }

    AdapterFactory[] getAdapterFactories(Class adaptableClass) {
        List adapterFactories = this.getAdapterFacoriesList(adaptableClass);
        AdapterFactory[] result = new AdapterFactory[adapterFactories.size()];
        adapterFactories.toArray(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getAdapterFacoriesList(Class adaptableClass) {
        List result;
        Object object = this.lock;
        synchronized (object) {
            result = this.registry.containsKey(adaptableClass) ? (List)this.registry.get(adaptableClass) : Collections.EMPTY_LIST;
        }
        return result;
    }

    private static void checkAdaptableClassImplementsAdaptable(Class adaptableClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.Adaptable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(adaptableClass)) {
            String text = "The adaptableClass must implement {0}.";
            Object[] objectArray = new Object[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.rwt.Adaptable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            objectArray[0] = clazz2.getName();
            String msg = MessageFormat.format(text, objectArray);
            throw new IllegalArgumentException(msg);
        }
    }
}

