/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.labelkit;

import java.io.IOException;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.labelkit.AbstractLabelLCADelegate;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

final class StandardLabelLCA
extends AbstractLabelLCADelegate {
    private static final String QX_TYPE = "qx.ui.basic.Atom";
    private static final String PROP_TEXT = "text";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_IMAGE = "image";
    private static final String JS_FUNC_LABEL_UTIL_SET_ALIGNMENT = "org.eclipse.swt.LabelUtil.setAlignment";
    private static final String JS_FUNC_LABEL_UTIL_SET_IMAGE = "org.eclipse.swt.LabelUtil.setImage";
    private static final String JS_FUNC_LABEL_UTIL_SET_TEXT = "org.eclipse.swt.LabelUtil.setText";
    private static final Integer DEFAULT_ALIGNMENT = new Integer(16384);

    StandardLabelLCA() {
    }

    void preserveValues(Label label) {
        ControlLCAUtil.preserveValues((Control)label);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)label);
        adapter.preserve(PROP_TEXT, (Object)label.getText());
        adapter.preserve(PROP_IMAGE, (Object)label.getImage());
        adapter.preserve(PROP_ALIGNMENT, (Object)new Integer(label.getAlignment()));
        WidgetLCAUtil.preserveCustomVariant((Widget)label);
    }

    void readData(Label label) {
        ControlLCAUtil.processMouseEvents((Control)label);
        ControlLCAUtil.processKeyEvents((Control)label);
        ControlLCAUtil.processMenuDetect((Control)label);
        WidgetLCAUtil.processHelp((Widget)label);
    }

    void renderInitialization(Label label) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)label);
        writer.newWidget(QX_TYPE);
        ControlLCAUtil.writeStyleFlags((Control)label);
        Boolean wrap = (label.getStyle() & 0x40) != 0;
        Object[] args = new Object[]{label};
        writer.callStatic("org.eclipse.swt.LabelUtil.initialize", args);
        Object[] argsWrap = new Object[]{label, wrap};
        writer.callStatic("org.eclipse.swt.LabelUtil.setWrap", argsWrap);
    }

    void renderChanges(Label label) throws IOException {
        ControlLCAUtil.writeChanges((Control)label);
        StandardLabelLCA.writeText(label);
        StandardLabelLCA.writeImage(label);
        StandardLabelLCA.writeAlignment(label);
        WidgetLCAUtil.writeCustomVariant((Widget)label);
    }

    private static void writeText(Label label) throws IOException {
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_TEXT, label.getText(), "")) {
            String text = WidgetLCAUtil.escapeText(label.getText(), true);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            text = EncodingUtil.replaceWhiteSpaces((String)text);
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            Object[] args = new Object[]{label, text};
            writer.callStatic(JS_FUNC_LABEL_UTIL_SET_TEXT, args);
        }
    }

    private static void writeImage(Label label) throws IOException {
        Image image = label.getImage();
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_IMAGE, image, null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            String imagePath = image == null ? null : ImageFactory.getImagePath((Image)image);
            Object[] args = new Object[]{label, imagePath};
            writer.callStatic(JS_FUNC_LABEL_UTIL_SET_IMAGE, args);
        }
    }

    private static void writeAlignment(Label label) throws IOException {
        Integer defValue;
        Integer alignment = new Integer(label.getAlignment());
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_ALIGNMENT, alignment, defValue = DEFAULT_ALIGNMENT)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            Object[] args = new Object[]{label, StandardLabelLCA.getAlignment(label.getAlignment())};
            writer.callStatic(JS_FUNC_LABEL_UTIL_SET_ALIGNMENT, args);
        }
    }

    private static String getAlignment(int alignment) {
        String result = (alignment & 0x4000) != 0 ? "left" : ((alignment & 0x1000000) != 0 ? "center" : ((alignment & 0x20000) != 0 ? "right" : "left"));
        return result;
    }
}

