/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lbc.internal.base.acquire.AcquiredGrantsStorage;
import org.eclipse.passage.lbc.internal.base.acquire.FeatureGrants;
import org.eclipse.passage.lbc.internal.base.api.Grants;
import org.eclipse.passage.lic.floating.model.api.FeatureGrant;
import org.eclipse.passage.lic.floating.model.api.GrantAcqisition;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;

public final class AcquiredGrants
implements Grants {
    private final AcquiredGrantsStorage storage;
    private final Supplier<Path> base;

    public AcquiredGrants(Supplier<Path> base) {
        this.base = base;
        this.storage = new AcquiredGrantsStorage();
    }

    public AcquiredGrants() {
        this((Supplier<Path>)new LicensingFolder((Supplier)new UserHomePath()));
    }

    @Override
    public Optional<GrantAcqisition> acquire(LicensedProduct product, String user, String feature) throws LicensingException {
        Collection<FeatureGrant> grants = new FeatureGrants(product, user, feature, this.base).get();
        if (grants.isEmpty()) {
            return Optional.empty();
        }
        for (FeatureGrant grant : grants) {
            Optional<GrantAcqisition> acquisition = this.storage.acquire(product, user, grant);
            if (!acquisition.isPresent()) continue;
            return acquisition;
        }
        return Optional.empty();
    }

    @Override
    public boolean release(LicensedProduct product, GrantAcqisition acquisition) {
        return this.storage.release(product, acquisition);
    }
}

