/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox;

import java.util.Optional;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.equinox.LicensedProductFromContext;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class LicensedApplication {
    public LicensedProduct product() throws LicensingException {
        BundleContext context = this.context();
        ServiceReference<IApplicationContext> reference = this.reference(context);
        LicensedProduct product = this.product(context, reference);
        context.ungetService(reference);
        return product;
    }

    private BundleContext context() throws LicensingException {
        Optional<BundleContext> context = Optional.ofNullable(FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        if (!context.isPresent()) {
            throw new LicensingException(EquinoxMessages.LicensedApplication_no_bundle_context);
        }
        return context.get();
    }

    private ServiceReference<IApplicationContext> reference(BundleContext context) throws LicensingException {
        Optional<ServiceReference> reference = Optional.ofNullable(context.getServiceReference(IApplicationContext.class));
        if (!reference.isPresent()) {
            throw new LicensingException(EquinoxMessages.LicensedApplication_no_application_context_service_ref);
        }
        return reference.get();
    }

    private LicensedProduct product(BundleContext context, ServiceReference<IApplicationContext> reference) throws LicensingException {
        Optional<IApplicationContext> service = Optional.ofNullable((IApplicationContext)context.getService(reference));
        if (!service.isPresent()) {
            throw new LicensingException(EquinoxMessages.LicensedApplication_application_context_service_unregistered);
        }
        return new LicensedProductFromContext(service.get()).get();
    }
}

