/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.passage.lbc.internal.api.BackendServerConfiguration;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransportRegistry;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.api.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.internal.api.io.StreamCodec;
import org.eclipse.passage.lic.internal.api.io.StreamCodecRegistry;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.base.registry.ReadOnlyRegistry;

public class BaseServerConfiguration
implements BackendServerConfiguration {
    private final Registry<LicensedProduct, StreamCodec> codecs;
    private final Registry<LicensedProduct, KeyKeeper> keys;
    private final Registry<ContentType, ConditionTransport> transports;

    public BaseServerConfiguration(Collection<StreamCodec> codecs, Collection<KeyKeeper> keys, Collection<ConditionTransport> transports) {
        this.codecs = new ReadOnlyRegistry(codecs);
        this.keys = new ReadOnlyRegistry(keys);
        this.transports = new ReadOnlyRegistry(transports);
    }

    public StreamCodecRegistry codecs() {
        return () -> this.codecs;
    }

    public KeyKeeperRegistry keyKeepers() {
        return () -> this.keys;
    }

    public ConditionTransportRegistry transports() {
        return () -> this.transports;
    }

    public static BackendServerConfiguration empty() {
        return new BaseServerConfiguration(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }
}

