/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.base.io.FileNameFromLicensedProduct;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.equinox.BundleResource;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.osgi.framework.Bundle;

public final class BundleKeyKeeper
implements KeyKeeper {
    private final Supplier<LicensedProduct> product;
    private final Bundle bundle;
    private final String midpath;

    public BundleKeyKeeper(Supplier<LicensedProduct> product, Bundle bundle) {
        this(product, bundle, "OSGI-INF");
    }

    public BundleKeyKeeper(Supplier<LicensedProduct> product, Bundle bundle, String midpath) {
        Objects.requireNonNull(product, "BundleKeyKeeper::product");
        Objects.requireNonNull(bundle, "BundleKeyKeeper::bundle");
        this.product = product;
        this.bundle = bundle;
        this.midpath = midpath;
    }

    public LicensedProduct id() {
        return this.product.get();
    }

    public InputStream productPublicKey() throws LicensingException {
        URL resource = this.resource(Paths.get(this.midpath, new String[0]).resolve(this.keyFile()));
        try {
            return resource.openStream();
        }
        catch (IOException e) {
            throw new LicensingException(String.format(EquinoxMessages.BundleKeyKeeper_failed_to_open_stream, this.product.get(), resource.toString()));
        }
    }

    private URL resource(Path path) throws LicensingException {
        Object url = new BundleResource(this.bundle, path).get();
        if (!((Optional)url).isPresent()) {
            throw new LicensingException(String.format(EquinoxMessages.BundleKeyKeeper_failed_to_find_file, this.product.get(), path.toString(), this.bundle.getSymbolicName()));
        }
        return (URL)((Optional)url).get();
    }

    private String keyFile() {
        return new FileNameFromLicensedProduct(this.product.get(), (PassageFileExtension)new PassageFileExtension.PublicKey()).get();
    }
}

