/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.NativeLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.jna.platform.windows.PowrProf;
import oshi.util.FormatUtil;

public class WindowsPowerSource
extends AbstractPowerSource {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsPowerSource.class);

    public WindowsPowerSource(String newName, double newRemainingCapacity, double newTimeRemaining) {
        super(newName, newRemainingCapacity, newTimeRemaining);
        LOG.debug("Initialized WindowsPowerSource");
    }

    public static PowerSource[] getPowerSources() {
        String name = "System Battery";
        PowerSource[] psArray = new WindowsPowerSource[1];
        PowrProf.SystemBatteryState batteryState = new PowrProf.SystemBatteryState();
        if (0 != PowrProf.INSTANCE.CallNtPowerInformation(5, null, new NativeLong(0L), batteryState, new NativeLong((long)batteryState.size())) || batteryState.batteryPresent == 0) {
            psArray[0] = new WindowsPowerSource("Unknown", 0.0, -1.0);
        } else {
            int estimatedTime = -2;
            if (batteryState.acOnLine == 0 && batteryState.charging == 0 && batteryState.discharging > 0) {
                estimatedTime = batteryState.estimatedTime;
            }
            long maxCapacity = FormatUtil.getUnsignedInt(batteryState.maxCapacity);
            long remainingCapacity = FormatUtil.getUnsignedInt(batteryState.remainingCapacity);
            psArray[0] = new WindowsPowerSource(name, (double)remainingCapacity / (double)maxCapacity, estimatedTime);
        }
        return psArray;
    }
}

