/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx;

import com.sun.messaging.bridge.api.FaultInjection;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import com.sun.messaging.bridge.service.jms.tx.BranchXid;
import jakarta.transaction.HeuristicCommitException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class XAParticipant {
    private Logger _logger = null;
    private FaultInjection _fi = FaultInjection.getInjection();
    private XAState _state = XAState.NOT_STARTED;
    private String _rm = null;
    private XAResource _xar = null;
    private BranchXid _bxid = null;
    private boolean _recovery = false;
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    public XAParticipant(String rm, XAResource xar, BranchXid bxid) throws SystemException {
        this(rm, xar, bxid, false);
    }

    public XAParticipant(String rm, XAResource xar, BranchXid bxid, boolean recover) throws SystemException {
        if (rm == null) {
            throw new SystemException("null RM name");
        }
        if (xar == null) {
            throw new SystemException("null XAResource object");
        }
        if (bxid == null) {
            throw new SystemException("null branch xid");
        }
        this._bxid = bxid;
        this._xar = xar;
        this._rm = rm;
        this._recovery = recover;
        this._state = XAState.NOT_STARTED;
    }

    protected void setLogger(Logger logger) {
        this._logger = logger;
    }

    public BranchXid getBranchXid() {
        return this._bxid;
    }

    public void start(int flags) throws RollbackException, SystemException {
        if (this._state != XAState.NOT_STARTED) {
            this._logger.log(Level.SEVERE, "start called at an illegal state " + this);
            throw new IllegalStateException(this.toString());
        }
        Exception ex = null;
        try {
            HashMap<String, String> p;
            if (this._fi.FAULT_INJECTION) {
                p = new HashMap<String, String>();
                p.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.start.1", p, "javax.transaction.xa.XAException", true);
            }
            this._xar.start(this._bxid, flags);
            if (this._fi.FAULT_INJECTION) {
                p = new HashMap();
                p.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.start.2", p, "javax.transaction.xa.XAException", true);
            }
            this._state = XAState.STARTED;
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this._state = XAState.NOT_STARTED;
                    this._logger.log(Level.SEVERE, "start returns XA_RB exception from " + this, e);
                    ex = new RollbackException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on start tranaction from " + this);
                    ex.initCause(e);
                    throw (RollbackException)ex;
                }
            }
            this._state = XAState.START_FAILED;
            this._logger.log(Level.SEVERE, "start failed from " + this, e);
            ex = new RollbackException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on start transaction from " + this);
            ex.initCause(e);
            throw (RollbackException)ex;
        }
        catch (Throwable t) {
            this._state = XAState.START_FAILED;
            this._logger.log(Level.SEVERE, "start failed from " + this, t);
            Object emsg = t.getMessage();
            if (t instanceof XAException) {
                emsg = this.xaEString(((XAException)t).errorCode) + ": " + t.getMessage();
            }
            ex = new SystemException((String)emsg + " on start transaction from " + this);
            ex.initCause(t);
            throw (SystemException)ex;
        }
    }

    public void end(int flags) throws RollbackException, SystemException {
        if (this._state != XAState.STARTED && this._state != XAState.START_FAILED && this._state != XAState.END_FAILED) {
            this._logger.log(Level.SEVERE, "end called at an illegal state " + this);
            throw new IllegalStateException(this.toString());
        }
        Exception ex = null;
        try {
            HashMap<String, String> p;
            if (this._fi.FAULT_INJECTION) {
                p = new HashMap<String, String>();
                p.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.end.1", p, "javax.transaction.xa.XAException", true);
            }
            this._xar.end(this._bxid, flags);
            if (this._fi.FAULT_INJECTION) {
                p = new HashMap();
                p.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.end.2", p, "javax.transaction.xa.XAException", true);
            }
            this._state = XAState.ENDED;
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this._state = XAState.ENDED;
                    if (this._logger.isLoggable(Level.FINEST)) {
                        this._logger.log(Level.INFO, "XAResource.end() returned XA_RB exception from " + this, e);
                    } else {
                        this._logger.log(Level.INFO, "XAResource.end() returned XA_RB exception from " + this);
                    }
                    ex = new RollbackException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on end transaction from " + this);
                    ex.initCause(e);
                    throw (RollbackException)ex;
                }
            }
            this._state = XAState.END_FAILED;
            this._logger.log(Level.SEVERE, "end failed from " + this, e);
            ex = new SystemException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on end transaction from " + this);
            ex.initCause(e);
            throw ex;
        }
        catch (Throwable t) {
            this._logger.log(Level.SEVERE, "end failed from " + this, t);
            this._state = XAState.END_FAILED;
            Object emsg = t.getMessage();
            if (t instanceof XAException) {
                emsg = this.xaEString(((XAException)t).errorCode) + ": " + t.getMessage();
            }
            ex = new SystemException((String)emsg + " on end transaction from " + this);
            ex.initCause(t);
            throw ex;
        }
    }

    public void rollback() throws SystemException, HeuristicCommitException, HeuristicRollbackException, HeuristicMixedException {
        if (!this._recovery && this._state != XAState.ENDED && this._state != XAState.END_FAILED && this._state != XAState.PREPARED && this._state != XAState.PREPARE_FAILED && this._state != XAState.ROLLEDBACK && this._state != XAState.ROLLBACK_FAILED) {
            this._logger.log(Level.SEVERE, "rollback called at an illegal state " + this);
            throw new IllegalStateException(this.toString());
        }
        if (this._state == XAState.ROLLEDBACK) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1052", this.toString()));
            return;
        }
        Exception ex = null;
        try {
            HashMap<String, String> p;
            if (this._fi.FAULT_INJECTION) {
                p = new HashMap<String, String>();
                p.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.rollback.1", p, "javax.transaction.xa.XAException", true);
            }
            this._xar.rollback(this._bxid);
            if (this._fi.FAULT_INJECTION) {
                p = new HashMap();
                p.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.rollback.2", p, "javax.transaction.xa.XAException", true);
            }
            this._state = XAState.ROLLEDBACK;
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 7: {
                    this._logger.log(Level.SEVERE, this._bxid + " has been heuristically committed by " + this);
                    this._state = XAState.COMMITTED_ONROLLBACK;
                    ex = new HeuristicCommitException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on rollback transaction from " + this);
                    ex.initCause(e);
                    throw (HeuristicCommitException)ex;
                }
                case 8: {
                    this._logger.log(Level.SEVERE, this._bxid + " may have been heuristically completed by " + this);
                }
                case 5: {
                    this._logger.log(Level.SEVERE, this._bxid + " has been heuristically partialy committed or partially rolledback by " + this);
                    this._state = XAState.ROLLBACK_FAILED;
                    ex = new HeuristicMixedException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on rollback transaction from " + this);
                    ex.initCause(e);
                    throw (HeuristicMixedException)ex;
                }
                case 6: {
                    this._state = XAState.ROLLEDBACK;
                    try {
                        this._xar.forget(this._bxid);
                        return;
                    }
                    catch (Throwable t) {
                        String emsg = "Failed to forget heuristically rolledback transaction from " + this;
                        this._logger.log(Level.WARNING, emsg, t);
                        ex = new HeuristicRollbackException(emsg);
                        ex.initCause(e);
                        throw (HeuristicRollbackException)ex;
                    }
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this._state = XAState.ROLLEDBACK;
                    this._logger.log(Level.INFO, this._bxid + " reported already rolled back by " + this);
                    return;
                }
            }
            this._state = XAState.ROLLBACK_FAILED;
            ex = new SystemException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on rollback transaction from " + this);
            ex.initCause(e);
            throw ex;
        }
        catch (Throwable t) {
            this._state = XAState.ROLLBACK_FAILED;
            Object emsg = t.getMessage();
            if (t instanceof XAException) {
                emsg = this.xaEString(((XAException)t).errorCode) + ": " + t.getMessage();
            }
            ex = new SystemException((String)emsg + " on rollback transaction from " + this);
            ex.initCause(t);
            throw ex;
        }
    }

    public void prepare() throws RollbackException, SystemException {
        block13: {
            if (this._state != XAState.ENDED) {
                throw new IllegalStateException(this.toString());
            }
            Exception ex = null;
            try {
                HashMap<String, String> p;
                if (this._fi.FAULT_INJECTION) {
                    p = new HashMap<String, String>();
                    p.put("cfref", this._rm);
                    this._fi.setLogger(this._logger);
                    this._fi.checkFaultAndThrowException("xa.prepare.1", p, "javax.transaction.xa.XAException", true);
                }
                int vote = this._xar.prepare(this._bxid);
                if (this._fi.FAULT_INJECTION) {
                    p = new HashMap();
                    p.put("cfref", this._rm);
                    this._fi.setLogger(this._logger);
                    this._fi.checkFaultAndThrowException("xa.prepare.2", p, "javax.transaction.xa.XAException", true);
                }
                if (vote == 0) {
                    this._state = XAState.PREPARED;
                    break block13;
                }
                if (vote == 3) {
                    this._state = XAState.COMMITTED;
                    break block13;
                }
                throw new SystemException("Unexpected prepare return :" + vote + " from " + this);
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        this._state = XAState.ROLLEDBACK;
                        ex = new RollbackException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on prepare transaction from " + this);
                        ex.initCause(e);
                        throw (RollbackException)ex;
                    }
                }
                this._state = XAState.PREPARE_FAILED;
                ex = new SystemException(this.xaEString(e.errorCode) + ": " + e.getMessage() + "on prepare transaction from " + this);
                ex.initCause(e);
                throw (SystemException)ex;
            }
            catch (Throwable t) {
                this._state = XAState.PREPARE_FAILED;
                if (t instanceof SystemException) {
                    throw (SystemException)t;
                }
                Object emsg = t.getMessage();
                if (t instanceof XAException) {
                    emsg = this.xaEString(((XAException)t).errorCode) + ": " + t.getMessage();
                }
                ex = new SystemException((String)emsg + "on prepare transaction from " + this);
                ex.initCause(t);
                throw (SystemException)ex;
            }
        }
    }

    public void commit(boolean onePhase) throws RollbackException, HeuristicCommitException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        if (onePhase ? this._state != XAState.ENDED : !this._recovery && this._state != XAState.PREPARED && this._state != XAState.COMMITTED) {
            throw new IllegalStateException(this.toString());
        }
        if (this._state == XAState.COMMITTED) {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1053", this.toString()));
        }
        Exception ex = null;
        try {
            HashMap<String, String> p;
            if (this._fi.FAULT_INJECTION) {
                p = new HashMap<String, String>();
                p.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.commit.1", p, "javax.transaction.xa.XAException", true);
            }
            this._xar.commit(this._bxid, onePhase);
            if (this._fi.FAULT_INJECTION) {
                p = new HashMap();
                p.put("cfref", this._rm);
                this._fi.setLogger(this._logger);
                this._fi.checkFaultAndThrowException("xa.commit.2", p, "javax.transaction.xa.XAException", true);
            }
            this._state = XAState.COMMITTED;
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 7: {
                    this._state = XAState.COMMITTED;
                    this._logger.log(Level.INFO, this._bxid + " has been heuristically committed by " + this);
                    try {
                        this._xar.forget(this._bxid);
                        return;
                    }
                    catch (Throwable t) {
                        String emsg = "Failed to forget heuristically committed transaction from " + this;
                        this._logger.log(Level.WARNING, emsg, t);
                        ex = new HeuristicCommitException(emsg);
                        ex.initCause(e);
                        throw (HeuristicCommitException)ex;
                    }
                }
                case 8: {
                    this._logger.log(Level.SEVERE, this._bxid + " may have been heuristically completed by " + this);
                }
                case 5: {
                    this._logger.log(Level.SEVERE, this._bxid + " has been heuristically partialy committed or partially rolledback by " + this);
                    this._state = XAState.COMMIT_FAILED;
                    ex = new HeuristicMixedException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on commit transaction from " + this);
                    ex.initCause(e);
                    throw (HeuristicMixedException)ex;
                }
                case 6: {
                    this._state = XAState.ROLLEDBACK_ONCOMMIT;
                    this._logger.log(Level.SEVERE, this._bxid + " has been heuristically rolledback by " + this);
                    ex = new HeuristicRollbackException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on commit transaction from " + this);
                    ex.initCause(e);
                    throw (HeuristicRollbackException)ex;
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this._state = XAState.ROLLEDBACK_ONCOMMIT;
                    if (!onePhase) {
                        this._logger.log(Level.SEVERE, "Unexpected rollback exception on commit from " + this);
                        ex = new SystemException("Unexpected " + this.xaEString(e.errorCode) + ": " + e.getMessage() + " on commit transaction from " + this);
                        ex.initCause(e);
                        throw (SystemException)ex;
                    }
                    ex = new RollbackException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on commit transation from " + this);
                    ex.initCause(e);
                    throw (RollbackException)ex;
                }
            }
            this._state = XAState.COMMIT_FAILED;
            ex = new SystemException(this.xaEString(e.errorCode) + ": " + e.getMessage() + " on commit transation from " + this);
            ex.initCause(e);
            throw (SystemException)ex;
        }
        catch (Throwable t) {
            this._state = XAState.START_FAILED;
            Object emsg = t.getMessage();
            if (t instanceof XAException) {
                emsg = this.xaEString(((XAException)t).errorCode) + ": " + t.getMessage();
            }
            ex = new SystemException((String)emsg + " on commit transaction from " + this);
            ex.initCause(t);
            throw ex;
        }
    }

    public String getRM() {
        return this._rm;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XAParticipant)) {
            return false;
        }
        XAParticipant that = (XAParticipant)o;
        if (that == this) {
            return true;
        }
        return this._rm.equals(that._rm) && this._bxid.equals(that._bxid) && this._xar.equals(that._xar);
    }

    public int hashCode() {
        return this._xar.hashCode();
    }

    public String toString() {
        return this._bxid + "[" + this._rm + ":" + this._xar + "]" + XAParticipant.toString(this._state);
    }

    public static String toString(XAState state) {
        switch (state) {
            case NOT_STARTED: {
                return "NOT_STARTED";
            }
            case START_FAILED: {
                return "STARTED_FAILED";
            }
            case STARTED: {
                return "STARTED";
            }
            case END_FAILED: {
                return "END_FAILED";
            }
            case ENDED: {
                return "ENDED";
            }
            case PREPARE_FAILED: {
                return "PREPARE_FAILED";
            }
            case PREPARED: {
                return "PREPARED";
            }
            case COMMIT_FAILED: {
                return "COMMIT_FAILED";
            }
            case COMMITTED: {
                return "COMMITTED";
            }
            case ROLLBACK_FAILED: {
                return "ROLLBACK_FAILED";
            }
            case ROLLEDBACK: {
                return "ROLLEDBACK";
            }
        }
        return "UNKNOWN";
    }

    private String xaEString(int errorCode) {
        switch (errorCode) {
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 4: {
                return "XA_RETRY";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
        }
        return "UNKNOWN";
    }

    private static enum XAState {
        NOT_STARTED,
        START_FAILED,
        STARTED,
        END_FAILED,
        ENDED,
        PREPARE_FAILED,
        PREPARED,
        COMMIT_FAILED,
        COMMITTED,
        ROLLBACK_FAILED,
        ROLLEDBACK,
        ROLLEDBACK_ONCOMMIT,
        ROLLEDBACK_ONCOMMIT_1PHASE,
        COMMITTED_ONROLLBACK;

    }
}

