/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import java.io.IOException;
import java.util.Iterator;

public class NewInterestHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public NewInterestHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "NewInterestHandler");
        }
        if (pkt.getType() == 5) {
            this.handleNewInterest(cb, sender, pkt);
        } else if (pkt.getType() == 6) {
            this.handleNewInterestAck(sender, pkt);
        } else if (pkt.getType() == 35) {
            this.handleAttachDurable(cb, sender, pkt);
        } else if (pkt.getType() == 36) {
            this.handleAttachDurableReply(sender, pkt);
        } else {
            this.logger.log(16, "MessageDataHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public boolean ignoreNewInterest(ClusterConsumerInfo ci, GPacket pkt) {
        ClusterConsumerInfo cci = ci;
        if (cci == null) {
            cci = ClusterConsumerInfo.newInstance(pkt, this.c);
        }
        if (!this.p.getConfigSyncComplete() && !cci.isConfigSyncResponse()) {
            if (DEBUG) {
                this.logger.log(8, "Ignore " + ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()) + ", not ready yet");
            }
            return true;
        }
        return false;
    }

    public void handleNewInterest(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        ClusterConsumerInfo cci;
        if (DEBUG) {
            this.logger.log(8, "handleNewInterest from : " + sender);
        }
        if (this.ignoreNewInterest(cci = ClusterConsumerInfo.newInstance(pkt, this.c), pkt)) {
            return;
        }
        int count = cci.getConsumerCount();
        if (DEBUG) {
            this.logger.log(8, "handleNewInterest count : " + count);
        }
        try {
            int i = 0;
            ChangeRecordInfo lastcri = null;
            Iterator itr = cci.getConsumers();
            while (itr.hasNext()) {
                ChangeRecordInfo cri;
                ++i;
                Consumer cons = null;
                try {
                    cons = (Consumer)itr.next();
                }
                catch (RuntimeException e) {
                    Throwable ex = e.getCause();
                    if (ex instanceof ConsumerAlreadyAddedException) {
                        this.logger.log(16, ex.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()) + ") " + sender);
                        continue;
                    }
                    throw e;
                }
                DestinationUID duid = cons.getDestinationUID();
                if (!duid.isWildcard()) {
                    int type = duid.isQueue() ? 1 : 2;
                    Globals.getDestinationList();
                    DestinationList.getDestination(null, duid.getName(), type, true, true);
                }
                cb.interestCreated(cons);
                if (DEBUG) {
                    this.logger.log(8, "Added newInterest(" + count + ")" + cons + " from " + sender);
                }
                if ((cri = cci.getShareccInfo(i)) == null) continue;
                if (lastcri == null) {
                    lastcri = cri;
                    continue;
                }
                if (cri.getSeq() <= lastcri.getSeq()) continue;
                lastcri = cri;
            }
            if (lastcri != null) {
                cb.setLastReceivedChangeRecord(sender, lastcri);
            }
        }
        catch (Exception e) {
            this.logger.logStack(16, e.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()) + ") " + sender + " " + pkt, e);
        }
        if (cci.needReply()) {
            GPacket gp = ClusterConsumerInfo.getReplyGPacket((short)6, 200);
            try {
                this.c.unicast(sender, gp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleNewInterestAck(BrokerAddress sender, GPacket pkt) {
        this.logger.log(4, "MessageBus: Received G_NEW_INTEREST_REPLY from {0} : STATUS = {1}", (Object)sender, pkt.getProp("S"));
    }

    public void handleAttachDurable(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        ClusterSubscriptionInfo csi;
        block20: {
            if (DEBUG) {
                this.logger.log(8, "handleAttachDurable from : " + sender);
            }
            csi = ClusterSubscriptionInfo.newInstance(pkt, this.c);
            try {
                boolean nonDurableOK;
                String dname = csi.getDurableName();
                String cid = csi.getClientID();
                String ndsubname = csi.getNDSubscriptionName();
                Boolean allowsNonDurable = csi.allowsNonDurable();
                boolean bl = nonDurableOK = allowsNonDurable != null && allowsNonDurable != false;
                if ((cid == null || !nonDurableOK && dname == null) && (cid != null || dname == null && ndsubname == null)) {
                    String emsg = Globals.getBrokerResources().getKString("B3100", " in handleAttachDurable: " + dname + ":" + cid + ", " + ndsubname + ", " + nonDurableOK);
                    this.logger.logStack(32, emsg, new RuntimeException(emsg));
                    return;
                }
                Consumer cons = null;
                try {
                    cons = csi.getConsumer();
                }
                catch (IOException e) {
                    Throwable ex = e.getCause();
                    if (ex instanceof ConsumerAlreadyAddedException) {
                        this.logger.log(16, ex.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()) + ") " + sender);
                        return;
                    }
                    throw e;
                }
                Subscription sub = null;
                if (dname == null) {
                    String selector;
                    DestinationUID duid = cons.getDestinationUID();
                    sub = Subscription.findNonDurableSubscription(cid, duid, selector = cons.getSelectorStr(), ndsubname);
                    if (sub == null) {
                        Object[] args = new String[]{Subscription.getNDSubLongLogString(cid, duid, selector, ndsubname, cons.getNoLocal()), cons.toString(), sender.toString()};
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2277", args));
                    }
                } else {
                    sub = Subscription.findDurableSubscription(cid, dname);
                    if (sub == null) {
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2276", Subscription.getDSubLogString(cid, dname), sender));
                    }
                }
                if (DEBUG) {
                    this.logger.log(8, "handleAttachDurable: subscription=" + sub + Subscription.getDSubLogString(cid, dname) + ", consumer=" + cons + " from " + sender);
                }
                if (sub == null) {
                    return;
                }
                try {
                    sub.attachConsumer(cons);
                    cb.interestCreated(cons);
                }
                catch (Exception ex) {
                    if (ex instanceof ConsumerAlreadyAddedException) {
                        this.logger.log(8, ex.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()) + ")");
                        break block20;
                    }
                    if (ex instanceof BrokerException && ((BrokerException)ex).getStatusCode() == 409) {
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2211", ex.getMessage()));
                        break block20;
                    }
                    this.logger.log(32, Globals.getBrokerResources().getKString("B2211", ex.getMessage()), ex);
                }
            }
            catch (Exception e) {
                this.logger.logStack(16, e.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()) + ") " + sender + " " + pkt, e);
            }
        }
        if (csi.needReply()) {
            GPacket gp = ClusterSubscriptionInfo.getReplyGPacket((short)36, 200);
            try {
                this.c.unicast(sender, gp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleAttachDurableReply(BrokerAddress sender, GPacket pkt) {
        this.logger.log(4, "MessageBus: Received G_DURABLE_ATTACH_REPLY from {0} : STATUS = {1}", (Object)sender, pkt.getProp("S"));
    }
}

