/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.servlet;

import com.sun.messaging.jmq.httptunnel.tunnel.servlet.DefaultTrustManager;
import com.sun.messaging.jmq.httptunnel.tunnel.servlet.ServerLinkTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;

class HelperThread
extends Thread {
    private ServerSocket ss = null;
    private ServerLinkTable parent;
    private String servletName = null;
    private boolean closed = false;

    HelperThread(int serverPort, String servletHost, int rxBufSize, ServerLinkTable p) throws IOException {
        this.parent = p;
        this.closed = false;
        this.ss = this.createServerSocket(null, serverPort, servletHost);
        try {
            this.ss.setSoTimeout(5000);
        }
        catch (SocketException e) {
            this.parent.servletContext.log("WARNING: HttpTunnelTcpListener[" + this.ss + "]setSoTimeout(5000): " + e);
        }
        if (rxBufSize > 0) {
            try {
                this.ss.setReceiveBufferSize(rxBufSize);
            }
            catch (SocketException e) {
                this.parent.servletContext.log("WARNING: HttpTunnelTcpListener[" + this.ss + "]setReceiveBufferSize(" + rxBufSize + "): " + e);
            }
        }
        this.setName("HttpTunnelTcpListener");
        this.setDaemon(true);
        this.servletName = "HttpTunnelServlet";
        this.parent.servletContext.log(this.servletName + ": listening on port " + serverPort + " ...");
    }

    HelperThread(int serverPort, String servletHost, int rxBufSize, String ksloc, String password, ServerLinkTable p) throws IOException {
        this.parent = p;
        this.closed = false;
        SSLServerSocketFactory ssf = this.getServerSocketFactory(ksloc, password);
        this.ss = this.createServerSocket(ssf, serverPort, servletHost);
        try {
            this.ss.setSoTimeout(5000);
        }
        catch (SocketException e) {
            this.parent.servletContext.log("WARNING: HttpsTunnelTcpListener[" + this.ss + "]setSoTimeout(5000): " + e);
        }
        if (rxBufSize > 0) {
            try {
                this.ss.setReceiveBufferSize(rxBufSize);
            }
            catch (SocketException e) {
                this.parent.servletContext.log("WARNING: HttpsTunnelTcpListener[" + this.ss + "]setReceiveBufferSize(" + rxBufSize + "): " + e);
            }
        }
        this.setName("HttpsTunnelTcpListener");
        this.setDaemon(true);
        this.servletName = "HttpsTunnelServlet";
        this.parent.servletContext.log(this.servletName + ": listening on port " + serverPort + " ...");
    }

    private ServerSocket createServerSocket(SSLServerSocketFactory ssf, int serverPort, String servletHost) throws IOException {
        ServerSocket serverSocket = null;
        int retryCount = 0;
        while (serverSocket == null) {
            ++retryCount;
            try {
                if (ssf != null) {
                    serverSocket = this.doCreateSSLServerSocket(ssf, serverPort, servletHost);
                    continue;
                }
                serverSocket = this.doCreateServerSocket(serverPort, servletHost);
            }
            catch (BindException ioe) {
                if (retryCount > 7) {
                    throw ioe;
                }
                this.parent.servletContext.log(ioe.toString(), (Throwable)ioe);
                this.pause(3000L);
            }
        }
        return serverSocket;
    }

    private ServerSocket doCreateServerSocket(int serverPort, String servletHost) throws IOException {
        ServerSocket serverSocket = null;
        if (servletHost == null) {
            serverSocket = new ServerSocket(serverPort);
        } else {
            InetAddress listenAddr = InetAddress.getByName(servletHost);
            serverSocket = new ServerSocket(serverPort, 50, listenAddr);
        }
        return serverSocket;
    }

    private ServerSocket doCreateSSLServerSocket(SSLServerSocketFactory ssf, int serverPort, String servletHost) throws IOException {
        ServerSocket serverSocket = null;
        if (servletHost == null) {
            serverSocket = ssf.createServerSocket(serverPort);
        } else {
            InetAddress listenAddr = InetAddress.getByName(servletHost);
            serverSocket = ssf.createServerSocket(serverPort, 50, listenAddr);
        }
        return serverSocket;
    }

    private void pause(long ptime) {
        try {
            Thread.sleep(ptime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.closed) {
            try {
                Socket s = this.ss.accept();
                HelperThread helperThread = this;
                synchronized (helperThread) {
                    if (this.closed) {
                        s.close();
                        break;
                    }
                    this.parent.addServer(s);
                }
                this.parent.servletContext.log(this.servletName + ": accepted socket connection. rcvbuf = " + s.getReceiveBufferSize());
            }
            catch (InterruptedIOException e1) {
                this.parent.checkConnectionTimeouts();
            }
            catch (Exception e2) {
                this.parent.servletContext.log(this.servletName + ": accept(): " + e2.getMessage());
            }
        }
        this.parent.servletContext.log(this.servletName + ": listen socket closed");
    }

    public synchronized void close() {
        this.closed = true;
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SSLServerSocketFactory getServerSocketFactory(String ksloc, String password) throws IOException {
        SSLServerSocketFactory ssf = null;
        try {
            File kf = new File(ksloc);
            if (!kf.exists()) {
                throw new IOException("Keystore does not exist - " + ksloc);
            }
            char[] passphrase = password.toCharArray();
            SSLContext ctx = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(ksloc), passphrase);
            kmf.init(ks, passphrase);
            TrustManager[] tm = new TrustManager[]{new DefaultTrustManager()};
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            ctx.init(kmf.getKeyManagers(), tm, random);
            ssf = ctx.getServerSocketFactory();
            return ssf;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

