/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.JMSXAWrappedConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedLock;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedXAResourceImpl;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.util.Hashtable;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

abstract class JMSXAWrappedXSessionImpl {
    static final boolean debug = JMSXAWrappedConnectionFactoryImpl.debug;
    boolean delaySessionCloseForRAR_ = false;
    boolean ignoreSessionCloseForRAR_ = false;
    JMSXAWrappedLock lock_ = null;
    boolean closed_ = false;
    boolean markClosed_ = false;
    Hashtable transactions_ = new Hashtable();
    Session session_;
    XAResource nonxaresource_ = null;
    JMSXAWrappedXAResourceImpl xaresource_ = null;

    JMSXAWrappedXSessionImpl() {
    }

    final boolean delaySessionClose() {
        return this.delaySessionCloseForRAR_;
    }

    public final void beforeTransactionStart() throws JMSException {
        this.lock_.acquireLock();
        if (this.closed_) {
            throw new IllegalStateException("JMSXWrapped Session has been closed");
        }
        if (this.markClosed_) {
            throw new IllegalStateException("JMSXAWrapped Session is closed");
        }
    }

    public final void afterTransactionStart(Xid foreignXid, boolean started) {
        if (started) {
            this.transactions_.put(foreignXid, "");
        }
        this.lock_.releaseLock();
    }

    public final void beforeTransactionComplete() {
        this.lock_.acquireLock();
    }

    final void hardClose() throws JMSException {
        this.hardClose(true);
    }

    final void hardClose(boolean hard) throws JMSException {
        this.session_.close();
        JMSXAWrappedXSessionImpl.dlog("hard closed session:" + this.session_ + " " + this.session_.getClass().getName());
        if (this.xaresource_ != null && hard) {
            this.xaresource_.close();
        }
        this.closed_ = true;
        if (this.delaySessionCloseForRAR_) {
            this.removeSelfFromConnection();
        }
    }

    abstract void removeSelfFromConnection();

    static void dlog(String msg) {
        if (debug) {
            JMSXAWrappedXSessionImpl.log("Info:", msg);
        }
    }

    static void log(String level, Exception e) {
        JMSXAWrappedXSessionImpl.log(level, e.getMessage());
        e.printStackTrace();
    }

    static void log(String level, String msg) {
        System.out.println(level + " JMSXAWrappedQueueSessionImpl: " + msg);
    }

    public final Session getSession() throws JMSException {
        if (this.closed_) {
            throw new IllegalStateException("JMSXWrapped Session has been closed");
        }
        if (this.markClosed_) {
            throw new IllegalStateException("JMSXAWrapped Session is closed");
        }
        return this.session_;
    }
}

