/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.RuntimeIOException;

class Jdk {
    final Path path;
    final String release;
    private static final Map<Path, String> pathToRelease = new ConcurrentHashMap<Path, String>();

    public Jdk(File jrt) throws IOException {
        this.path = Jdk.toJdkHome(jrt);
        try {
            this.release = pathToRelease.computeIfAbsent(this.path.toRealPath(new LinkOption[0]), p -> {
                try {
                    return Jdk.readJdkReleaseFile(p);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            });
        }
        catch (RuntimeIOException rio) {
            throw rio.getCause();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Jdk [");
        if (this.path != null) {
            builder.append("path=");
            builder.append(this.path);
            builder.append(", ");
        }
        if (this.release != null) {
            builder.append("release=");
            builder.append(this.release);
        }
        builder.append("]");
        return builder.toString();
    }

    boolean sameRelease(String other) {
        long otherJdkLevel;
        long jdkLevel = CompilerOptions.versionToJdkLevel(this.release);
        return Long.compare(jdkLevel, otherJdkLevel = CompilerOptions.versionToJdkLevel(other)) == 0;
    }

    static Path toJdkHome(File jrt) {
        Path normalized = jrt.toPath().normalize();
        Path home = jrt.getName().equals("jrt-fs.jar") ? normalized.getParent().getParent() : normalized;
        return home;
    }

    static String readJdkReleaseFile(Path javaHome) throws IOException {
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = Files.newInputStream(javaHome.resolve("release"), new OpenOption[0]);){
            properties.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String ver = properties.getProperty("JAVA_VERSION");
        if (ver != null) {
            ver = ver.replace("\"", "");
        }
        return ver;
    }
}

