/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.osgi.util.NLS;

public abstract class Transport {
    public static final String SERVICE_NAME = Transport.class.getName();
    private static final Map<String, ProtocolRule> RULES = Map.of("http", ProtocolRule.of(System.getProperty("p2.httpRule")), "ftp", ProtocolRule.of(System.getProperty("p2.ftpRule")));
    private static final boolean SKIP_REPOSITORY_PROTOCOL_CHECK = Boolean.getBoolean("p2.skipRepositoryProtocolCheck");
    private static final Pattern ARCHIVE_URI_PATTERN = Pattern.compile("(?i)(jar|zip|archive):(.*)!/(.*)");
    private final Set<URI> loggedURIs = ConcurrentHashMap.newKeySet();

    @Deprecated(forRemoval=true)
    public IStatus download(URI toDownload, OutputStream target, long startPos, IProgressMonitor monitor) {
        if (startPos <= 0L) {
            return this.download(toDownload, target, monitor);
        }
        throw new UnsupportedOperationException("positional downloads are actually never called from P2 code and thus disabled by default, please use the method without a position instead");
    }

    public abstract IStatus download(URI var1, OutputStream var2, IProgressMonitor var3);

    public abstract InputStream stream(URI var1, IProgressMonitor var2) throws FileNotFoundException, CoreException, AuthenticationFailedException;

    public abstract long getLastModified(URI var1, IProgressMonitor var2) throws CoreException, FileNotFoundException, AuthenticationFailedException;

    public URI getSecureLocation(URI location) throws CoreException {
        String scheme = location.getScheme();
        String canonicalScheme = scheme == null ? "null" : scheme.toLowerCase();
        ProtocolRule protocolRule = RULES.get(canonicalScheme);
        if (protocolRule != null) {
            switch (protocolRule) {
                case REDIRECT: {
                    try {
                        return new URI(String.valueOf(canonicalScheme) + "s", location.getUserInfo(), location.getHost(), location.getPort(), location.getPath(), location.getQuery(), location.getFragment());
                    }
                    catch (URISyntaxException e) {
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", e.getLocalizedMessage(), (Throwable)e));
                    }
                }
                case BLOCK: {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", NLS.bind((String)Messages.RepositoryTransport_unsafeProtocolBlocked, (Object)canonicalScheme, (Object)location)));
                }
            }
            if (!SKIP_REPOSITORY_PROTOCOL_CHECK && this.loggedURIs.add(location)) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", NLS.bind((String)Messages.RepositoryTransport_unsafeProtocol, (Object)canonicalScheme, (Object)location)));
            }
        } else {
            Matcher matcher = ARCHIVE_URI_PATTERN.matcher(location.toString());
            if (matcher.matches()) {
                return URI.create(String.valueOf(matcher.group(1)) + ':' + this.getSecureLocation(URI.create(String.valueOf(matcher.group(2)) + "!/" + matcher.group(3))));
            }
        }
        return location;
    }

    private static enum ProtocolRule {
        ALLOW,
        REDIRECT,
        BLOCK;


        public static ProtocolRule of(String literal) {
            if (literal == null) {
                return REDIRECT;
            }
            switch (literal) {
                case "allow": {
                    return ALLOW;
                }
                case "redirect": {
                    return REDIRECT;
                }
            }
            return BLOCK;
        }
    }
}

