/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewLayout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.e4.compatibility.ModeledFolderLayout;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayoutUtils;
import org.eclipse.ui.internal.e4.compatibility.ModeledPlaceholderFolderLayout;
import org.eclipse.ui.internal.e4.compatibility.ModeledViewLayout;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ModeledPageLayout
implements IPageLayout {
    public static final String ACTION_SET_TAG = "persp.actionSet:";
    public static final String NEW_WIZARD_TAG = "persp.newWizSC:";
    public static final String PERSP_SHORTCUT_TAG = "persp.perspSC:";
    public static final String SHOW_IN_PART_TAG = "persp.showIn:";
    public static final String SHOW_VIEW_TAG = "persp.viewSC:";
    public static final String EDITOR_STACK_TAG = "EditorStack";
    public static final String HIDDEN_MENU_PREFIX = "persp.hideMenuSC:";
    public static final String HIDDEN_TOOLBAR_PREFIX = "persp.hideToolbarSC:";
    public static final String HIDDEN_ACTIONSET_PREFIX = "persp.hideActionSetSC:";
    public static final String HIDDEN_ITEMS_KEY = "persp.hiddenItems";
    public static final String EDITOR_ONBOARDING = "persp.editorOnboarding";
    public static final String EDITOR_ONBOARDING_TEXT = "persp.editorOnboardingText:";
    public static final String EDITOR_ONBOARDING_IMAGE = "persp.editorOnboardingImageUri:";
    public static final String EDITOR_ONBOARDING_COMMAND = "persp.editorOnboardingCommand:";
    private MApplication application;
    private EModelService modelService;
    EPartService partService;
    WorkbenchPage page;
    MPerspective perspModel;
    private IPerspectiveDescriptor descriptor;
    private MPlaceholder eaRef;
    private MPartStack editorStack;
    boolean createReferences;
    private IViewRegistry viewRegistry;
    private ModeledPageLayoutUtils layoutUtils;

    public static List<String> getIds(MPerspective model, String tagPrefix) {
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String tag : model.getTags()) {
            if (!tag.startsWith(tagPrefix)) continue;
            result.add(tag.substring(tagPrefix.length()));
        }
        return result;
    }

    public ModeledPageLayout(MWindow window, EModelService modelService, EPartService partService, MPerspective perspModel, IPerspectiveDescriptor descriptor, WorkbenchPage page, boolean createReferences) {
        MElementContainer winParent = window.getParent();
        this.application = (MApplication)winParent;
        this.modelService = modelService;
        this.partService = partService;
        this.viewRegistry = PlatformUI.getWorkbench().getViewRegistry();
        this.page = page;
        this.perspModel = perspModel;
        this.descriptor = descriptor;
        this.layoutUtils = new ModeledPageLayoutUtils(modelService);
        this.createReferences = createReferences;
        MArea sharedArea = null;
        List sharedElements = window.getSharedElements();
        for (MUIElement element : sharedElements) {
            if (!element.getElementId().equals(this.getEditorArea())) continue;
            sharedArea = (MArea)element;
            break;
        }
        if (sharedArea == null) {
            sharedArea = (MArea)modelService.createModelElement(MArea.class);
            this.editorStack = (MPartStack)modelService.createModelElement(MPartStack.class);
            this.editorStack.getTags().add("org.eclipse.e4.primaryDataStack");
            this.editorStack.getTags().add(EDITOR_STACK_TAG);
            this.editorStack.setElementId("org.eclipse.e4.primaryDataStack");
            sharedArea.getChildren().add(this.editorStack);
            sharedArea.setElementId(this.getEditorArea());
            window.getSharedElements().add(sharedArea);
        } else {
            List stacks = modelService.findElements((MUIElement)sharedArea, null, MPartStack.class);
            if (!stacks.isEmpty()) {
                this.editorStack = (MPartStack)stacks.get(0);
            }
        }
        this.eaRef = (MPlaceholder)modelService.createModelElement(MPlaceholder.class);
        this.eaRef.setElementId(this.getEditorArea());
        this.eaRef.setRef((MUIElement)sharedArea);
        perspModel.getChildren().add(this.eaRef);
        ActionSetRegistry registry = (ActionSetRegistry)this.application.getContext().get(ActionSetRegistry.class);
        IActionSetDescriptor[] iActionSetDescriptorArray = registry.getActionSets();
        int n = iActionSetDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor actionSetDescriptor = iActionSetDescriptorArray[n2];
            if (actionSetDescriptor.isInitiallyVisible()) {
                this.addActionSet(actionSetDescriptor.getId());
            }
            ++n2;
        }
    }

    public MPerspective getModel() {
        return this.perspModel;
    }

    @Override
    public void addActionSet(String actionSetId) {
        this.perspModel.getTags().add(ACTION_SET_TAG + actionSetId);
    }

    @Override
    public void addFastView(String viewId) {
        E4Util.unsupported("addFastView: " + viewId);
        this.logDeprecatedWarning(viewId);
    }

    @Override
    public void addFastView(String viewId, float ratio) {
        E4Util.unsupported("addFastView: " + viewId);
        this.logDeprecatedWarning(viewId);
    }

    private void logDeprecatedWarning(String viewId) {
        String message = String.valueOf(viewId) + ": Deprecated relationship \"fast\" should be converted to \"stack\".";
        WorkbenchPlugin.log(message, StatusUtil.newStatus(2, message, null));
    }

    @Override
    public void addNewWizardShortcut(String id) {
        this.perspModel.getTags().add(NEW_WIZARD_TAG + id);
    }

    @Override
    public void addPerspectiveShortcut(String id) {
        this.perspModel.getTags().add(PERSP_SHORTCUT_TAG + id);
    }

    @Override
    public void addPlaceholder(String viewId, int relationship, float ratio, String refId) {
        this.insertView(viewId, relationship, ratio, refId, false, true);
    }

    @Override
    public void addShowInPart(String id) {
        this.perspModel.getTags().add(SHOW_IN_PART_TAG + id);
    }

    @Override
    public void addShowViewShortcut(String id) {
        this.perspModel.getTags().add(SHOW_VIEW_TAG + id);
    }

    @Override
    public void addStandaloneView(String viewId, boolean showTitle, int relationship, float ratio, String refId) {
        MUIElement newElement = this.insertView(viewId, relationship, ratio, refId, true, showTitle);
        if (newElement instanceof MPartStack) {
            MPartStack stack = (MPartStack)newElement;
            stack.getTags().add("Standalone");
            ((MStackElement)stack.getChildren().get(0)).getTags().add("NoMove");
        } else {
            newElement.getTags().add("Standalone");
        }
    }

    @Override
    public void addStandaloneViewPlaceholder(String viewId, int relationship, float ratio, String refId, boolean showTitle) {
        MUIElement newElement = this.insertView(viewId, relationship, ratio, refId, false, showTitle);
        if (newElement instanceof MPartStack) {
            MPartStack stack = (MPartStack)newElement;
            stack.getTags().add("Standalone");
            ((MStackElement)stack.getChildren().get(0)).getTags().add("NoMove");
        } else {
            newElement.getTags().add("Standalone");
        }
    }

    @Override
    public void addView(String viewId, int relationship, float ratio, String refId) {
        this.insertView(viewId, relationship, ratio, refId, true, true);
    }

    public void addView(String viewId, int relationship, float ratio, String refId, boolean minimized) {
        if (minimized) {
            E4Util.unsupported("addView: use of minimized for " + viewId + " ref " + refId);
        }
        this.addView(viewId, relationship, ratio, refId);
    }

    protected boolean isViewFiltered(String viewID) {
        IViewDescriptor viewDescriptor = this.viewRegistry.find(viewID);
        if (viewDescriptor == null) {
            return false;
        }
        if (WorkbenchActivityHelper.restrictUseOf(viewDescriptor)) {
            return true;
        }
        return WorkbenchActivityHelper.filterItem(viewDescriptor);
    }

    protected void addViewActivator(MUIElement element) {
        IPluginContribution contribution = (IPluginContribution)((Object)this.viewRegistry.find(element.getElementId()));
        IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        IIdentifier identifier = support.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId(contribution));
        identifier.addIdentifierListener(new ViewActivator(element));
    }

    @Override
    public IFolderLayout createFolder(String folderId, int relationship, float ratio, String refId) {
        MPartStack stack = this.insertStack(folderId, relationship, ratio, refId, false);
        return new ModeledFolderLayout(this, this.application, stack);
    }

    @Override
    public IPlaceholderFolderLayout createPlaceholderFolder(String folderId, int relationship, float ratio, String refId) {
        MPartStack Stack = this.insertStack(folderId, relationship, ratio, refId, false);
        return new ModeledPlaceholderFolderLayout(this, this.application, Stack);
    }

    @Override
    public IPerspectiveDescriptor getDescriptor() {
        return this.descriptor;
    }

    public static String internalGetEditorArea() {
        return "org.eclipse.ui.editorss";
    }

    @Override
    public String getEditorArea() {
        return ModeledPageLayout.internalGetEditorArea();
    }

    @Override
    public int getEditorReuseThreshold() {
        return -1;
    }

    @Override
    public IPlaceholderFolderLayout getFolderForView(String id) {
        MPart view = this.findPart((MUIElement)this.perspModel, id);
        if (view == null) {
            return null;
        }
        MElementContainer stack = view.getParent();
        if (stack == null || !(stack instanceof MPartStack)) {
            return null;
        }
        return new ModeledPlaceholderFolderLayout(this, this.application, (MPartStack)stack);
    }

    @Override
    public IViewLayout getViewLayout(String id) {
        MPart view = this.findPart((MUIElement)this.perspModel, id);
        if (view != null) {
            return new ModeledViewLayout(view);
        }
        MPlaceholder placeholder = this.findPlaceholder((MUIElement)this.perspModel, id);
        if (placeholder != null) {
            return new ModeledViewLayout(placeholder);
        }
        return null;
    }

    @Override
    public boolean isEditorAreaVisible() {
        return true;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public void setEditorAreaVisible(boolean showEditorArea) {
        this.eaRef.setToBeRendered(showEditorArea);
    }

    @Override
    public void setEditorReuseThreshold(int openEditors) {
    }

    @Override
    public void setFixed(boolean isFixed) {
    }

    public static MStackElement createViewModel(MApplication application, String id, boolean visible, WorkbenchPage page, EPartService partService, boolean createReferences) {
        EModelService ms = (EModelService)application.getContext().get(EModelService.class);
        MPartDescriptor partDesc = ms.getPartDescriptor(id);
        if (partDesc != null) {
            MPlaceholder ph = partService.createSharedPart(id);
            ph.setToBeRendered(visible);
            MPart part = (MPart)ph.getRef();
            part.setToBeRendered(true);
            if (visible && createReferences && "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView".equals(partDesc.getContributionURI())) {
                page.createViewReferenceForPart(part, id);
            }
            return ph;
        }
        return null;
    }

    private MUIElement insertView(String viewId, int relationship, float ratio, String refId, boolean visible, boolean withStack) {
        MStackElement viewModel;
        boolean isFiltered = this.isViewFiltered(viewId);
        MStackElement retVal = viewModel = ModeledPageLayout.createViewModel(this.application, viewId, visible && !isFiltered, this.page, this.partService, this.createReferences);
        if (viewModel != null) {
            if (withStack) {
                String stackId = String.valueOf(viewId) + "MStack";
                MPartStack stack = this.insertStack(stackId, relationship, ratio, refId, visible && !isFiltered);
                stack.getChildren().add(viewModel);
                retVal = stack;
            } else {
                this.layoutUtils.insert((MUIElement)viewModel, this.findRefModel(refId), this.layoutUtils.plRelToSwt(relationship), ratio);
            }
        }
        if (isFiltered) {
            this.addViewActivator((MUIElement)viewModel);
        }
        return retVal;
    }

    private MUIElement findRefModel(String refId) {
        MUIElement ref;
        MUIElement refModel = this.findElement((MUIElement)this.perspModel, refId);
        if (refModel instanceof MPart) {
            MElementContainer parent = refModel.getParent();
            return parent instanceof MPartStack ? parent : refModel;
        }
        if (refModel instanceof MPlaceholder && (ref = ((MPlaceholder)refModel).getRef()) instanceof MPart) {
            MElementContainer parent = refModel.getParent();
            return parent instanceof MPartStack ? parent : refModel;
        }
        return refModel;
    }

    private MUIElement getLastElement(MUIElement element) {
        if (element instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)element;
            List children = container.getChildren();
            return children.isEmpty() ? container : this.getLastElement((MUIElement)children.get(children.size() - 1));
        }
        MElementContainer parent = element.getParent();
        return parent == this.perspModel ? element : parent;
    }

    private MUIElement getLastElement() {
        List children = this.perspModel.getChildren();
        if (children.isEmpty()) {
            return this.perspModel;
        }
        return this.getLastElement((MUIElement)children.get(children.size() - 1));
    }

    private MPartStack insertStack(String stackId, int relationship, float ratio, String refId, boolean visible) {
        MUIElement refModel = this.findElement((MUIElement)this.perspModel, refId);
        if (refModel == null) {
            WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.PageLayout_missingRefPart, (Object)refId));
            MPartStack stack = this.layoutUtils.createStack(stackId, visible);
            this.layoutUtils.insert((MUIElement)stack, this.getLastElement(), this.layoutUtils.plRelToSwt(relationship), ratio);
            return stack;
        }
        MPartStack stack = this.layoutUtils.createStack(stackId, visible);
        MElementContainer parent = refModel.getParent();
        if (parent instanceof MPartStack) {
            refModel = parent;
        }
        this.layoutUtils.insert((MUIElement)stack, refModel, this.layoutUtils.plRelToSwt(relationship), ratio);
        return stack;
    }

    public static void replace(MUIElement relTo, MElementContainer<MUIElement> newParent) {
        if (relTo == null || newParent == null) {
            return;
        }
        MElementContainer parent = relTo.getParent();
        if (parent == null) {
            return;
        }
        List kids = parent.getChildren();
        if (kids == null) {
            return;
        }
        kids.add(kids.indexOf(relTo), newParent);
        kids.remove(relTo);
    }

    public static void insertParent(MElementContainer<MUIElement> newParent, MUIElement relTo) {
        if (newParent == null || relTo == null) {
            return;
        }
        MPart curParent = (MPart)relTo.getParent();
        if (curParent != null) {
            ModeledPageLayout.replace(relTo, newParent);
        }
        newParent.getChildren().add(relTo);
    }

    MUIElement findElement(MUIElement toSearch, String id) {
        List found = this.modelService.findElements(toSearch, id, null, null, 4);
        if (found.size() > 0) {
            return (MUIElement)found.get(0);
        }
        return this.modelService.find(id, toSearch);
    }

    private MPart findPart(MUIElement toSearch, String id) {
        MUIElement element = this.modelService.find(id, toSearch);
        return element instanceof MPart ? (MPart)element : null;
    }

    private MPlaceholder findPlaceholder(MUIElement toSearch, String id) {
        MUIElement element = this.modelService.find(id, toSearch);
        return element instanceof MPlaceholder ? (MPlaceholder)element : null;
    }

    public void addHiddenMenuItemId(String id) {
        this.page.addHiddenItems(this.perspModel, HIDDEN_MENU_PREFIX + id);
    }

    public void addHiddenToolBarItemId(String id) {
        this.page.addHiddenItems(this.perspModel, HIDDEN_TOOLBAR_PREFIX + id);
    }

    public void removePlaceholder(String id) {
        MElementContainer parent;
        MUIElement refModel = this.findElement((MUIElement)this.perspModel, id);
        if (!(refModel instanceof MPlaceholder)) {
            E4Util.unsupported("removePlaceholder: failed to find " + id + ": " + refModel);
            return;
        }
        if (this.modelService.getElementLocation(refModel) != 8 && (parent = refModel.getParent()) != null) {
            parent.getChildren().remove(refModel);
        }
    }

    public void stackView(String id, String refId, boolean visible) {
        MPartStack refModel;
        Object object = refModel = refId.equals(this.getEditorArea()) ? this.editorStack : this.findElement((MUIElement)this.perspModel, refId);
        if (refModel == null && visible) {
            this.addView(id, 1, 0.5f, refId);
            return;
        }
        if (refModel instanceof MPart || refModel instanceof MPlaceholder) {
            refModel = refModel.getParent();
        }
        if (!(refModel instanceof MPartStack)) {
            E4Util.unsupported("stackView: failed to find " + refId + " for " + id);
            return;
        }
        boolean isFiltered = this.isViewFiltered(id);
        boolean toBeRendered = visible && !isFiltered;
        MStackElement viewModel = ModeledPageLayout.createViewModel(this.application, id, toBeRendered, this.page, this.partService, this.createReferences);
        if (viewModel != null) {
            MPartStack stack = refModel;
            boolean wasEmpty = stack.getChildren().isEmpty();
            stack.getChildren().add(viewModel);
            if (wasEmpty && toBeRendered) {
                stack.setSelectedElement((MUIElement)viewModel);
            }
            if (viewModel.isToBeRendered()) {
                this.layoutUtils.resetToBeRenderedFlag((MUIElement)viewModel, true);
            }
            if (isFiltered) {
                this.addViewActivator((MUIElement)viewModel);
            }
        }
    }

    @Override
    public void setEditorOnboardingText(String text) {
        this.perspModel.getTags().add(EDITOR_ONBOARDING_TEXT + text);
    }

    @Override
    public void setEditorOnboardingImageUri(String iconUri) {
        this.perspModel.getTags().add(EDITOR_ONBOARDING_IMAGE + iconUri);
    }

    @Override
    public void addEditorOnboardingCommandId(String commandId) {
        long numberOfOnboardingCommands = this.perspModel.getTags().stream().filter(t -> t.startsWith(EDITOR_ONBOARDING_COMMAND)).count();
        if (numberOfOnboardingCommands >= 5L) {
            return;
        }
        String commandText = "{0}: {1}";
        Predicate<MKeyBinding> commandWithEqualId = b -> b.getCommand().getElementId().equals(commandId);
        Function<MKeyBinding, String> toCommandText = b -> {
            try {
                return NLS.bind((String)commandText, (Object)b.getCommand().getCommandName(), (Object)KeySequence.getInstance((String)b.getKeySequence()).format());
            }
            catch (ParseException parseException) {
                return NLS.bind((String)commandText, (Object)b.getCommand().getCommandName(), (Object)b.getKeySequence());
            }
        };
        this.application.getBindingTables().stream().map(MBindingTable::getBindings).flatMap(Collection::stream).filter(commandWithEqualId).findFirst().map(toCommandText).ifPresent(text -> {
            boolean bl = this.perspModel.getTags().add(EDITOR_ONBOARDING_COMMAND + text);
        });
    }

    private static class ViewActivator
    implements IIdentifierListener {
        private MUIElement element;

        public ViewActivator(MUIElement element) {
            this.element = element;
        }

        @Override
        public void identifierChanged(IdentifierEvent identifierEvent) {
            IIdentifier identifier = identifierEvent.getIdentifier();
            if (!identifier.isEnabled()) {
                return;
            }
            identifier.removeIdentifierListener(this);
            this.element.setToBeRendered(true);
        }
    }
}

