/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.AttributeRule;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.EclipseIniTask;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.RedirectionTask;
import org.eclipse.oomph.setup.ResourceCopyTask;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.ScopeType;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableChoice;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.VariableType;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.WorkspaceTask;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.internal.core.AbstractSetupTaskContext;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.Authenticator;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.setup.log.ProgressLogFilter;
import org.eclipse.oomph.setup.log.ProgressLogMonitor;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Factory;
import org.eclipse.oomph.setup.p2.impl.P2TaskImpl;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.UserCallback;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupTaskPerformer
extends AbstractSetupTaskContext {
    public static final boolean REMOTE_DEBUG = PropertiesUtil.isProperty((String)"oomph.setup.remote.debug");
    public static final boolean USER_HOME_REDIRECT = PropertiesUtil.isProperty((String)"oomph.setup.user.home.redirect");
    public static final Adapter RULE_VARIABLE_ADAPTER = new AdapterImpl();
    private static final Map<String, ValueConverter> CONVERTERS = new HashMap<String, ValueConverter>();
    private static final SimpleDateFormat DATE_TIME;
    private static final Pattern INSTALLABLE_UNIT_WITH_RANGE_PATTERN;
    private static final Pattern ATTRIBUTE_REFERENCE_PATTERN;
    private static final ThreadLocal<IProgressMonitor> CREATION_MONITOR;
    private ProgressLog progress;
    private boolean canceled;
    private boolean skipConfirmation;
    private EList<SetupTask> triggeredSetupTasks;
    private Map<EObject, EObject> copyMap;
    private EList<SetupTask> neededSetupTasks;
    private final Set<Bundle> bundles = new HashSet<Bundle>();
    private List<Object> logMessageBuffer;
    private PrintStream logStream;
    private boolean logStreamError;
    private final ProgressLogFilter logFilter = new ProgressLogFilter();
    private IProgressMonitor progressMonitor;
    private final List<EStructuralFeature.Setting> unresolvedSettings = new ArrayList<EStructuralFeature.Setting>();
    private final List<VariableTask> passwordVariables = new ArrayList<VariableTask>();
    private final Map<URI, String> passwords = new LinkedHashMap<URI, String>();
    private final List<VariableTask> unresolvedVariables = new ArrayList<VariableTask>();
    private final List<VariableTask> resolvedVariables = new ArrayList<VariableTask>();
    private final List<VariableTask> appliedRuleVariables = new ArrayList<VariableTask>();
    private final Map<String, VariableTask> allVariables = new LinkedHashMap<String, VariableTask>();
    private final Set<String> undeclaredVariables = new LinkedHashSet<String>();
    private final Map<VariableTask, EAttribute> ruleAttributes = new LinkedHashMap<VariableTask, EAttribute>();
    private final Map<VariableTask, EAttribute> ruleBasedAttributes = new LinkedHashMap<VariableTask, EAttribute>();
    private final List<AttributeRule> attributeRules = new ArrayList<AttributeRule>();
    private final ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
    private boolean hasSuccessfullyPerformed;

    static {
        CONVERTERS.put("java.lang.String", new ValueConverter());
        CONVERTERS.put("org.eclipse.emf.common.util.URI", new URIValueConverter());
        DATE_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        INSTALLABLE_UNIT_WITH_RANGE_PATTERN = Pattern.compile("([^\\[\\(]*)(.*)");
        ATTRIBUTE_REFERENCE_PATTERN = Pattern.compile("@[\\p{Alpha}_][\\p{Alnum}_]*");
        CREATION_MONITOR = new ThreadLocal();
    }

    public SetupTaskPerformer(URIConverter uriConverter, SetupPrompter prompter, Trigger trigger, SetupContext setupContext, Stream stream) {
        super(uriConverter, prompter, trigger, setupContext);
        this.initTriggeredSetupTasks(stream, true);
    }

    public SetupTaskPerformer(URIConverter uriConverter, SetupPrompter prompter, Trigger trigger, SetupContext setupContext, EList<SetupTask> triggeredSetupTasks) {
        super(uriConverter, prompter, trigger, setupContext);
        this.triggeredSetupTasks = triggeredSetupTasks;
        this.initTriggeredSetupTasks(null, false);
    }

    public String getVMPath() {
        return this.getPrompter().getVMPath();
    }

    public boolean hasSuccessfullyPerformed() {
        return this.hasSuccessfullyPerformed;
    }

    private void initTriggeredSetupTasks(Stream stream, boolean firstPhase) {
        Trigger trigger = this.getTrigger();
        User user = this.getUser();
        if (firstPhase) {
            this.triggeredSetupTasks = new BasicEList(this.getSetupTasks(stream));
            this.bundles.add(SetupCorePlugin.INSTANCE.getBundle());
            LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
            LinkedHashMap instances = new LinkedHashMap();
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (SetupTask setupTask : this.triggeredSetupTasks) {
                Iterator uri;
                Resource resource;
                try {
                    Bundle bundle = FrameworkUtil.getBundle(setupTask.getClass());
                    if (bundle != null) {
                        this.bundles.add(bundle);
                    }
                }
                catch (Throwable throwable) {}
                EClass eClass = setupTask.eClass();
                CollectionUtil.add(instances, (Object)eClass, (Object)setupTask);
                eClasses.add(eClass);
                for (EClass eSuperType : eClass.getEAllSuperTypes()) {
                    if (!SetupPackage.Literals.SETUP_TASK.isSuperTypeOf(eSuperType)) continue;
                    eClasses.add(eSuperType);
                    CollectionUtil.add(instances, (Object)eSuperType, (Object)setupTask);
                }
                if (setupTask instanceof InstallationTask) {
                    resource = this.getInstallation().eResource();
                    if (resource == null || SetupContext.INSTALLATION_SETUP_FILE_NAME_URI.equals(uri = resource.getURI())) continue;
                    InstallationTask installationTask = (InstallationTask)setupTask;
                    installationTask.setLocation(uri.trimSegments(OS.INSTANCE.isMac() ? 6 : 4).toFileString());
                    continue;
                }
                if (setupTask instanceof WorkspaceTask) {
                    resource = this.getWorkspace().eResource();
                    if (resource == null || SetupContext.WORKSPACE_SETUP_FILE_NAME_URI.equals(uri = resource.getURI())) continue;
                    WorkspaceTask workspaceTask = (WorkspaceTask)setupTask;
                    workspaceTask.setLocation(uri.trimSegments(4).toFileString());
                    continue;
                }
                if (!(setupTask instanceof VariableTask)) continue;
                VariableTask variable = (VariableTask)setupTask;
                keys.add(variable.getName());
            }
            for (EClass eClass : eClasses) {
                EList<SetupTask> enablementTasks = SetupTaskPerformer.createEnablementTasks((EModelElement)eClass, true);
                if (enablementTasks != null) {
                    this.triggeredSetupTasks.addAll(0, enablementTasks);
                }
                for (EAnnotation eAnnotation : eClass.getEAnnotations()) {
                    String source = eAnnotation.getSource();
                    if (!"http://www.eclipse.org/oomph/setup/Variable".equals(source)) continue;
                    this.triggeredSetupTasks.add(0, (Object)this.createImpliedVariable(eAnnotation));
                }
                if (user.eResource() == null) continue;
                for (EAttribute eAttribute : eClass.getEAttributes()) {
                    String id;
                    SetupTask setupTask;
                    Object value;
                    AttributeRule attributeRule;
                    EAnnotation eAnnotation;
                    if (eAttribute.getEType().getInstanceClass() != String.class || (eAnnotation = eAttribute.getEAnnotation("http://www.eclipse.org/oomph/setup/Variable")) == null || eAttribute.getEAnnotation("http://www.eclipse.org/oomph/setup/RuleVariable") == null || (attributeRule = this.getAttributeRule(eAttribute, true)) != null) continue;
                    String attributeName = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)eAttribute);
                    Iterator iterator = ((Set)instances.get(eAttribute.getEContainingClass())).iterator();
                    if (!iterator.hasNext() || (value = (setupTask = (SetupTask)iterator.next()).eGet((EStructuralFeature)eAttribute)) != null && !"".equals(value) || StringUtil.isEmpty((String)(id = setupTask.getID())) || keys.contains(String.valueOf(id) + "." + (String)attributeName)) continue;
                    EMap details = eAnnotation.getDetails();
                    String variableName = this.getAttributeRuleVariableName(eAttribute);
                    VariableTask variable = SetupFactory.eINSTANCE.createVariableTask();
                    this.annotateAttributeRuleVariable(variable, eAttribute);
                    variable.setName(variableName);
                    variable.setType(VariableType.get((String)((String)details.get((Object)"type"))));
                    variable.setLabel((String)details.get((Object)"label"));
                    variable.setDescription((String)details.get((Object)"description"));
                    variable.eAdapters().add((Object)RULE_VARIABLE_ADAPTER);
                    for (Iterator subAnnotation : eAnnotation.getEAnnotations()) {
                        if (!"Choice".equals(subAnnotation.getSource())) continue;
                        EMap subDetails = subAnnotation.getDetails();
                        VariableChoice choice = SetupFactory.eINSTANCE.createVariableChoice();
                        choice.setValue((String)subDetails.get((Object)"value"));
                        choice.setLabel((String)subDetails.get((Object)"label"));
                        variable.getChoices().add((Object)choice);
                    }
                    this.unresolvedVariables.add(variable);
                    this.ruleAttributes.put(variable, eAttribute);
                }
            }
            SetupPrompter prompter = this.getPrompter();
            prompter.promptVariables(Collections.singletonList(this));
            this.recordRules(this.attributeRules, false);
        }
        if (!this.triggeredSetupTasks.isEmpty()) {
            Iterator it;
            Map<SetupTask, SetupTask> substitutions = this.getSubstitutions(this.triggeredSetupTasks);
            HashMap<SetupTask, SetupTask> directSubstitutions = new HashMap<SetupTask, SetupTask>(substitutions);
            for (Map.Entry entry : directSubstitutions.entrySet()) {
                SetupTask overridingTask;
                Object task = (SetupTask)entry.getValue();
                while ((overridingTask = (SetupTask)directSubstitutions.get(task)) != null) {
                    entry.setValue(overridingTask);
                    task = overridingTask;
                }
            }
            if (!firstPhase) {
                SetupTask predecessor;
                ListIterator it2;
                SetupTask setupTask2;
                HashMap<SetupTask, SetupTask> overrides = new HashMap<SetupTask, SetupTask>();
                for (Map.Entry entry : substitutions.entrySet()) {
                    SetupTask overriddenSetupTask = (SetupTask)entry.getKey();
                    SetupTask overridingSetupTask = (SetupTask)entry.getValue();
                    overrides.put(overriddenSetupTask, overridingSetupTask);
                    overridingSetupTask.overrideFor(overriddenSetupTask);
                }
                int size = this.triggeredSetupTasks.size();
                Object hashCodes = new int[size];
                int i = 0;
                while (i < size) {
                    setupTask2 = (SetupTask)this.triggeredSetupTasks.get(i);
                    EClass eClass = setupTask2.eClass();
                    int hashCode = eClass.hashCode();
                    for (EAttribute eAttribute : eClass.getEAllAttributes()) {
                        Object value;
                        if (eAttribute.isMany() || eAttribute.isDerived() || (value = setupTask2.eGet((EStructuralFeature)eAttribute)) == null) continue;
                        hashCode ^= value.hashCode();
                    }
                    hashCodes[i] = hashCode;
                    ++i;
                }
                i = size;
                while (--i >= 0) {
                    setupTask2 = (SetupTask)this.triggeredSetupTasks.get(i);
                    if (directSubstitutions.containsKey(setupTask2)) continue;
                    int j = i;
                    while (--j >= 0) {
                        EcoreUtil.EqualityHelper equalityHelper;
                        SetupTask otherSetupTask = (SetupTask)this.triggeredSetupTasks.get(j);
                        if (hashCodes[i] != hashCodes[j] || directSubstitutions.get(otherSetupTask) == setupTask2 || !(equalityHelper = new EcoreUtil.EqualityHelper(){
                            private static final long serialVersionUID = 1L;

                            protected boolean haveEqualReference(EObject eObject1, EObject eObject2, EReference reference) {
                                if (reference == SetupPackage.Literals.SETUP_TASK__PREDECESSORS || reference == SetupPackage.Literals.SETUP_TASK__SUCCESSORS || reference == SetupPackage.Literals.SETUP_TASK__RESTRICTIONS) {
                                    return true;
                                }
                                return super.haveEqualReference(eObject1, eObject2, reference);
                            }
                        }).equals((EObject)setupTask2, (EObject)otherSetupTask)) continue;
                        directSubstitutions.put(otherSetupTask, setupTask2);
                        overrides.put(setupTask2, otherSetupTask);
                        setupTask2.overrideFor(otherSetupTask);
                    }
                }
                UniqueEList.FastCompare remainingSetupTasks = new UniqueEList.FastCompare();
                for (SetupTask setupTask2 : this.triggeredSetupTasks) {
                    SetupTask overridingSetupTask = (SetupTask)directSubstitutions.get(setupTask2);
                    if (overridingSetupTask != null) {
                        remainingSetupTasks.add((Object)overridingSetupTask);
                        continue;
                    }
                    remainingSetupTasks.add((Object)setupTask2);
                }
                for (SetupTask setupTask2 : remainingSetupTasks) {
                    SetupTaskPerformer.checkCancel();
                    EList predecessors = setupTask2.getPredecessors();
                    it2 = predecessors.listIterator();
                    while (it2.hasNext()) {
                        predecessor = (SetupTask)it2.next();
                        SetupTask overridingSetupTask = (SetupTask)directSubstitutions.get(predecessor);
                        if (overridingSetupTask == null) continue;
                        if (predecessors.contains((Object)overridingSetupTask)) {
                            it2.remove();
                            continue;
                        }
                        it2.set(overridingSetupTask);
                    }
                }
                for (SetupTask setupTask2 : remainingSetupTasks) {
                    SetupTaskPerformer.checkCancel();
                    EList predecessors = setupTask2.getPredecessors();
                    it2 = predecessors.listIterator();
                    while (it2.hasNext()) {
                        predecessor = (SetupTask)it2.next();
                        if (!((SetupTaskImpl)predecessor).requiresFast(setupTask2)) continue;
                        it2.remove();
                    }
                }
                this.triggeredSetupTasks = remainingSetupTasks;
            } else {
                String value;
                this.copySetup(stream, this.triggeredSetupTasks, substitutions, directSubstitutions);
                HashMap<String, VariableTask> explicitKeys = new HashMap<String, VariableTask>();
                for (SetupTask setupTask : this.triggeredSetupTasks) {
                    if (!(setupTask instanceof VariableTask)) continue;
                    VariableTask variableTask = (VariableTask)setupTask;
                    String name = variableTask.getName();
                    explicitKeys.put(name, variableTask);
                }
                ListIterator it3 = this.triggeredSetupTasks.listIterator();
                while (it3.hasNext()) {
                    Iterator setupTask = (SetupTask)it3.next();
                    String id = setupTask.getID();
                    if (StringUtil.isEmpty((String)id)) continue;
                    EClass eClass = setupTask.eClass();
                    for (EAttribute eAttribute : eClass.getEAllAttributes()) {
                        String variableValue;
                        if (eAttribute == SetupPackage.Literals.SETUP_TASK__ID || eAttribute.isMany() || eAttribute.getEType().getInstanceClass() != String.class) continue;
                        String variableName = String.valueOf(id) + "." + ExtendedMetaData.INSTANCE.getName((EStructuralFeature)eAttribute);
                        value = (String)setupTask.eGet((EStructuralFeature)eAttribute);
                        EAnnotation variableAnnotation = eAttribute.getEAnnotation("http://www.eclipse.org/oomph/setup/Variable");
                        String variableReference = SetupTaskPerformer.getVariableReference(variableName, variableAnnotation);
                        if (explicitKeys.containsKey(variableName)) {
                            if (!StringUtil.isEmpty((String)value) && !(setupTask instanceof WorkspaceTask) || variableAnnotation == null) continue;
                            setupTask.eSet((EStructuralFeature)eAttribute, variableReference);
                            continue;
                        }
                        VariableTask variable = SetupFactory.eINSTANCE.createVariableTask();
                        this.annotateImpliedVariable(variable, (SetupTask)setupTask, eAttribute);
                        variable.setName(variableName);
                        EObject eContainer = setupTask.eContainer();
                        EReference eContainmentFeature = setupTask.eContainmentFeature();
                        EList list = (EList)eContainer.eGet((EStructuralFeature)eContainmentFeature);
                        list.add((Object)variable);
                        if (StringUtil.isEmpty((String)value)) {
                            if (variableAnnotation != null) {
                                this.ruleBasedAttributes.put(variable, eAttribute);
                                this.populateImpliedVariable((SetupTask)setupTask, eAttribute, variableAnnotation, variable);
                                setupTask.eSet((EStructuralFeature)eAttribute, variableReference);
                            } else if (eAttribute == SetupPackage.Literals.INSTALLATION_TASK__RELATIVE_PRODUCT_FOLDER) {
                                value = this.getRelativeProductFolder();
                                variable.setValue(value);
                            }
                        } else {
                            if (variableAnnotation != null) {
                                this.populateImpliedVariable((SetupTask)setupTask, null, variableAnnotation, variable);
                                setupTask.eSet((EStructuralFeature)eAttribute, variableReference);
                            }
                            variable.setValue(value);
                        }
                        it3.add(variable);
                        explicitKeys.put(variableName, variable);
                        for (EAnnotation ruleVariableAnnotation : eAttribute.getEAnnotations()) {
                            if (!"http://www.eclipse.org/oomph/setup/RuleVariable".equals(ruleVariableAnnotation.getSource())) continue;
                            EMap details = ruleVariableAnnotation.getDetails();
                            VariableTask ruleVariable = SetupFactory.eINSTANCE.createVariableTask();
                            this.annotateRuleVariable(ruleVariable, variable);
                            String ruleVariableName = (String)details.get((Object)"name");
                            ruleVariable.setName(ruleVariableName);
                            ruleVariable.setStorageURI(BaseFactory.eINSTANCE.createURI((String)details.get((Object)"storageURI")));
                            this.populateImpliedVariable((SetupTask)setupTask, null, ruleVariableAnnotation, ruleVariable);
                            it3.add(ruleVariable);
                            explicitKeys.put(ruleVariableName, ruleVariable);
                        }
                        if (variableAnnotation == null || !variableReference.equals(variableValue = variable.getValue()) && !SetupTaskPerformer.getVariableReference(variableName, null).equals(variableValue)) continue;
                        EMap details = variableAnnotation.getDetails();
                        VariableTask explicitVariable = SetupFactory.eINSTANCE.createVariableTask();
                        String explicitVariableName = String.valueOf(variableName) + ".explicit";
                        explicitVariable.setName(explicitVariableName);
                        explicitVariable.setStorageURI(null);
                        explicitVariable.setType(VariableType.get((String)((String)details.get((Object)"explicitType"))));
                        explicitVariable.setLabel(this.expandAttributeReferences((SetupTask)setupTask, (String)details.get((Object)"explicitLabel")));
                        explicitVariable.setDescription(this.expandAttributeReferences((SetupTask)setupTask, (String)details.get((Object)"explicitDescription")));
                        it3.add(explicitVariable);
                        explicitKeys.put(explicitVariableName, explicitVariable);
                        this.annotateRuleVariable(explicitVariable, variable);
                        variable.setValue(SetupTaskPerformer.getVariableReference(explicitVariableName, variableAnnotation));
                    }
                }
                for (SetupTask setupTask : this.triggeredSetupTasks) {
                    this.handleActiveAnnotations(setupTask, explicitKeys);
                }
                LinkedHashSet<String> keys = new LinkedHashSet<String>();
                boolean fullPromptUser = SetupTaskPerformer.isFullPromptUser(user);
                VariableAdapter variableAdapter = new VariableAdapter(this);
                for (SetupTask setupTask2 : this.triggeredSetupTasks) {
                    String promptedValue;
                    if (!(setupTask2 instanceof VariableTask)) continue;
                    VariableTask variable = (VariableTask)setupTask2;
                    variable.eAdapters().add((Object)variableAdapter);
                    String name = variable.getName();
                    keys.add(name);
                    value = variable.getValue();
                    if (!fullPromptUser && variable.getAnnotation("ImpliedVariable") == null && (promptedValue = this.getPrompter().getValue(variable)) != null) {
                        variable.setValue(promptedValue);
                        value = null;
                    }
                    if (variable.getType() == VariableType.PASSWORD) {
                        URIConverter uriConverter;
                        URI storageURI;
                        this.passwordVariables.add(variable);
                        if (StringUtil.isEmpty((String)value) && !fullPromptUser && (storageURI = this.getEffectiveStorage(variable)) != null && "preference".equals(storageURI.scheme()) && (uriConverter = this.getURIConverter()).exists(storageURI, null)) {
                            try {
                                Reader reader = ((URIConverter.ReadableInputStream)uriConverter.createInputStream(storageURI)).asReader();
                                StringBuilder result = new StringBuilder();
                                int character = reader.read();
                                while (character != -1) {
                                    result.append((char)character);
                                    character = reader.read();
                                }
                                reader.close();
                                value = PreferencesUtil.encrypt((String)result.toString());
                            }
                            catch (IOException ex) {
                                SetupCorePlugin.INSTANCE.log(ex);
                            }
                        }
                    }
                    this.put(name, value);
                    this.allVariables.put(name, variable);
                }
                this.expandVariableKeys(keys);
                this.expandStrings(this.triggeredSetupTasks);
                this.flattenPredecessorsAndSuccessors(this.triggeredSetupTasks);
                this.propagateRestrictionsPredecessorsAndSuccessors(this.triggeredSetupTasks);
            }
            this.reorderSetupTasks(this.triggeredSetupTasks);
            if (trigger != null) {
                it = this.triggeredSetupTasks.iterator();
                while (it.hasNext()) {
                    if (((SetupTask)it.next()).getTriggers().contains(trigger)) continue;
                    it.remove();
                }
            }
            it = this.triggeredSetupTasks.iterator();
            while (it.hasNext()) {
                SetupTask setupTask = (SetupTask)it.next();
                setupTask.consolidate();
                if (!(setupTask instanceof VariableTask)) continue;
                VariableTask contextVariableTask = (VariableTask)setupTask;
                if (!this.unresolvedVariables.contains(contextVariableTask)) {
                    this.resolvedVariables.add(contextVariableTask);
                }
                it.remove();
            }
        }
    }

    private String getAttributeRuleVariableName(EAttribute eAttribute) {
        String attributeName = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)eAttribute);
        String variableName = "@<id>." + eAttribute.getEContainingClass() + "." + attributeName;
        return variableName;
    }

    private void handleActiveAnnotations(SetupTask setupTask, Map<String, VariableTask> explicitKeys) {
        for (Annotation annotation : setupTask.getAnnotations()) {
            VariableTask variableTask;
            EStructuralFeature eStructuralFeature;
            String id;
            String value;
            String source = annotation.getSource();
            if ("http://www.eclipse.org/oomph/setup/InheritedChoices".equals(source) && setupTask instanceof VariableTask) {
                VariableTask variableTask2 = (VariableTask)setupTask;
                EList choices = variableTask2.getChoices();
                EMap details = annotation.getDetails();
                String inherit = (String)details.get((Object)"inherit");
                if (inherit == null) continue;
                String[] stringArray = inherit.trim().split("\\s");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String variableName = stringArray[n2];
                    VariableTask referencedVariableTask = explicitKeys.get(variableName);
                    if (referencedVariableTask != null) {
                        for (VariableChoice variableChoice : referencedVariableTask.getChoices()) {
                            value = variableChoice.getValue();
                            String label = variableChoice.getLabel();
                            for (Map.Entry detail : annotation.getDetails().entrySet()) {
                                String detailKey = (String)detail.getKey();
                                String detailValue = (String)detail.getValue();
                                if (detailKey == null || "inherit".equals(detailKey) || detailValue == null) continue;
                                String target = "@{" + detailKey + "}";
                                if (value != null) {
                                    value = value.replace(target, detailValue);
                                }
                                if (label == null) continue;
                                label = label.replace(target, detailValue);
                            }
                            VariableChoice choice = SetupFactory.eINSTANCE.createVariableChoice();
                            choice.setValue(value);
                            choice.setLabel(label);
                            choice.getAnnotations().addAll(EcoreUtil.copyAll((Collection)variableChoice.getAnnotations()));
                            choices.add((Object)choice);
                        }
                    }
                    ++n2;
                }
                continue;
            }
            if (!"http://www.eclipse.org/oomph/setup/InducedChoices".equals(source) || (id = setupTask.getID()) == null) continue;
            EMap details = annotation.getDetails();
            String inherit = (String)details.get((Object)"inherit");
            String target = (String)details.get((Object)"target");
            if (target == null || inherit == null || (eStructuralFeature = BaseUtil.getFeature((EClass)setupTask.eClass(), (String)target)) == null || eStructuralFeature.getEType().getInstanceClass() != String.class || (variableTask = explicitKeys.get(String.valueOf(id) + "." + target)) == null) continue;
            EList targetChoices = variableTask.getChoices();
            if (!targetChoices.isEmpty()) {
                if (StringUtil.isEmpty((String)variableTask.getValue())) continue;
                setupTask.eSet(eStructuralFeature, (Object)SetupTaskPerformer.getVariableReference(variableTask.getName(), null));
                continue;
            }
            EList choices = targetChoices;
            LinkedHashMap<String, String> substitutions = new LinkedHashMap<String, String>();
            for (Map.Entry detail : annotation.getDetails().entrySet()) {
                String detailKey = (String)detail.getKey();
                String detailValue = (String)detail.getValue();
                if (detailKey == null || "inherit".equals(detailKey) || "target".equals(detailKey) || "label".equals(detailKey) || "description".equals(detailKey) || detailValue == null) continue;
                if (detailValue.startsWith("@")) {
                    Object value2;
                    String featureName = detailValue.substring(1);
                    EStructuralFeature referencedEStructuralFeature = BaseUtil.getFeature((EClass)setupTask.eClass(), (String)featureName);
                    if (referencedEStructuralFeature != null && referencedEStructuralFeature.getEType().getInstanceClass() == String.class && !referencedEStructuralFeature.isMany() && (value2 = setupTask.eGet(referencedEStructuralFeature)) != null) {
                        detailValue = value2.toString();
                    }
                }
                substitutions.put("@{" + detailKey + "}", detailValue);
            }
            for (EAttribute eAttribute : setupTask.eClass().getEAllAttributes()) {
                if (eAttribute.getEType().getInstanceClass() != String.class || eAttribute.isMany() || StringUtil.isEmpty((String)(value = (String)setupTask.eGet((EStructuralFeature)eAttribute)))) continue;
                substitutions.put("@{" + ExtendedMetaData.INSTANCE.getName((EStructuralFeature)eAttribute) + "}", value);
            }
            String inheritedLabel = null;
            String inheritedDescription = null;
            String[] stringArray = inherit.trim().split("\\s");
            int n = stringArray.length;
            int detailValue = 0;
            while (detailValue < n) {
                String variableName = stringArray[detailValue];
                VariableTask referencedVariableTask = explicitKeys.get(variableName);
                if (referencedVariableTask != null) {
                    if (inheritedLabel == null) {
                        inheritedLabel = referencedVariableTask.getLabel();
                    }
                    if (inheritedDescription == null) {
                        inheritedDescription = referencedVariableTask.getDescription();
                    }
                    for (VariableChoice variableChoice : referencedVariableTask.getChoices()) {
                        String value3 = variableChoice.getValue();
                        String label = variableChoice.getLabel();
                        for (Map.Entry detail : substitutions.entrySet()) {
                            String detailKey = (String)detail.getKey();
                            String detailValue2 = (String)detail.getValue();
                            if (value3 != null) {
                                value3 = value3.replace(detailKey, detailValue2);
                            }
                            if (label == null) continue;
                            label = label.replace(detailKey, detailValue2);
                        }
                        VariableChoice choice = SetupFactory.eINSTANCE.createVariableChoice();
                        choice.setValue(value3);
                        choice.setLabel(label);
                        choice.getAnnotations().addAll(EcoreUtil.copyAll((Collection)variableChoice.getAnnotations()));
                        choices.add((Object)choice);
                    }
                }
                ++detailValue;
            }
            if (ObjectUtil.equals((Object)setupTask.eGet(eStructuralFeature), (Object)variableTask.getValue())) {
                String explicitDescription;
                String explicitLabel = (String)details.get((Object)"label");
                if (explicitLabel == null) {
                    explicitLabel = inheritedLabel;
                }
                if ((explicitDescription = (String)details.get((Object)"description")) == null) {
                    explicitDescription = inheritedDescription;
                }
                variableTask.setValue(null);
                variableTask.setLabel(explicitLabel);
                variableTask.setDescription(explicitDescription);
            }
            setupTask.eSet(eStructuralFeature, (Object)SetupTaskPerformer.getVariableReference(variableTask.getName(), null));
        }
    }

    private void recordRules(List<AttributeRule> attributeRules, boolean remove) {
        Iterator<VariableTask> it = this.unresolvedVariables.iterator();
        block0: while (it.hasNext()) {
            VariableTask variable = it.next();
            String value = variable.getValue();
            if (value == null) continue;
            String variableName = variable.getName();
            for (Map.Entry<VariableTask, EAttribute> entry : this.ruleAttributes.entrySet()) {
                if (!variableName.equals(entry.getKey().getName())) continue;
                URI uri = SetupTaskPerformer.getAttributeURI(entry.getValue());
                AttributeRule attributeRule = null;
                for (AttributeRule existingAttributeRule : attributeRules) {
                    if (!uri.equals(existingAttributeRule.getAttributeURI())) continue;
                    attributeRule = existingAttributeRule;
                    break;
                }
                if (attributeRule == null) {
                    attributeRule = SetupFactory.eINSTANCE.createAttributeRule();
                    attributeRule.setAttributeURI(uri);
                }
                attributeRule.setValue(value);
                attributeRules.add(attributeRule);
                if (!remove) continue block0;
                it.remove();
                continue block0;
            }
        }
    }

    private void annotateAttributeRuleVariable(VariableTask variable, EAttribute eAttribute) {
        this.annotate((ModelElement)variable, "AttributeRuleVariable", new EObject[]{eAttribute});
    }

    public EAttribute getAttributeRuleVariableData(VariableTask variable) {
        Annotation annotation = variable.getAnnotation("AttributeRuleVariable");
        if (annotation != null) {
            return (EAttribute)annotation.getReferences().get(0);
        }
        return null;
    }

    private void annotateImpliedVariable(VariableTask variable, SetupTask setupTask, EAttribute eAttribute) {
        this.annotate((ModelElement)variable, "ImpliedVariable", new EObject[]{setupTask, eAttribute});
    }

    public EStructuralFeature.Setting getImpliedVariableData(VariableTask variable) {
        Annotation annotation = variable.getAnnotation("ImpliedVariable");
        if (annotation != null) {
            EList references = annotation.getReferences();
            InternalEObject setupTask = (InternalEObject)references.get(0);
            return setupTask.eSetting((EStructuralFeature)references.get(1));
        }
        return null;
    }

    private void annotateRuleVariable(VariableTask variable, VariableTask dependentVariable) {
        this.annotate((ModelElement)variable, "RuleVariable", new EObject[]{dependentVariable});
    }

    public VariableTask getRuleVariableData(VariableTask variable) {
        Annotation annotation = variable.getAnnotation("RuleVariable");
        if (annotation != null) {
            return (VariableTask)annotation.getReferences().get(0);
        }
        return null;
    }

    private void annotate(ModelElement modelElement, String source, EObject ... references) {
        Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
        annotation.setSource(source);
        annotation.getReferences().addAll(Arrays.asList(references));
        modelElement.getAnnotations().add((Object)annotation);
    }

    private VariableTask createImpliedVariable(EAnnotation eAnnotation) {
        EMap details = eAnnotation.getDetails();
        VariableTask variable = SetupFactory.eINSTANCE.createVariableTask();
        variable.setName((String)details.get((Object)"name"));
        this.populateImpliedVariable(null, null, eAnnotation, variable);
        return variable;
    }

    private void populateImpliedVariable(SetupTask setupTask, EAttribute eAttribute, EAnnotation eAnnotation, VariableTask variable) {
        AttributeRule attributeRule;
        EMap details = eAnnotation.getDetails();
        variable.setType(VariableType.get((String)((String)details.get((Object)"type"))));
        variable.setLabel(this.expandAttributeReferences(setupTask, (String)details.get((Object)"label")));
        variable.setDescription(this.expandAttributeReferences(setupTask, (String)details.get((Object)"description")));
        variable.setDefaultValue(this.expandAttributeReferences(setupTask, (String)details.get((Object)"defaultValue")));
        if (details.containsKey((Object)"storageURI")) {
            String storageURIValue = this.expandAttributeReferences(setupTask, (String)details.get((Object)"storageURI"));
            variable.setStorageURI(StringUtil.isEmpty((String)storageURIValue) ? null : URI.createURI((String)storageURIValue));
        }
        if (eAttribute != null && (attributeRule = this.getAttributeRule(eAttribute, false)) != null) {
            VariableType explicitVariableType;
            String value = attributeRule.getValue();
            VariableTask ruleVariable = this.getRuleVariable(variable);
            if (ruleVariable == null) {
                ruleVariable = SetupFactory.eINSTANCE.createVariableTask();
                ruleVariable.setName(this.getAttributeRuleVariableName(eAttribute));
            }
            if ((explicitVariableType = VariableType.get((String)((String)details.get((Object)"explicitType")))) != null) {
                variable.setType(explicitVariableType);
            }
            String explicitLabel = (String)details.get((Object)"explicitLabel");
            variable.setLabel(this.expandAttributeReferences(setupTask, explicitLabel));
            String explicitDescription = (String)details.get((Object)"explicitDescription");
            variable.setDescription(this.expandAttributeReferences(setupTask, explicitDescription));
            String promptedValue = this.getPrompter().getValue(ruleVariable);
            if (promptedValue != null) {
                value = promptedValue;
            }
            String attributeExpandedValue = this.expandAttributeReferences(setupTask, value);
            variable.setValue(attributeExpandedValue);
            this.appliedRuleVariables.add(variable);
            return;
        }
        for (EAnnotation subAnnotation : eAnnotation.getEAnnotations()) {
            if (!"Choice".equals(subAnnotation.getSource())) continue;
            EMap subDetails = subAnnotation.getDetails();
            VariableChoice choice = SetupFactory.eINSTANCE.createVariableChoice();
            String subValue = this.expandAttributeReferences(setupTask, (String)subDetails.get((Object)"value"));
            choice.setValue(subValue);
            choice.setLabel((String)subDetails.get((Object)"label"));
            variable.getChoices().add((Object)choice);
        }
    }

    private String expandAttributeReferences(SetupTask setupTask, String value) {
        if (setupTask == null || value == null) {
            return value;
        }
        EClass eClass = setupTask.eClass();
        Matcher matcher = ATTRIBUTE_REFERENCE_PATTERN.matcher(value);
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (matcher.find()) {
            builder.append(value, index, matcher.start());
            String key = matcher.group().substring(1);
            EStructuralFeature feature = eClass.getEStructuralFeature(key);
            if (feature == null && (feature = BaseUtil.getFeature((EClass)eClass, (String)key)) == null) {
                builder.append('@');
                builder.append(key);
            } else {
                Object featureValue = setupTask.eGet(feature);
                builder.append(featureValue);
            }
            index = matcher.end();
        }
        builder.append(value, index, value.length());
        return builder.toString();
    }

    private AttributeRule getAttributeRule(EAttribute eAttribute, boolean userOnly) {
        AttributeRule attributeRule;
        URI attributeURI = SetupTaskPerformer.getAttributeURI(eAttribute);
        User user = this.getUser();
        AttributeRule attributeRule2 = attributeRule = userOnly ? null : this.getAttributeRule(attributeURI, this.attributeRules);
        if (attributeRule == null) {
            attributeRule = this.getAttributeRule(attributeURI, (List<AttributeRule>)user.getAttributeRules());
        }
        return attributeRule;
    }

    private AttributeRule getAttributeRule(URI attributeURI, List<AttributeRule> attributeRules) {
        for (AttributeRule attributeRule : attributeRules) {
            if (!attributeURI.equals(attributeRule.getAttributeURI())) continue;
            return attributeRule;
        }
        return null;
    }

    public static URI getAttributeURI(EAttribute eAttribute) {
        EClass eClass = eAttribute.getEContainingClass();
        EPackage ePackage = eClass.getEPackage();
        URI uri = URI.createURI((String)ePackage.getNsURI()).appendFragment("//" + eClass.getName() + "/" + eAttribute.getName());
        return uri;
    }

    public Set<Bundle> getBundles() {
        return this.bundles;
    }

    public EList<SetupTask> getTriggeredSetupTasks() {
        return this.triggeredSetupTasks;
    }

    public ExecutableInfo getExecutableInfo() {
        return new ExecutableInfo(this);
    }

    public File getInstallationLocation() {
        for (SetupTask setupTask : this.triggeredSetupTasks) {
            if (!(setupTask instanceof InstallationTask)) continue;
            return new File(((InstallationTask)setupTask).getLocation());
        }
        return null;
    }

    public File getWorkspaceLocation() {
        IPath location;
        IWorkspaceRoot root;
        IWorkspace workspace;
        for (SetupTask setupTask : this.triggeredSetupTasks) {
            if (!(setupTask instanceof WorkspaceTask)) continue;
            return new File(((WorkspaceTask)setupTask).getLocation());
        }
        if (this.getTrigger() != Trigger.BOOTSTRAP && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (workspace = ResourcesPlugin.getWorkspace()) != null && (root = workspace.getRoot()) != null && (location = root.getLocation()) != null) {
            return location.toFile();
        }
        return null;
    }

    public EList<SetupTask> getSetupTasks(Stream stream) {
        BasicEList result = new BasicEList();
        this.addBootstrapTasks((EList<SetupTask>)result);
        User user = this.getUser();
        Installation installation = this.getInstallation();
        Workspace workspace = this.getWorkspace();
        ProductVersion productVersion = installation.getProductVersion();
        if (productVersion != null && !productVersion.eIsProxy()) {
            ArrayList<Scope> configurableItems = new ArrayList<Scope>();
            ArrayList<Object> scopes = new ArrayList<Object>();
            Product product = productVersion.getProduct();
            configurableItems.add((Scope)product);
            scopes.add(product);
            ProductCatalog productCatalog = product.getProductCatalog();
            configurableItems.add((Scope)productCatalog);
            scopes.add(0, productCatalog);
            configurableItems.add((Scope)productVersion);
            scopes.add(productVersion);
            if (stream != null) {
                Project project = stream.getProject();
                ProjectCatalog projectCatalog = project.getProjectCatalog();
                while (project != null) {
                    configurableItems.add((Scope)project);
                    scopes.add(3, project);
                    project = project.getParentProject();
                }
                if (projectCatalog != null) {
                    configurableItems.add((Scope)projectCatalog);
                    scopes.add(3, projectCatalog);
                }
                configurableItems.add((Scope)stream);
                scopes.add(stream);
            }
            scopes.add(user);
            configurableItems.add((Scope)installation);
            scopes.add(installation);
            if (workspace != null) {
                configurableItems.add((Scope)workspace);
                scopes.add(workspace);
            }
            String qualifier = null;
            Scope rootProject = null;
            for (Scope scope : scopes) {
                String description;
                ScopeType type = scope.getType();
                String name = scope.getName();
                String label = scope.getLabel();
                if (label == null) {
                    label = name;
                }
                if ((description = scope.getDescription()) == null) {
                    description = label;
                }
                switch (type) {
                    case PRODUCT_CATALOG: {
                        this.generateScopeVariables((EList<SetupTask>)result, "product.catalog", qualifier, name, label, description);
                        qualifier = name;
                        break;
                    }
                    case PRODUCT: {
                        this.generateScopeVariables((EList<SetupTask>)result, "product", qualifier, name, label, description);
                        qualifier = String.valueOf(qualifier) + "." + name;
                        break;
                    }
                    case PRODUCT_VERSION: {
                        this.generateScopeVariables((EList<SetupTask>)result, "product.version", qualifier, name, label, description);
                        qualifier = null;
                        break;
                    }
                    case PROJECT_CATALOG: {
                        this.generateScopeVariables((EList<SetupTask>)result, "project.catalog", qualifier, name, label, description);
                        qualifier = name;
                        break;
                    }
                    case PROJECT: {
                        this.generateScopeVariables((EList<SetupTask>)result, "project", qualifier, name, label, description);
                        if (rootProject == null && scope.eResource() == stream.eResource()) {
                            rootProject = scope;
                            this.generateScopeVariables((EList<SetupTask>)result, "project.root", qualifier, name, label, description);
                        }
                        qualifier = String.valueOf(qualifier) + "." + name;
                        break;
                    }
                    case STREAM: {
                        this.generateScopeVariables((EList<SetupTask>)result, "project.stream", qualifier, name, label, description);
                        qualifier = null;
                        break;
                    }
                    case INSTALLATION: {
                        this.generateScopeVariables((EList<SetupTask>)result, "installation", qualifier, name, label, description);
                        break;
                    }
                    case WORKSPACE: {
                        this.generateScopeVariables((EList<SetupTask>)result, "workspace", qualifier, name, label, description);
                        break;
                    }
                    case USER: {
                        this.generateScopeVariables((EList<SetupTask>)result, "user", qualifier, name, label, description);
                    }
                }
                this.getSetupTasks((EList<SetupTask>)result, configurableItems, (SetupTaskContainer)scope);
            }
        }
        return result;
    }

    private void addBootstrapTasks(EList<SetupTask> result) {
        String maxThreads;
        this.addEclipseIniTask(result, false, "--launcher.appendVmargs", null);
        String vmPath = this.getVMPath();
        if (vmPath != null) {
            this.addEclipseIniTask(result, false, "-vm", vmPath);
        }
        if ((maxThreads = PropertiesUtil.getProperty((String)"eclipse.p2.max.threads")) != null) {
            this.addEclipseIniTask(result, true, "-Declipse.p2.max.threads", "=" + maxThreads);
        }
        this.addEclipseIniTask(result, true, "-Doomph.update.url", "=" + this.redirect(URI.createURI((String)((String)this.get("oomph.update.url")))));
        this.addIndexRedirection(result, SetupContext.INDEX_SETUP_URI, "");
        this.addIndexRedirection(result, SetupContext.INDEX_SETUP_LOCATION_URI, ".location");
        if (REMOTE_DEBUG) {
            this.addEclipseIniTask(result, true, "-Doomph.setup.remote.debug", "=true");
            this.addEclipseIniTask(result, true, "-Xdebug", "");
            this.addEclipseIniTask(result, true, "-Xrunjdwp:transport", "=dt_socket,server=y,suspend=n,address=8123");
        }
        if (USER_HOME_REDIRECT) {
            this.addEclipseIniTask(result, true, "-Duser.home", "=" + PropertiesUtil.getUserHome());
        }
    }

    private void addIndexRedirection(EList<SetupTask> result, URI indexURI, String name) {
        URI redirectedURI = this.redirect(indexURI);
        if (!redirectedURI.equals(indexURI)) {
            URI baseURI = indexURI.trimSegments(1).appendSegment("");
            URI redirectedBaseURI = this.redirect(baseURI);
            if (!redirectedBaseURI.equals(baseURI)) {
                URI baseBaseURI = baseURI.trimSegments(1).appendSegment("");
                URI redirectedBaseBaseURI = this.redirect(baseBaseURI);
                if (!redirectedBaseBaseURI.equals(baseBaseURI)) {
                    this.addEclipseIniTask(result, true, "-Doomph.redirection.index" + name + ".redirection", "=" + baseBaseURI + "->" + redirectedBaseBaseURI);
                } else {
                    this.addEclipseIniTask(result, true, "-Doomph.redirection.index" + name + ".redirection", "=" + baseURI + "->" + redirectedBaseURI);
                }
            } else if (!redirectedURI.isArchive() || !(SetupContext.INDEX_SETUP_ARCHIVE_LOCATION_URI + "!").equals(redirectedURI.authority())) {
                this.addEclipseIniTask(result, true, "-Doomph.redirection.index" + name + ".redirection", "=" + indexURI + "->" + redirectedURI);
            }
        }
    }

    private void addEclipseIniTask(EList<SetupTask> result, boolean vm, String option, String value) {
        EclipseIniTask task = SetupFactory.eINSTANCE.createEclipseIniTask();
        task.setVm(vm);
        task.setOption(option);
        task.setValue(value);
        task.setExcludedTriggers(new HashSet<Trigger>(Arrays.asList(Trigger.STARTUP, Trigger.MANUAL)));
        result.add((Object)task);
    }

    private void generateScopeVariables(EList<SetupTask> setupTasks, String type, String qualifier, String name, String label, String description) {
        setupTasks.add((Object)this.createVariable(setupTasks, "scope." + type + ".name", name, null));
        if (qualifier != null) {
            setupTasks.add((Object)this.createVariable(setupTasks, "scope." + type + ".name.qualified", String.valueOf(qualifier) + "." + name, null));
        }
        setupTasks.add((Object)this.createVariable(setupTasks, "scope." + type + ".label", label, null));
        setupTasks.add((Object)this.createVariable(setupTasks, "scope." + type + ".description", description, null));
    }

    private VariableTask createVariable(EList<SetupTask> setupTasks, String name, String value, String description) {
        VariableTask variable = SetupFactory.eINSTANCE.createVariableTask();
        variable.setName(name);
        variable.setValue(value);
        variable.setDescription(description);
        return variable;
    }

    private void getSetupTasks(EList<SetupTask> setupTasks, List<Scope> configurableItems, SetupTaskContainer setupTaskContainer) {
        for (SetupTask setupTask : setupTaskContainer.getSetupTasks()) {
            EList restrictions;
            if (setupTask.isDisabled() || !configurableItems.containsAll((Collection<?>)(restrictions = setupTask.getRestrictions())) || !this.matchesFilterContext(setupTask.getFilter())) continue;
            if (setupTask instanceof SetupTaskContainer) {
                SetupTaskContainer container = (SetupTaskContainer)setupTask;
                this.getSetupTasks(setupTasks, configurableItems, container);
                continue;
            }
            setupTasks.add((Object)setupTask);
        }
    }

    public EList<SetupTask> initNeededSetupTasks(IProgressMonitor monitor) throws Exception {
        if (this.neededSetupTasks == null) {
            this.neededSetupTasks = new BasicEList();
            if (!this.undeclaredVariables.isEmpty()) {
                throw new RuntimeException("Missing variables for " + this.undeclaredVariables);
            }
            if (!this.unresolvedVariables.isEmpty()) {
                throw new RuntimeException("Unresolved variables for " + this.unresolvedVariables);
            }
            if (this.triggeredSetupTasks != null) {
                monitor.beginTask("", this.triggeredSetupTasks.size());
                try {
                    for (SetupTask setupTask : this.triggeredSetupTasks) {
                        this.checkCancelation();
                        this.progressMonitor = MonitorUtil.create((IProgressMonitor)monitor, (int)1);
                        try {
                            try {
                                if (setupTask.isNeeded((SetupTaskContext)this)) {
                                    this.neededSetupTasks.add((Object)setupTask);
                                }
                            }
                            catch (NoClassDefFoundError ex) {
                                SetupCorePlugin.INSTANCE.log(ex);
                                this.progressMonitor.done();
                                this.progressMonitor = null;
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            this.progressMonitor.done();
                            this.progressMonitor = null;
                            throw throwable;
                        }
                        this.progressMonitor.done();
                        this.progressMonitor = null;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
        return this.neededSetupTasks;
    }

    public EList<SetupTask> getNeededTasks() {
        return this.neededSetupTasks;
    }

    public Map<EObject, EObject> getCopyMap() {
        return this.copyMap;
    }

    public IProgressMonitor getProgressMonitor(boolean working) {
        if (!working || this.progressMonitor == null) {
            return new ProgressLogMonitor((ProgressLog)this);
        }
        return this.progressMonitor;
    }

    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        if (this.progress != null) {
            return this.progress.isCanceled();
        }
        return false;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isSkipConfirmation() {
        return this.skipConfirmation;
    }

    public void setSkipConfirmation(boolean skipConfirmation) {
        this.skipConfirmation = skipConfirmation;
    }

    public void setTerminating() {
        if (this.progress != null) {
            this.progress.setTerminating();
        }
    }

    public void task(SetupTask setupTask) {
        this.progress.task(setupTask);
        this.log("Performing " + this.getLabel(setupTask), false, ProgressLog.Severity.INFO);
    }

    public void log(Throwable t) {
        this.log(SetupCorePlugin.toString((Throwable)t), false, ProgressLog.Severity.ERROR);
    }

    public void log(IStatus status) {
        this.log(SetupCorePlugin.toString((IStatus)status), false, ProgressLog.Severity.fromStatus((IStatus)status));
    }

    public void log(String line) {
        this.log(line, true, ProgressLog.Severity.OK);
    }

    public void log(String line, ProgressLog.Severity severity) {
        this.log(line, true, severity);
    }

    public void log(String line, boolean filter) {
        this.log(line, filter, ProgressLog.Severity.OK);
    }

    public void log(String line, boolean filter, ProgressLog.Severity severity) {
        if (this.progress != null) {
            if (this.logMessageBuffer != null) {
                for (Object value : this.logMessageBuffer) {
                    ProgressLog.Severity bufferedSeverity;
                    String bufferedLine;
                    if (value instanceof String) {
                        bufferedLine = (String)value;
                        bufferedSeverity = ProgressLog.Severity.OK;
                    } else {
                        Pair pair = (Pair)value;
                        bufferedLine = (String)pair.getElement1();
                        bufferedSeverity = (ProgressLog.Severity)pair.getElement2();
                    }
                    this.doLog(bufferedLine, filter, bufferedSeverity);
                }
                this.logMessageBuffer = null;
            }
            this.doLog(line, filter, severity);
        } else {
            if (this.logMessageBuffer == null) {
                this.logMessageBuffer = new ArrayList<Object>();
            }
            if (severity == ProgressLog.Severity.OK) {
                this.logMessageBuffer.add(line);
            } else {
                this.logMessageBuffer.add(Pair.create((Object)line, (Object)severity));
            }
        }
    }

    private void doLog(String line, boolean filter, ProgressLog.Severity severity) {
        if (filter) {
            line = this.logFilter.filter(line);
        }
        if (line == null) {
            return;
        }
        if (!this.logStreamError) {
            try {
                PrintStream logStream = this.getLogStream(true);
                logStream.println("[" + DATE_TIME.format(new Date()) + "] " + line);
                logStream.flush();
            }
            catch (Exception ex) {
                SetupCorePlugin.INSTANCE.log(ex, 2);
                this.logStreamError = true;
            }
        }
        this.progress.log(line, filter, severity);
    }

    public PrintStream getLogStream() {
        return this.logStream;
    }

    private PrintStream getLogStream(boolean demandCreate) {
        if (this.logStream == null && demandCreate) {
            try {
                File location = this.getProductConfigurationLocation();
                String path = "org.eclipse.oomph.setup/setup.log";
                File logFile = new File(location, path);
                logFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(logFile, true);
                this.logStream = new PrintStream(out);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.logStream;
    }

    public VariableTask getRuleVariable(VariableTask variable) {
        EAttribute eAttribute = this.ruleBasedAttributes.get(variable);
        if (eAttribute != null) {
            for (Map.Entry<VariableTask, EAttribute> entry : this.ruleAttributes.entrySet()) {
                if (entry.getValue() != eAttribute) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public boolean isRuleBased(VariableTask variable) {
        return this.ruleBasedAttributes.containsKey(variable);
    }

    public List<VariableTask> getUnresolvedVariables() {
        return this.unresolvedVariables;
    }

    public List<VariableTask> getPasswordVariables() {
        return this.passwordVariables;
    }

    public Map<VariableTask, EAttribute> getRuleAttributes() {
        return this.ruleAttributes;
    }

    public List<VariableTask> getAppliedRuleVariables() {
        return this.appliedRuleVariables;
    }

    public List<VariableTask> getResolvedVariables() {
        return this.resolvedVariables;
    }

    public Set<String> getUndeclaredVariables() {
        return this.undeclaredVariables;
    }

    public void redirectTriggeredSetupTasks() {
        Map uriMap = this.getURIConverter().getURIMap();
        Iterator it = this.triggeredSetupTasks.iterator();
        while (it.hasNext()) {
            String targetURL;
            SetupTask setupTask = (SetupTask)it.next();
            if (!(setupTask instanceof RedirectionTask)) continue;
            RedirectionTask redirectionTask = (RedirectionTask)setupTask;
            String sourceURL = redirectionTask.getSourceURL();
            if (sourceURL != null && (targetURL = redirectionTask.getTargetURL()) != null) {
                URI sourceURI = URI.createURI((String)sourceURL);
                URI targetURI = URI.createURI((String)targetURL);
                uriMap.put(sourceURI, targetURI);
            }
            it.remove();
        }
        for (SetupTask setupTask : this.triggeredSetupTasks) {
            this.redirectStrings((EObject)setupTask);
            TreeIterator it2 = EcoreUtil.getAllContents((EObject)setupTask, (boolean)false);
            while (it2.hasNext()) {
                this.redirectStrings((EObject)it2.next());
            }
        }
    }

    private void redirectStrings(EObject eObject) {
        EClass eClass = eObject.eClass();
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            String redirectedValue;
            String convertedValue;
            String instanceClassName;
            ValueConverter valueConverter;
            if (!attribute.isChangeable() || attribute.getEAnnotation("http://www.eclipse.org/oomph/setup/Redirect") == null || (valueConverter = CONVERTERS.get(instanceClassName = attribute.getEAttributeType().getInstanceClassName())) == null) continue;
            if (attribute.isMany()) {
                List values = (List)eObject.eGet((EStructuralFeature)attribute);
                ArrayList<Object> newValues = new ArrayList<Object>();
                boolean changed = false;
                for (Object value : values) {
                    String redirectedValue2;
                    String convertedValue2 = valueConverter.convertToString(value);
                    if (!ObjectUtil.equals((Object)convertedValue2, (Object)(redirectedValue2 = this.redirect(convertedValue2)))) {
                        changed = true;
                    }
                    newValues.add(valueConverter.createFromString(redirectedValue2));
                }
                if (!changed) continue;
                eObject.eSet((EStructuralFeature)attribute, newValues);
                continue;
            }
            Object value = eObject.eGet((EStructuralFeature)attribute);
            if (value == null || ObjectUtil.equals((Object)(convertedValue = valueConverter.convertToString(value)), (Object)(redirectedValue = this.redirect(convertedValue)))) continue;
            eObject.eSet((EStructuralFeature)attribute, valueConverter.createFromString(redirectedValue));
        }
    }

    private void expandStrings(EList<SetupTask> setupTasks) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (SetupTask setupTask : setupTasks) {
            this.expandVariableTaskValue(keys, (EObject)setupTask);
        }
        TreeIterator it = EcoreUtil.getAllContents(setupTasks);
        while (it.hasNext()) {
            this.expand(keys, (EObject)it.next());
        }
        this.handleFeatureSubstitutions((Collection<? extends EObject>)setupTasks);
        if (!this.unresolvedSettings.isEmpty()) {
            for (String key : keys) {
                boolean found = false;
                for (SetupTask setupTask : setupTasks) {
                    VariableTask contextVariableTask;
                    if (!(setupTask instanceof VariableTask) || !key.equals((contextVariableTask = (VariableTask)setupTask).getName())) continue;
                    this.unresolvedVariables.add(contextVariableTask);
                    found = true;
                    break;
                }
                if (found) continue;
                this.undeclaredVariables.add(key);
            }
        }
    }

    protected String resolve(String key) {
        return this.lookup(key);
    }

    private String specialResolve(String key) {
        String result = null;
        VariableTask variable = this.allVariables.get(key);
        if (variable != null) {
            result = this.getPrompter().getValue(variable);
        }
        if (StringUtil.isEmpty(result)) {
            variable = SetupFactory.eINSTANCE.createVariableTask();
            variable.setName(key);
            result = this.getPrompter().getValue(variable);
        }
        if (StringUtil.isEmpty((String)result) && StringUtil.isEmpty((String)(result = this.resolve(key))) && StringUtil.isEmpty((String)(result = variable.getValue()))) {
            result = variable.getDefaultValue();
        }
        return result;
    }

    @Override
    protected String filter(String value, String filterName) {
        if (filterName.equalsIgnoreCase("installationID")) {
            String installationID;
            String installRoot = this.specialResolve("install.root");
            if (StringUtil.isEmpty((String)installRoot) || STRING_EXPANSION_PATTERN.matcher(installRoot).find()) {
                return null;
            }
            String projectName = this.lookup("scope.project.root.name");
            if (StringUtil.isEmpty((String)projectName)) {
                installationID = String.valueOf(SegmentSequence.create((String)".", (String)this.lookup("scope.product.name")).lastSegment()) + "-" + this.lookup("scope.product.version.name").replace('.', '-');
            } else {
                String streamName = this.lookup("scope.project.stream.name");
                installationID = this.escape(projectName, streamName);
            }
            String uniqueInstallationID = installationID;
            String relativeProductFolder = this.getRelativeProductFolder();
            int i = 2;
            while (new File(String.valueOf(installRoot) + "/" + uniqueInstallationID + "/" + relativeProductFolder).exists()) {
                uniqueInstallationID = String.valueOf(installationID) + i;
                ++i;
            }
            return uniqueInstallationID;
        }
        if (filterName.equalsIgnoreCase("workspaceID")) {
            String workspaceID;
            String workspaceContainerRoot = this.specialResolve("workspace.container.root");
            if (StringUtil.isEmpty((String)workspaceContainerRoot) || STRING_EXPANSION_PATTERN.matcher(workspaceContainerRoot).find()) {
                return null;
            }
            String projectName = this.lookup("scope.project.root.name");
            String streamName = this.lookup("scope.project.stream.name");
            String uniqueWorkspaceID = workspaceID = String.valueOf(this.escape(projectName, streamName)) + "-ws";
            int i = 2;
            while (new File(String.valueOf(workspaceContainerRoot) + "/" + uniqueWorkspaceID).exists()) {
                uniqueWorkspaceID = String.valueOf(workspaceID) + i;
                ++i;
            }
            return uniqueWorkspaceID;
        }
        return super.filter(value, filterName);
    }

    private String escape(String projectName, String streamName) {
        return (String.valueOf(projectName) + "-" + streamName).replace('.', '-').replace('/', '-').replace('\\', '-');
    }

    protected boolean isUnexpanded(String key) {
        VariableTask variableTask = this.allVariables.get(key);
        if (variableTask != null) {
            for (EStructuralFeature.Setting setting : this.unresolvedSettings) {
                if (setting.getEObject() != variableTask || setting.getEStructuralFeature() != SetupPackage.Literals.VARIABLE_TASK__VALUE) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getVariables(String string) {
        if (string == null) {
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Matcher matcher = STRING_EXPANSION_PATTERN.matcher(string);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (!"$".equals(key)) {
                key = matcher.group(2);
            }
            result.add(key);
        }
        return result;
    }

    public boolean isVariableUsed(String name, EObject eObject, boolean recursive) {
        for (EAttribute attribute : eObject.eClass().getEAllAttributes()) {
            if (attribute.isChangeable() && attribute.getEAttributeType().getInstanceClassName() == "java.lang.String" && attribute != SetupPackage.Literals.VARIABLE_TASK__NAME) {
                if (attribute.isMany()) {
                    List values = (List)eObject.eGet((EStructuralFeature)attribute);
                    for (String value : values) {
                        Set<String> variables = SetupTaskPerformer.getVariables(value);
                        if (!variables.contains(name)) continue;
                        return true;
                    }
                } else {
                    Set<String> variables;
                    String value = (String)eObject.eGet((EStructuralFeature)attribute);
                    if (value != null && (variables = SetupTaskPerformer.getVariables(value)).contains(name)) {
                        return true;
                    }
                }
            }
            if (!recursive) continue;
            for (EObject child : eObject.eContents()) {
                if (!this.isVariableUsed(name, child, recursive)) continue;
                return true;
            }
        }
        return false;
    }

    private void propagateRestrictionsPredecessorsAndSuccessors(EList<SetupTask> setupTasks) {
        for (SetupTask setupTask : setupTasks) {
            EList restrictions = setupTask.getRestrictions();
            EObject eContainer = setupTask.eContainer();
            while (eContainer instanceof SetupTask) {
                restrictions.addAll((Collection)((SetupTask)eContainer).getRestrictions());
                eContainer = eContainer.eContainer();
            }
            EList predecessors = setupTask.getPredecessors();
            EObject eContainer2 = setupTask.eContainer();
            while (eContainer2 instanceof SetupTask) {
                predecessors.addAll((Collection)((SetupTask)eContainer2).getPredecessors());
                eContainer2 = eContainer2.eContainer();
            }
            EList successors = setupTask.getSuccessors();
            EObject eContainer3 = setupTask.eContainer();
            while (eContainer3 instanceof SetupTask) {
                successors.addAll((Collection)((SetupTask)eContainer3).getSuccessors());
                eContainer3 = eContainer3.eContainer();
            }
        }
    }

    private void flattenPredecessorsAndSuccessors(EList<SetupTask> setupTasks) {
        for (SetupTask setupTask : setupTasks) {
            ListIterator it = setupTask.getPredecessors().listIterator();
            while (it.hasNext()) {
                SetupTask predecessor = (SetupTask)it.next();
                if (!(predecessor instanceof SetupTaskContainer)) continue;
                it.remove();
                for (SetupTask expandedPrecessor : ((SetupTaskContainer)predecessor).getSetupTasks()) {
                    it.add(expandedPrecessor);
                    it.previous();
                }
            }
            it = setupTask.getSuccessors().listIterator();
            while (it.hasNext()) {
                SetupTask successor = (SetupTask)it.next();
                if (!(successor instanceof SetupTaskContainer)) continue;
                it.remove();
                for (SetupTask expandedSuccessor : ((SetupTaskContainer)successor).getSetupTasks()) {
                    it.add(expandedSuccessor);
                    it.previous();
                }
            }
        }
    }

    private CompoundTask findOrCreate(AdapterFactoryItemDelegator itemDelegator, Scope configurableItem, EList<SetupTask> setupTasks) {
        CompoundTask compoundSetupTask;
        EObject eContainer = configurableItem.eContainer();
        if (eContainer instanceof Scope) {
            compoundSetupTask = this.findOrCreate(itemDelegator, (Scope)eContainer, setupTasks);
            setupTasks = compoundSetupTask.getSetupTasks();
        }
        if ((compoundSetupTask = this.find(configurableItem, setupTasks)) == null) {
            compoundSetupTask = SetupFactory.eINSTANCE.createCompoundTask();
            compoundSetupTask.setName(itemDelegator.getText((Object)configurableItem));
            compoundSetupTask.getRestrictions().add((Object)configurableItem);
            setupTasks.add((Object)compoundSetupTask);
        }
        return compoundSetupTask;
    }

    private CompoundTask find(Scope configurableItem, EList<SetupTask> setupTasks) {
        block0: for (SetupTask setupTask : setupTasks) {
            if (!(setupTask instanceof CompoundTask)) continue;
            CompoundTask compoundSetupTask = (CompoundTask)setupTask;
            List restrictions = ((InternalEList)compoundSetupTask.getRestrictions()).basicList();
            URI uri = EcoreUtil.getURI((EObject)configurableItem);
            boolean found = false;
            for (Scope restriction : restrictions) {
                URI otherURI = EcoreUtil.getURI((EObject)restriction);
                if (!otherURI.equals(uri)) continue block0;
                found = true;
            }
            if (found) {
                return compoundSetupTask;
            }
            if ((compoundSetupTask = this.find(configurableItem, (EList<SetupTask>)compoundSetupTask.getSetupTasks())) == null) continue;
            return compoundSetupTask;
        }
        return null;
    }

    public void resolveSettings() {
        Object value;
        ArrayList<EStructuralFeature.Setting> unresolvedSettings = new ArrayList<EStructuralFeature.Setting>(this.unresolvedSettings);
        this.unresolvedSettings.clear();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (VariableTask unspecifiedVariable : this.unresolvedVariables) {
            String name = unspecifiedVariable.getName();
            keys.add(name);
            String value2 = unspecifiedVariable.getValue();
            this.put(name, value2);
        }
        for (EStructuralFeature.Setting setting : unresolvedSettings) {
            if (setting.getEStructuralFeature() != SetupPackage.Literals.VARIABLE_TASK__VALUE) continue;
            VariableTask variable = (VariableTask)setting.getEObject();
            String name = variable.getName();
            keys.add(name);
            value = variable.getValue();
            this.put(name, value);
        }
        this.expandVariableKeys(keys);
        for (EStructuralFeature.Setting setting : unresolvedSettings) {
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            ValueConverter valueConverter = CONVERTERS.get(eStructuralFeature.getEType().getInstanceClassName());
            if (eStructuralFeature.isMany()) {
                List values = (List)setting.get(false);
                ListIterator<Object> it = values.listIterator();
                while (it.hasNext()) {
                    it.set(valueConverter.createFromString(this.expandString(valueConverter.convertToString(it.next()))));
                }
                continue;
            }
            value = setting.get(false);
            String expandedString = this.expandString(valueConverter.convertToString(value));
            setting.set(valueConverter.createFromString(expandedString));
            if (eStructuralFeature != SetupPackage.Literals.VARIABLE_TASK__VALUE) continue;
            this.put(((VariableTask)setting.getEObject()).getName(), expandedString);
        }
        this.handleFeatureSubstitutions((Collection<? extends EObject>)this.triggeredSetupTasks);
    }

    private void handleFeatureSubstitutions(Collection<? extends EObject> eObjects) {
        TreeIterator it = EcoreUtil.getAllContents(eObjects);
        while (it.hasNext()) {
            Annotation annotation;
            InternalEObject eObject = (InternalEObject)it.next();
            if (!(eObject instanceof Annotation) || !"http://www.eclipse.org/oomph/setup/FeatureSubstitution".equals((annotation = (Annotation)eObject).getSource())) continue;
            ModelElement modelElement = annotation.getModelElement();
            EClass eClass = modelElement.eClass();
            for (Map.Entry detail : annotation.getDetails()) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature((String)detail.getKey());
                if (!(eStructuralFeature instanceof EAttribute)) continue;
                try {
                    modelElement.eSet(eStructuralFeature, EcoreUtil.createFromString((EDataType)((EAttribute)eStructuralFeature).getEAttributeType(), (String)((String)detail.getValue())));
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    private void expandVariableKeys(Set<String> keys) {
        String value;
        String key;
        LinkedHashMap<String, Set<String>> variables = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<Object, Object> entry : this.getMap().entrySet()) {
            Object entryKey = entry.getKey();
            if (!keys.contains(entryKey)) continue;
            key = (String)entryKey;
            Object entryValue = entry.getValue();
            if (entryValue == null) {
                VariableTask variable = this.allVariables.get(key);
                if (variable == null) continue;
                SetupPrompter prompter = this.getPrompter();
                String value2 = prompter.getValue(variable);
                if (value2 == null) {
                    value2 = variable.getValue();
                }
                if (value2 == null) continue;
                variable.setValue(value2);
                Set<String> valueVariables = SetupTaskPerformer.getVariables(value2);
                variables.put(key, valueVariables);
                this.unresolvedVariables.add(variable);
                if (valueVariables.isEmpty()) continue;
                this.unresolvedSettings.add(((InternalEObject)variable).eSetting((EStructuralFeature)SetupPackage.Literals.VARIABLE_TASK__VALUE));
                continue;
            }
            if (!(entryKey instanceof String)) continue;
            value = entryValue.toString();
            variables.put(key, SetupTaskPerformer.getVariables(value));
        }
        EList<Map.Entry<String, Set<String>>> orderedVariables = this.reorderVariables(variables);
        for (Map.Entry entry : orderedVariables) {
            key = (String)entry.getKey();
            Object object = this.get(key);
            if (object == null) continue;
            value = this.expandString(object.toString());
            this.put(key, value);
        }
    }

    public void recordVariables(Installation installation, Workspace workspace, User user) {
        this.recordRules((List<AttributeRule>)user.getAttributeRules(), true);
        AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory){

            public String getText(Object object) {
                String result = super.getText(object);
                if (object instanceof ProjectCatalog) {
                    if (!result.endsWith("Projects")) {
                        result = String.valueOf(result) + " Projects";
                    }
                } else if (object instanceof ProductCatalog && !result.endsWith("Products")) {
                    result = String.valueOf(result) + " Products";
                }
                return result;
            }
        };
        EList userSetupTasks = user.getSetupTasks();
        if (!this.unresolvedVariables.isEmpty()) {
            this.applyUnresolvedVariables(installation, workspace, user, this.unresolvedVariables, (EList<SetupTask>)userSetupTasks, itemDelegator);
        }
        if (!this.appliedRuleVariables.isEmpty()) {
            ArrayList<VariableTask> productCatalogScopedVariables = new ArrayList<VariableTask>();
            ArrayList<VariableTask> projectCatalogScopedVariables = new ArrayList<VariableTask>();
            EList workspaceScopeTasks = null;
            EList installationScopeTasks = null;
            block5: for (VariableTask unspecifiedVariable : this.appliedRuleVariables) {
                EObject container = unspecifiedVariable.eContainer();
                while (container != null) {
                    if (container instanceof Scope) {
                        Scope scope = (Scope)container;
                        switch (scope.getType()) {
                            case PROJECT_CATALOG: 
                            case PROJECT: 
                            case STREAM: 
                            case WORKSPACE: {
                                if (workspaceScopeTasks == null) {
                                    workspaceScopeTasks = workspace.getSetupTasks();
                                }
                                projectCatalogScopedVariables.add(unspecifiedVariable);
                                break;
                            }
                            case PRODUCT_CATALOG: 
                            case PRODUCT: 
                            case PRODUCT_VERSION: 
                            case INSTALLATION: {
                                if (installationScopeTasks == null) {
                                    installationScopeTasks = installation.getSetupTasks();
                                }
                                productCatalogScopedVariables.add(unspecifiedVariable);
                                break;
                            }
                            case USER: {
                                if (workspace != null) {
                                    if (workspaceScopeTasks == null) {
                                        workspaceScopeTasks = this.findOrCreate(itemDelegator, (Scope)workspace, (EList<SetupTask>)userSetupTasks).getSetupTasks();
                                    }
                                    projectCatalogScopedVariables.add(unspecifiedVariable);
                                }
                                if (installationScopeTasks == null) {
                                    installationScopeTasks = this.findOrCreate(itemDelegator, (Scope)installation, (EList<SetupTask>)userSetupTasks).getSetupTasks();
                                }
                                productCatalogScopedVariables.add(unspecifiedVariable);
                            }
                        }
                        continue block5;
                    }
                    container = container.eContainer();
                }
            }
            this.applyUnresolvedVariables(installation, workspace, user, productCatalogScopedVariables, installationScopeTasks, itemDelegator);
            this.applyUnresolvedVariables(installation, workspace, user, projectCatalogScopedVariables, workspaceScopeTasks, itemDelegator);
        }
    }

    private URI getEffectiveStorage(VariableTask variable) {
        URI storageURI = variable.getStorageURI();
        if (variable.getType() == VariableType.PASSWORD) {
            if (VariableTask.DEFAULT_STORAGE_URI.equals(storageURI)) {
                storageURI = PreferencesUtil.ROOT_PREFERENCE_NODE_URI.appendSegments(new String[]{"secure", "org.eclipse.oomph.setup", variable.getName(), ""});
            } else if (storageURI != null && "preference".equals(storageURI.scheme()) && !storageURI.hasTrailingPathSeparator()) {
                storageURI = storageURI.appendSegment("");
            }
        }
        return storageURI;
    }

    public void savePasswords() {
        for (Map.Entry<URI, String> entry : this.passwords.entrySet()) {
            String value = PreferencesUtil.decrypt((String)entry.getValue());
            if (StringUtil.isEmpty((String)value) || " ".equals(value)) continue;
            URI storageURI = entry.getKey();
            URIConverter uriConverter = this.getURIConverter();
            try {
                Writer writer = ((URIConverter.WriteableOutputStream)uriConverter.createOutputStream(storageURI)).asWriter();
                writer.write(value);
                writer.close();
            }
            catch (IOException ex) {
                SetupCorePlugin.INSTANCE.log(ex);
            }
        }
    }

    private void applyUnresolvedVariables(Installation installation, Workspace workspace, User user, Collection<VariableTask> variables, EList<SetupTask> rootTasks, AdapterFactoryItemDelegator itemDelegator) {
        String value;
        Resource installationResource = installation.eResource();
        Resource workspaceResource = workspace == null ? null : workspace.eResource();
        Resource userResource = user.eResource();
        ArrayList<VariableTask> unspecifiedVariables = new ArrayList<VariableTask>();
        for (VariableTask variable : variables) {
            URI storageURI = this.getEffectiveStorage(variable);
            if (storageURI == null || (value = variable.getValue()) == null) continue;
            if (variable.getType() == VariableType.PASSWORD) {
                this.passwords.put(storageURI, value);
                continue;
            }
            Scope scope = variable.getScope();
            if (scope != null && storageURI.equals(VariableTask.DEFAULT_STORAGE_URI)) {
                switch (scope.getType()) {
                    case INSTALLATION: {
                        this.apply(installationResource, scope, variable, value);
                        break;
                    }
                    case WORKSPACE: {
                        this.apply(workspaceResource, scope, variable, value);
                        break;
                    }
                    case USER: {
                        this.apply(userResource, scope, variable, value);
                        break;
                    }
                    default: {
                        unspecifiedVariables.add(variable);
                        break;
                    }
                }
                continue;
            }
            unspecifiedVariables.add(variable);
        }
        block6: for (VariableTask unspecifiedVariable : unspecifiedVariables) {
            String name = unspecifiedVariable.getName();
            value = unspecifiedVariable.getValue();
            URI storageURI = unspecifiedVariable.getStorageURI();
            EList targetSetupTasks = rootTasks;
            Scope scope = unspecifiedVariable.getScope();
            if (scope != null) {
                if (storageURI.equals(VariableTask.WORKSPACE_STORAGE_URI)) {
                    if (workspace != null) {
                        targetSetupTasks = workspace.getSetupTasks();
                    }
                } else if (storageURI.equals(VariableTask.INSTALLATION_STORAGE_URI)) {
                    targetSetupTasks = installation.getSetupTasks();
                }
                if (unspecifiedVariable.getAnnotation("http://www.eclipse.org/oomph/setup/GlobalVariable") == null) {
                    targetSetupTasks = this.findOrCreate(itemDelegator, scope, (EList<SetupTask>)targetSetupTasks).getSetupTasks();
                }
            }
            for (SetupTask setupTask : targetSetupTasks) {
                VariableTask variable;
                if (!(setupTask instanceof VariableTask) || !name.equals((variable = (VariableTask)setupTask).getName())) continue;
                variable.setValue(value);
                continue block6;
            }
            VariableTask userPreference = (VariableTask)EcoreUtil.copy((EObject)unspecifiedVariable);
            userPreference.getAnnotations().clear();
            userPreference.getChoices().clear();
            userPreference.setStorageURI(VariableTask.DEFAULT_STORAGE_URI);
            targetSetupTasks.add((Object)userPreference);
        }
    }

    private void apply(Resource resource, Scope scope, VariableTask variable, String value) {
        String uriFragment = scope.eResource().getURIFragment((EObject)variable);
        EObject eObject = resource.getEObject(uriFragment);
        if (eObject instanceof VariableTask) {
            VariableTask targetVariable = (VariableTask)eObject;
            if (variable.getName().equals(targetVariable.getName())) {
                targetVariable.setValue(value);
            }
        }
    }

    private void expandVariableTaskValue(Set<String> keys, EObject eObject) {
        VariableTask variableTask;
        String value;
        if (eObject instanceof VariableTask && (value = (variableTask = (VariableTask)eObject).getValue()) != null) {
            String newValue = this.expandString(value, keys);
            if (newValue == null) {
                this.unresolvedSettings.add(((InternalEObject)eObject).eSetting((EStructuralFeature)SetupPackage.Literals.VARIABLE_TASK__VALUE));
            } else if (!value.equals(newValue)) {
                variableTask.setValue(newValue);
            }
        }
    }

    private void expand(Set<String> keys, EObject eObject) {
        EClass eClass = eObject.eClass();
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            String newValue;
            String instanceClassName;
            ValueConverter valueConverter;
            if (!attribute.isChangeable() || attribute.getEAnnotation("http://www.eclipse.org/oomph/setup/NoExpand") != null || (valueConverter = CONVERTERS.get(instanceClassName = attribute.getEAttributeType().getInstanceClassName())) == null) continue;
            if (attribute.isMany()) {
                List values = (List)eObject.eGet((EStructuralFeature)attribute);
                ArrayList<Object> newValues = new ArrayList<Object>();
                boolean failed = false;
                for (Object value : values) {
                    String newValue2 = this.expandString(valueConverter.convertToString(value), keys);
                    if (newValue2 == null) {
                        if (failed) continue;
                        this.unresolvedSettings.add(((InternalEObject)eObject).eSetting((EStructuralFeature)attribute));
                        failed = true;
                        continue;
                    }
                    newValues.add(valueConverter.createFromString(newValue2));
                }
                if (failed) continue;
                eObject.eSet((EStructuralFeature)attribute, newValues);
                continue;
            }
            Object value = eObject.eGet((EStructuralFeature)attribute);
            if (value == null) continue;
            if (attribute == SetupPackage.Literals.VARIABLE_TASK__DEFAULT_VALUE) {
                newValue = this.expandString(valueConverter.convertToString(value), new LinkedHashSet());
                eObject.eSet((EStructuralFeature)attribute, valueConverter.createFromString(newValue));
                continue;
            }
            if (attribute == SetupPackage.Literals.VARIABLE_TASK__VALUE) continue;
            newValue = this.expandString(valueConverter.convertToString(value), keys);
            if (newValue == null) {
                this.unresolvedSettings.add(((InternalEObject)eObject).eSetting((EStructuralFeature)attribute));
                continue;
            }
            Object object = valueConverter.createFromString(newValue);
            if (value.equals(object)) continue;
            eObject.eSet((EStructuralFeature)attribute, object);
        }
    }

    private void performTask(SetupTask task, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("", 101);
        try {
            this.progressMonitor = MonitorUtil.create((IProgressMonitor)monitor, (int)1);
            if (task.isNeeded((SetupTaskContext)this)) {
                this.progressMonitor.done();
                this.progressMonitor = MonitorUtil.create((IProgressMonitor)monitor, (int)100);
                task.perform((SetupTaskContext)this);
            } else {
                this.progressMonitor.done();
                monitor.worked(100);
            }
        }
        finally {
            this.progressMonitor.done();
            this.progressMonitor = null;
            monitor.done();
        }
    }

    public void perform(IProgressMonitor monitor) throws Exception {
        boolean bootstrap = this.getTrigger() == Trigger.BOOTSTRAP;
        monitor.beginTask("", 100 + (bootstrap ? 3 : 0));
        try {
            CacheUsageConfirmer cacheUsageConfirmer = (CacheUsageConfirmer)this.get(CacheUsageConfirmer.class);
            if (cacheUsageConfirmer != null) {
                cacheUsageConfirmer.reset();
            }
            this.performTriggeredSetupTasks((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)100));
            if (bootstrap) {
                this.performPostBootstrapTasks(monitor);
            }
        }
        finally {
            monitor.done();
            this.log("", false);
        }
        this.hasSuccessfullyPerformed = true;
    }

    private void performPostBootstrapTasks(IProgressMonitor monitor) throws Exception {
        File bundlePool;
        Profile profile;
        File installFolder;
        this.log("Performing post bootstrap tasks", false, ProgressLog.Severity.INFO);
        File productConfigurationLocation = this.getProductConfigurationLocation();
        if (OS.INSTANCE.isMac()) {
            File file = new File(productConfigurationLocation, "config.ini");
            this.log("Changing " + file + " (osgi.configuration.cascaded=false)", false, ProgressLog.Severity.OK);
            Map configIni = PropertiesUtil.loadProperties((File)file);
            configIni.put("osgi.configuration.cascaded", "false");
            P2TaskImpl.saveConfigIni((File)file, (Map)configIni, SetupTaskPerformer.class);
        }
        if (!(installFolder = (profile = this.getProfile()).getInstallFolder()).equals(bundlePool = profile.getBundlePool().getLocation())) {
            File garbageCollectorPreferences = new File(productConfigurationLocation, ".settings/org.eclipse.equinox.p2.garbagecollector.prefs");
            IOUtil.writeLines((File)garbageCollectorPreferences, (String)"8859_1", Arrays.asList("eclipse.preferences.version=1", "gc_enabled=false"));
        }
        monitor.worked(1);
        URIConverter uriConverter = this.getURIConverter();
        String[] networkPreferences = new String[]{".settings", "org.eclipse.core.net.prefs"};
        URI networkPreferencesSourceLocation = SetupContext.CONFIGURATION_LOCATION_URI.appendSegments(networkPreferences);
        if (uriConverter.exists(networkPreferencesSourceLocation, null)) {
            URI targetURI = URI.createFileURI((String)productConfigurationLocation.toString()).appendSegments(networkPreferences);
            ResourceCopyTask resourceCopyTask = SetupFactory.eINSTANCE.createResourceCopyTask();
            resourceCopyTask.setSourceURL(networkPreferencesSourceLocation.toString());
            resourceCopyTask.setTargetURL(targetURI.toString());
            this.performTask((SetupTask)resourceCopyTask, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
        } else {
            monitor.worked(1);
        }
        File workspaceLocation = this.getWorkspaceLocation();
        if (workspaceLocation != null) {
            String[] jschPreferences = new String[]{".metadata", ".plugins", "org.eclipse.core.runtime", ".settings", "org.eclipse.jsch.core.prefs"};
            URI jschPreferencesSourceLocation = SetupContext.CONFIGURATION_LOCATION_URI.appendSegments(jschPreferences);
            if (uriConverter.exists(jschPreferencesSourceLocation, null)) {
                URI targetURI = URI.createFileURI((String)workspaceLocation.toString()).appendSegments(jschPreferences);
                if (!uriConverter.exists(targetURI, null)) {
                    ResourceCopyTask resourceCopyTask = SetupFactory.eINSTANCE.createResourceCopyTask();
                    resourceCopyTask.setSourceURL(jschPreferencesSourceLocation.toString());
                    resourceCopyTask.setTargetURL(targetURI.toString());
                    this.performTask((SetupTask)resourceCopyTask, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                } else {
                    monitor.worked(1);
                }
            } else {
                monitor.worked(1);
            }
        } else {
            monitor.worked(1);
        }
    }

    private void performTriggeredSetupTasks(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("", 101);
        try {
            this.initNeededSetupTasks((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
            if (!this.neededSetupTasks.isEmpty()) {
                this.performNeededSetupTasks((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)100));
            } else {
                monitor.worked(100);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void performNeededSetupTasks(IProgressMonitor monitor) throws Exception {
        this.setPerforming(true);
        if (this.getTrigger() == Trigger.BOOTSTRAP) {
            this.doPerformNeededSetupTasks(monitor);
        } else if (SetupContext.USE_RESOURCES_BUNDLE) {
            WorkspaceUtil.performNeededSetupTasks(this, monitor);
        } else {
            this.doPerformNeededSetupTasks(monitor);
        }
    }

    private void doPerformNeededSetupTasks(IProgressMonitor monitor) throws Exception {
        Boolean autoBuilding;
        block16: {
            autoBuilding = null;
            try {
                try {
                    int work;
                    Trigger trigger = this.getTrigger();
                    if (trigger != Trigger.BOOTSTRAP) {
                        autoBuilding = SetupTaskPerformer.disableAutoBuilding();
                    }
                    this.logJREInfos();
                    this.logSetupInfos();
                    this.logBundleInfos();
                    int totalWork = 0;
                    for (SetupTask neededTask : this.neededSetupTasks) {
                        work = Math.max(0, neededTask.getProgressMonitorWork());
                        totalWork += work;
                    }
                    monitor.beginTask("", totalWork);
                    for (SetupTask neededTask : this.neededSetupTasks) {
                        block17: {
                            PreferenceTask preferenceTask;
                            this.checkCancelation();
                            if (trigger != Trigger.BOOTSTRAP && neededTask.getPriority() >= 300 && !this.getRestartReasons().isEmpty()) break block16;
                            this.task(neededTask);
                            work = Math.max(0, neededTask.getProgressMonitorWork());
                            this.progressMonitor = MonitorUtil.create((IProgressMonitor)monitor, (int)work);
                            if (!(neededTask instanceof PreferenceTask) || !"/instance/org.eclipse.core.resources/description.autobuilding".equals((preferenceTask = (PreferenceTask)neededTask).getKey())) break block17;
                            String value = preferenceTask.getValue();
                            autoBuilding = value == null ? Boolean.TRUE : Boolean.valueOf(value);
                            neededTask.dispose();
                            this.progressMonitor.done();
                            this.progressMonitor = null;
                            continue;
                        }
                        try {
                            try {
                                neededTask.perform((SetupTaskContext)this);
                                neededTask.dispose();
                            }
                            catch (NoClassDefFoundError ex) {
                                this.log(ex);
                                this.progressMonitor.done();
                                this.progressMonitor = null;
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            this.progressMonitor.done();
                            this.progressMonitor = null;
                            throw throwable;
                        }
                        this.progressMonitor.done();
                        this.progressMonitor = null;
                    }
                }
                catch (OperationCanceledException ex) {
                    monitor.setCanceled(true);
                    throw ex;
                }
                catch (InterruptedException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    this.log(ex);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                if (Boolean.TRUE.equals(autoBuilding)) {
                    boolean disabled = PDEAPIUtil.setDisableAPIAnalysisBuilder(true);
                    Job buildJob = new Job("Build", disabled){
                        private final /* synthetic */ boolean val$disabled;
                        {
                            this.val$disabled = bl;
                            super($anonymous0);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                EcorePlugin.getWorkspaceRoot().getWorkspace().build(10, monitor);
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            catch (CoreException ex) {
                                IStatus iStatus = SetupCorePlugin.INSTANCE.getStatus((Object)ex);
                                return iStatus;
                            }
                            finally {
                                try {
                                    SetupTaskPerformer.restoreAutoBuilding(true);
                                }
                                catch (CoreException ex) {
                                    SetupCorePlugin.INSTANCE.log(ex);
                                }
                                if (!this.val$disabled) {
                                    PDEAPIUtil.setDisableAPIAnalysisBuilder(false);
                                }
                            }
                        }

                        public boolean belongsTo(Object family) {
                            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
                        }
                    };
                    buildJob.setRule((ISchedulingRule)EcorePlugin.getWorkspaceRoot());
                    buildJob.schedule();
                }
                throw throwable;
            }
        }
        monitor.done();
        if (Boolean.TRUE.equals(autoBuilding)) {
            boolean disabled = PDEAPIUtil.setDisableAPIAnalysisBuilder(true);
            Job buildJob = new /* invalid duplicate definition of identical inner class */;
            buildJob.setRule((ISchedulingRule)EcorePlugin.getWorkspaceRoot());
            buildJob.schedule();
        }
    }

    private void logJREInfos() {
        this.log(String.valueOf(System.getProperty("java.runtime.name")) + " " + System.getProperty("java.runtime.version"));
    }

    private void logSetupInfos() {
        Workspace workspace;
        SetupContext setupContext = this.getSetupContext();
        Installation installation = setupContext.getInstallation();
        if (installation != null) {
            ProductVersion productVersion = installation.getProductVersion();
            this.log("Product " + productVersion.getQualifiedName());
        }
        if ((workspace = setupContext.getWorkspace()) != null) {
            for (Stream stream : workspace.getStreams()) {
                this.log("Project " + stream.getQualifiedName());
            }
        }
    }

    private void logBundleInfos() {
        ArrayList<String> bundleInfos = new ArrayList<String>();
        for (Bundle bundle : this.bundles) {
            StringBuilder builder;
            block11: {
                builder = new StringBuilder("Bundle ");
                builder.append(bundle.getSymbolicName());
                builder.append(" ");
                builder.append(bundle.getVersion());
                InputStream source = null;
                try {
                    try {
                        URL url = bundle.getResource("about.mappings");
                        if (url != null) {
                            String gitCommit;
                            String gitBranch;
                            source = url.openStream();
                            Properties properties = new Properties();
                            properties.load(source);
                            String buildID = (String)properties.get("0");
                            if (buildID != null && !buildID.startsWith("$")) {
                                builder.append(", build=");
                                builder.append(buildID);
                            }
                            if ((gitBranch = (String)properties.get("1")) != null && !gitBranch.startsWith("$")) {
                                builder.append(", branch=");
                                builder.append(gitBranch);
                            }
                            if ((gitCommit = (String)properties.get("2")) != null && !gitCommit.startsWith("$")) {
                                builder.append(", commit=");
                                builder.append(gitCommit);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        IOUtil.closeSilent(source);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent(source);
                    throw throwable;
                }
                IOUtil.closeSilent(source);
            }
            bundleInfos.add(builder.toString());
        }
        Collections.sort(bundleInfos);
        for (String bundleInfo : bundleInfos) {
            this.log(bundleInfo);
        }
    }

    private Map<SetupTask, SetupTask> getSubstitutions(EList<SetupTask> setupTasks) {
        LinkedHashMap<Object, SetupTask> overrides = new LinkedHashMap<Object, SetupTask>();
        LinkedHashMap<SetupTask, SetupTask> substitutions = new LinkedHashMap<SetupTask, SetupTask>();
        for (SetupTask setupTask : setupTasks) {
            Object overrideToken = setupTask.getOverrideToken();
            SetupTask overriddenTask = overrides.put(overrideToken, setupTask);
            if (overriddenTask == null) continue;
            substitutions.put(overriddenTask, setupTask);
        }
        return substitutions;
    }

    private void gather(Set<EObject> roots, Set<Scope> scopesToCopy, EObject eObject) {
        EObject result = eObject;
        EObject parent = eObject;
        while (parent != null) {
            if (parent instanceof Scope && !scopesToCopy.add((Scope)parent)) {
                return;
            }
            result = parent;
            parent = parent.eContainer();
        }
        roots.add(result);
    }

    private void copySetup(Stream stream, EList<SetupTask> setupTasks, Map<SetupTask, SetupTask> substitutions, Map<SetupTask, SetupTask> directSubstitutions) {
        Installation originalInstallation;
        User originalPreferences;
        LinkedHashSet<EObject> roots = new LinkedHashSet<EObject>();
        final LinkedHashSet<Scope> scopesToCopy = new LinkedHashSet<Scope>();
        Workspace originalWorkspace = this.getWorkspace();
        if (originalWorkspace != null) {
            scopesToCopy.add((Scope)originalWorkspace);
            roots.add((EObject)originalWorkspace);
            if (stream != null) {
                this.gather(roots, scopesToCopy, (EObject)stream);
            }
        }
        if ((originalPreferences = this.getUser()) != null) {
            scopesToCopy.add((Scope)originalPreferences);
            roots.add((EObject)originalPreferences);
        }
        if ((originalInstallation = this.getInstallation()) != null) {
            scopesToCopy.add((Scope)originalInstallation);
            roots.add((EObject)originalInstallation);
            for (EObject eObject : originalInstallation.eCrossReferences()) {
                this.gather(roots, scopesToCopy, eObject);
            }
        }
        for (SetupTask setupTask : setupTasks) {
            this.gather(roots, scopesToCopy, (EObject)setupTask);
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, stream == null){
            private static final long serialVersionUID = 1L;

            public <T> Collection<T> copyAll(Collection<? extends T> eObjects) {
                ArrayList<EObject> result = new ArrayList<EObject>(eObjects.size());
                for (T object : eObjects) {
                    EObject t = this.copy((EObject)object);
                    if (t == null) continue;
                    result.add(t);
                }
                return result;
            }

            protected EObject createCopy(EObject eObject) {
                if (eObject instanceof Scope && !scopesToCopy.contains(eObject)) {
                    return null;
                }
                return super.createCopy(eObject);
            }
        };
        copier.copyAll(roots);
        LinkedHashMap<Resource.Internal, Resource> resourceCopies = new LinkedHashMap<Resource.Internal, Resource>();
        Set originals = copier.keySet();
        for (InternalEObject original : originals) {
            Resource newResource;
            Resource.Internal resource = original.eDirectResource();
            if (resource == null || (newResource = (Resource)resourceCopies.get(resource)) != null) continue;
            URI uri = resource.getURI();
            ResourceSet resourceSet = resource.getResourceSet();
            Iterator resourceFactoryRegistry = resourceSet == null ? SetupCoreUtil.RESOURCE_FACTORY_REGISTRY : resourceSet.getResourceFactoryRegistry();
            newResource = resourceFactoryRegistry.getFactory(uri).createResource(uri);
            resourceCopies.put(resource, newResource);
        }
        for (Map.Entry entry : resourceCopies.entrySet()) {
            Resource originalResource = (Resource)entry.getKey();
            Resource copyResource = (Resource)entry.getValue();
            EList copyResourceContents = copyResource.getContents();
            for (EObject eObject : originalResource.getContents()) {
                EObject copy = (EObject)copier.get((Object)eObject);
                if (copy == null) {
                    copy = EcoreFactory.eINSTANCE.createEObject();
                }
                copyResourceContents.add((Object)copy);
            }
        }
        LinkedHashMap<URI, EObject> originalCrossReferences = new LinkedHashMap<URI, EObject>();
        if (originalWorkspace != null) {
            for (EObject eObject : originalWorkspace.eCrossReferences()) {
                originalCrossReferences.put(EcoreUtil.getURI((EObject)eObject), eObject);
            }
        }
        for (EObject copiedObject : new ArrayList(copier.values())) {
            Object uri;
            EObject originalObject;
            if (!(copiedObject instanceof Stream) || (originalObject = (EObject)originalCrossReferences.get(uri = EcoreUtil.getURI((EObject)copiedObject))) == null) continue;
            copier.put((Object)originalObject, (Object)copiedObject);
        }
        LinkedHashMap originalCopier = new LinkedHashMap(copier);
        for (Map.Entry entry : directSubstitutions.entrySet()) {
            SetupTask overriddenTask = (SetupTask)entry.getKey();
            SetupTask overridingTask = (SetupTask)entry.getValue();
            EObject copy = (EObject)copier.get((Object)overridingTask);
            copier.put((Object)overriddenTask, copy == null ? overridingTask : copy);
        }
        this.copyMap = copier;
        copier.copyReferences();
        for (Map.Entry entry : substitutions.entrySet()) {
            SetupTask originalOverridingSetupTask;
            SetupTask overridingSetupTask;
            SetupTask originalOverriddenSetupTask = (SetupTask)entry.getKey();
            SetupTask overriddenSetupTask = (SetupTask)originalCopier.get(originalOverriddenSetupTask);
            if (overriddenSetupTask == null) {
                overriddenSetupTask = originalOverriddenSetupTask;
            }
            if ((overridingSetupTask = (SetupTask)originalCopier.get(originalOverridingSetupTask = (SetupTask)entry.getValue())) == null) {
                overridingSetupTask = originalOverridingSetupTask;
            }
            overridingSetupTask.overrideFor(overriddenSetupTask);
        }
        ListIterator it = setupTasks.listIterator();
        while (it.hasNext()) {
            SetupTask setupTask = (SetupTask)it.next();
            if (directSubstitutions.containsKey(setupTask)) {
                it.remove();
                continue;
            }
            SetupTask copy = (SetupTask)copier.get((Object)setupTask);
            it.set(copy);
        }
        this.setSetupContext(SetupContext.create((Installation)copier.get((Object)originalInstallation), (Workspace)copier.get((Object)originalWorkspace), (User)copier.get((Object)originalPreferences)));
    }

    private EList<Map.Entry<String, Set<String>>> reorderVariables(final Map<String, Set<String>> variables) {
        BasicEList list = new BasicEList(variables.entrySet());
        SetupCoreUtil.reorder(list, new SetupCoreUtil.DependencyProvider<Map.Entry<String, Set<String>>>(){

            @Override
            public Collection<Map.Entry<String, Set<String>>> getDependencies(Map.Entry<String, Set<String>> variable) {
                ArrayList<Map.Entry<String, Set<String>>> result = new ArrayList<Map.Entry<String, Set<String>>>();
                for (String key : variable.getValue()) {
                    for (Map.Entry entry : variables.entrySet()) {
                        if (!((String)entry.getKey()).equals(key)) continue;
                        result.add(entry);
                    }
                }
                return result;
            }
        });
        return list;
    }

    private void reorderSetupTasks(EList<SetupTask> setupTasks) {
        ECollections.sort(setupTasks, (Comparator)new Comparator<SetupTask>(){

            @Override
            public int compare(SetupTask setupTask1, SetupTask setupTask2) {
                return setupTask1.getPriority() - setupTask2.getPriority();
            }
        });
        final LinkedHashMap dependencies = new LinkedHashMap();
        for (SetupTask setupTask : setupTasks) {
            CollectionUtil.addAll(dependencies, (Object)setupTask, (Collection)setupTask.getPredecessors());
            for (SetupTask successor : setupTask.getSuccessors()) {
                CollectionUtil.add(dependencies, (Object)successor, (Object)setupTask);
            }
        }
        SetupCoreUtil.reorder(setupTasks, new SetupCoreUtil.DependencyProvider<SetupTask>(){

            @Override
            public Collection<SetupTask> getDependencies(SetupTask setupTask) {
                return (Collection)dependencies.get(setupTask);
            }
        });
        SetupTask previousSetupTask = null;
        for (SetupTask setupTask : setupTasks) {
            setupTask.getSuccessors().clear();
            EList predecessors = setupTask.getPredecessors();
            predecessors.clear();
            if (setupTask instanceof VariableTask) continue;
            if (previousSetupTask != null) {
                predecessors.add((Object)previousSetupTask);
            }
            previousSetupTask = setupTask;
        }
    }

    private String getLabel(SetupTask setupTask) {
        int eol;
        String type;
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)setupTask, IItemLabelProvider.class);
        try {
            Method getTypeTextMethod = ReflectUtil.getMethod(labelProvider.getClass(), (String)"getTypeText", (Class[])new Class[]{Object.class});
            getTypeTextMethod.setAccessible(true);
            type = getTypeTextMethod.invoke((Object)labelProvider, setupTask).toString();
        }
        catch (Exception exception) {
            type = setupTask.eClass().getName();
        }
        String label = labelProvider.getText((Object)setupTask);
        if (!label.startsWith(type)) {
            label = String.valueOf(type) + " " + label;
        }
        if ((eol = Math.min(label.indexOf(13), label.indexOf(10))) != -1) {
            label = String.valueOf(label.substring(0, eol)) + "...";
        }
        return label.startsWith(type) ? label : String.valueOf(type) + " " + label;
    }

    public static void setCreationMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            CREATION_MONITOR.remove();
        } else {
            CREATION_MONITOR.set(monitor);
        }
    }

    private static void checkCancel() {
        SetupCorePlugin.checkCancelation((IProgressMonitor)CREATION_MONITOR.get());
    }

    public static SetupTaskPerformer createForIDE(ResourceSet resourceSet, SetupPrompter prompter, Trigger trigger) throws Exception {
        return SetupTaskPerformer.create(resourceSet.getURIConverter(), prompter, trigger, SetupContext.create(resourceSet), false);
    }

    public static SetupTaskPerformer create(URIConverter uriConverter, final SetupPrompter prompter, Trigger trigger, SetupContext setupContext, boolean fullPrompt) throws Exception {
        File configurationLocation;
        Object streams;
        ArrayList<SetupTaskPerformer> performers = new ArrayList<SetupTaskPerformer>();
        boolean needsPrompt = false;
        HashMap composedMap = new HashMap();
        ArrayList<VariableTask> allAppliedRuleVariables = new ArrayList<VariableTask>();
        ArrayList<VariableTask> allUnresolvedVariables = new ArrayList<VariableTask>();
        ArrayList<VariableTask> allPasswordVariables = new ArrayList<VariableTask>();
        LinkedHashMap<VariableTask, EAttribute> allRuleAttributes = new LinkedHashMap<VariableTask, EAttribute>();
        Workspace workspace = setupContext.getWorkspace();
        Object object = streams = workspace == null ? null : workspace.getStreams();
        if (streams == null || streams.isEmpty()) {
            streams = Collections.singletonList(null);
        }
        Iterator iterator = streams.iterator();
        while (iterator.hasNext()) {
            Stream stream = (Stream)iterator.next();
            SetupTaskPerformer.checkCancel();
            if (stream != null && stream.eIsProxy()) continue;
            SetupTaskPerformer performer = new SetupTaskPerformer(uriConverter, prompter, null, setupContext, stream);
            Set<String> undeclaredVariables = performer.getUndeclaredVariables();
            final LinkedHashSet<VariableTask> demandCreatedUnresolvedVariables = new LinkedHashSet<VariableTask>();
            if (!undeclaredVariables.isEmpty()) {
                List<VariableTask> unresolvedVariables = performer.getUnresolvedVariables();
                Iterator<Object> iterator2 = undeclaredVariables.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    VariableTask variable = SetupFactory.eINSTANCE.createVariableTask();
                    variable.setName(string);
                    variable.setLabel(String.valueOf(string) + " (undeclared)");
                    variable.setStorageURI(null);
                    variable.getAnnotations().add((Object)BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/UndeclaredVariable"));
                    unresolvedVariables.add(variable);
                    demandCreatedUnresolvedVariables.add(variable);
                }
                undeclaredVariables.clear();
            }
            CollectionUtil.putAll(composedMap, performer.getMap());
            if (fullPrompt) {
                SetupContext fullPromptContext = SetupContext.createCopy(setupContext.getInstallation(), setupContext.getWorkspace(), setupContext.getUser());
                LinkedHashSet<VariableTask> linkedHashSet = new LinkedHashSet<VariableTask>();
                final SetupTaskPerformer partialPromptPerformer = performer;
                SetupTaskPerformer.prepareFullPrompt(linkedHashSet, (ModelElement)fullPromptContext.getInstallation());
                SetupTaskPerformer.prepareFullPrompt(linkedHashSet, (ModelElement)fullPromptContext.getWorkspace());
                User user = fullPromptContext.getUser();
                SetupTaskPerformer.prepareFullPrompt(linkedHashSet, (ModelElement)user);
                user.getAttributeRules().clear();
                SetupPrompter fullPrompter = new SetupPrompter(){
                    private boolean first = true;

                    public OS getOS() {
                        return prompter.getOS();
                    }

                    public String getVMPath() {
                        return prompter.getVMPath();
                    }

                    public UserCallback getUserCallback() {
                        return prompter.getUserCallback();
                    }

                    public String getValue(VariableTask variable) {
                        if (!this.first) {
                            return prompter.getValue(variable);
                        }
                        return null;
                    }

                    public boolean promptVariables(List<? extends SetupTaskContext> performers) {
                        for (SetupTaskContext setupTaskContext : performers) {
                            SetupTaskPerformer promptedPerformer = (SetupTaskPerformer)setupTaskContext;
                            Map<VariableTask, EAttribute> ruleAttributes = promptedPerformer.getRuleAttributes();
                            for (VariableTask variable : promptedPerformer.getUnresolvedVariables()) {
                                EAttribute eAttribute = ruleAttributes.get(variable);
                                if (ruleAttributes.keySet().contains(variable)) {
                                    AttributeRule attributeRule = partialPromptPerformer.getAttributeRule(eAttribute, false);
                                    if (attributeRule == null) continue;
                                    String value = prompter.getValue(variable);
                                    variable.setValue(value == null ? attributeRule.getValue() : value);
                                    continue;
                                }
                                Object value = partialPromptPerformer.get(variable.getName());
                                if (!(value instanceof String)) continue;
                                variable.setValue(value.toString());
                            }
                            promptedPerformer.getUnresolvedVariables().addAll(demandCreatedUnresolvedVariables);
                        }
                        this.first = false;
                        return true;
                    }
                };
                SetupTaskPerformer fullPromptPerformer = new SetupTaskPerformer(uriConverter, fullPrompter, null, fullPromptContext, stream);
                fullPrompter.promptVariables(Collections.singletonList(fullPromptPerformer));
                CollectionUtil.putAll(composedMap, performer.getMap());
                performer = fullPromptPerformer;
            }
            allAppliedRuleVariables.addAll(performer.getAppliedRuleVariables());
            allUnresolvedVariables.addAll(performer.getUnresolvedVariables());
            allPasswordVariables.addAll(performer.getPasswordVariables());
            allRuleAttributes.putAll(performer.getRuleAttributes());
            performers.add(performer);
            if (performer.getUnresolvedVariables().isEmpty()) continue;
            needsPrompt = true;
        }
        if (needsPrompt) {
            if (!prompter.promptVariables(performers)) {
                return null;
            }
            for (SetupTaskPerformer setupTaskPerformer : performers) {
                setupTaskPerformer.resolveSettings();
            }
        }
        BasicEList setupTasks = new BasicEList();
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        for (SetupTaskPerformer performer : performers) {
            setupTasks.addAll(performer.getTriggeredSetupTasks());
            bundles.addAll(performer.getBundles());
        }
        SetupTaskPerformer composedPerformer = new SetupTaskPerformer(uriConverter, prompter, trigger, setupContext, (EList<SetupTask>)setupTasks);
        composedPerformer.getBundles().addAll(bundles);
        composedPerformer.getAppliedRuleVariables().addAll(allAppliedRuleVariables);
        composedPerformer.getUnresolvedVariables().addAll(allUnresolvedVariables);
        composedPerformer.getPasswordVariables().addAll(allPasswordVariables);
        composedPerformer.getRuleAttributes().putAll(allRuleAttributes);
        composedPerformer.redirectTriggeredSetupTasks();
        File workspaceLocation = composedPerformer.getWorkspaceLocation();
        if (workspaceLocation != null) {
            File workspaceSetupLocation = new File(workspaceLocation, ".metadata/.plugins/org.eclipse.oomph.setup/workspace.setup");
            URI workspaceURI = URI.createFileURI((String)workspaceSetupLocation.toString());
            for (SetupTaskPerformer setupTaskPerformer : performers) {
                setupTaskPerformer.getWorkspace().eResource().setURI(workspaceURI);
            }
        }
        if ((configurationLocation = composedPerformer.getProductConfigurationLocation()) != null) {
            File installationLocation = new File(configurationLocation, "org.eclipse.oomph.setup/installation.setup");
            URI uRI = URI.createFileURI((String)installationLocation.toString());
            for (SetupTaskPerformer performer : performers) {
                performer.getInstallation().eResource().setURI(uRI);
            }
        }
        Map<Object, Object> finalComposedMap = composedPerformer.getMap();
        for (Map.Entry entry : composedMap.entrySet()) {
            Object key = entry.getKey();
            if (finalComposedMap.containsKey(key)) continue;
            Set value = (Set)entry.getValue();
            value.remove(null);
            value.remove("");
            if (value.size() != 1) continue;
            finalComposedMap.put(key, value.iterator().next());
        }
        return composedPerformer;
    }

    public static Set<? extends Authenticator> getAuthenticators(VariableTask variable) {
        VariableAdapter variableAdapter = (VariableAdapter)EcoreUtil.getExistingAdapter((Notifier)variable, VariableAdapter.class);
        if (variableAdapter != null) {
            return variableAdapter.getAuthenticators(variable);
        }
        return null;
    }

    private static boolean isFullPromptUser(User user) {
        return EcoreUtil.getExistingAdapter((Notifier)user, FullPromptMarker.class) != null;
    }

    private static void prepareFullPrompt(Set<VariableTask> variables, ModelElement modelElement) {
        if (modelElement != null) {
            TreeIterator it = modelElement.eAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof VariableTask)) continue;
                VariableTask variableTask = (VariableTask)eObject;
                variables.add(variableTask);
                variableTask.setValue(null);
            }
            SetupTaskPerformer.setFullPromptMarker(modelElement);
        }
    }

    private static void setFullPromptMarker(ModelElement modelElement) {
        modelElement.eAdapters().add((Object)new FullPromptMarker());
    }

    public void setProgress(ProgressLog progress) {
        this.progress = progress;
    }

    public static boolean disableAutoBuilding() throws CoreException {
        return SetupContext.USE_RESOURCES_BUNDLE && WorkspaceUtil.disableAutoBuilding();
    }

    public static void restoreAutoBuilding(boolean autoBuilding) throws CoreException {
        if (SetupContext.USE_RESOURCES_BUNDLE) {
            WorkspaceUtil.restoreAutoBuilding(autoBuilding);
        }
    }

    public static EList<SetupTask> createEnablementTasks(EModelElement eModelElement, boolean withVariables) {
        BasicEList containerEnablementTasks;
        BasicEList enablementTasks = null;
        for (EAnnotation eAnnotation : eModelElement.getEAnnotations()) {
            String variableName;
            String repositoryLocation;
            String source = eAnnotation.getSource();
            if (!"http://www.eclipse.org/oomph/setup/Enablement".equals(source)) continue;
            if (enablementTasks == null) {
                enablementTasks = new BasicEList();
            }
            if (!StringUtil.isEmpty((String)(repositoryLocation = (String)eAnnotation.getDetails().get((Object)"repository"))) && withVariables && !StringUtil.isEmpty((String)(variableName = (String)eAnnotation.getDetails().get((Object)"variableName")))) {
                VariableTask variable = SetupFactory.eINSTANCE.createVariableTask();
                variable.setName(variableName);
                variable.setValue(repositoryLocation);
                enablementTasks.add(0, (Object)variable);
                repositoryLocation = SetupTaskPerformer.getVariableReference(variableName, null);
            }
            P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
            EList requirements = p2Task.getRequirements();
            String ius = (String)eAnnotation.getDetails().get((Object)"installableUnits");
            if (!StringUtil.isEmpty((String)ius)) {
                String[] stringArray = ius.split("\\s");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String requirementSpecification = stringArray[n2];
                    Matcher matcher = INSTALLABLE_UNIT_WITH_RANGE_PATTERN.matcher(requirementSpecification);
                    if (matcher.matches()) {
                        Requirement requirement = P2Factory.eINSTANCE.createRequirement(matcher.group(1));
                        String versionRange = matcher.group(2);
                        if (!StringUtil.isEmpty((String)versionRange)) {
                            requirement.setVersionRange(new VersionRange(versionRange));
                        }
                        requirements.add((Object)requirement);
                    }
                    ++n2;
                }
            }
            if (!StringUtil.isEmpty((String)repositoryLocation)) {
                Repository repository = P2Factory.eINSTANCE.createRepository(repositoryLocation);
                p2Task.getRepositories().add((Object)repository);
            }
            enablementTasks.add(0, (Object)p2Task);
        }
        EObject eContainer = eModelElement.eContainer();
        if (eContainer instanceof EModelElement && (containerEnablementTasks = SetupTaskPerformer.createEnablementTasks((EModelElement)eContainer, withVariables)) != null) {
            if (enablementTasks == null) {
                enablementTasks = containerEnablementTasks;
            } else {
                enablementTasks.addAll((Collection)containerEnablementTasks);
            }
        }
        return enablementTasks;
    }

    private static String getVariableReference(String variableName, EAnnotation variableAnnotation) {
        String filter;
        if (variableAnnotation != null && (filter = (String)variableAnnotation.getDetails().get((Object)"filter")) != null) {
            return "${" + variableName + "|" + filter + "}";
        }
        return "${" + variableName + "}";
    }

    public static final class ExecutableInfo {
        private final File eclipseLocation;
        private final File executable;
        private final boolean needsConsole;
        private final OS os;

        private ExecutableInfo(SetupTaskPerformer performer) {
            String consoleExecutableName;
            File consoleExectuable;
            this.os = performer.getOS();
            String relativeProductFolder = performer.getRelativeProductFolder();
            String relativeExecutableFolder = this.os.getRelativeExecutableFolder();
            String executableName = this.os.getExecutableName(performer.getLauncherName());
            File eclipseLocation = new File(performer.getInstallationLocation(), relativeProductFolder);
            File executableFolder = new File(eclipseLocation, relativeExecutableFolder);
            File executable = new File(executableFolder, executableName);
            this.needsConsole = ExecutableInfo.computeNeedsConsole(performer);
            if (this.needsConsole && this.os.isWin() && (consoleExectuable = new File(executableFolder, consoleExecutableName = String.valueOf(executableName.substring(0, executableName.length() - ".exe".length())) + "c.exe")).isFile()) {
                executable = consoleExectuable;
            }
            this.eclipseLocation = eclipseLocation;
            this.executable = executable;
        }

        public File getEclipseLocation() {
            return this.eclipseLocation;
        }

        public File getExecutable() {
            return this.executable;
        }

        public File getLaunchLocation() {
            return this.os.isMac() ? this.executable.getParentFile().getParentFile().getParentFile() : this.executable;
        }

        public boolean needsConsole() {
            return this.needsConsole;
        }

        private static boolean computeNeedsConsole(SetupTaskPerformer performer) {
            for (SetupTask task : performer.getTriggeredSetupTasks()) {
                EclipseIniTask iniTask;
                if (!(task instanceof EclipseIniTask) || (iniTask = (EclipseIniTask)task).isVm() || !"-console".equals(iniTask.getOption())) continue;
                return true;
            }
            return false;
        }
    }

    private static class FullPromptMarker
    extends AdapterImpl {
        private FullPromptMarker() {
        }

        public boolean isAdapterForType(Object type) {
            return type == FullPromptMarker.class;
        }
    }

    private static class PDEAPIUtil {
        private static final Field BUILD_DISABLED_FIELD;

        static {
            Field buildDisabledField = null;
            try {
                Class apiAnalysisBuilder = CommonPlugin.loadClass((String)"org.eclipse.pde.api.tools", (String)"org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder");
                buildDisabledField = apiAnalysisBuilder.getDeclaredField("buildDisabled");
                buildDisabledField.setAccessible(true);
            }
            catch (Exception exception) {}
            BUILD_DISABLED_FIELD = buildDisabledField;
        }

        private PDEAPIUtil() {
        }

        private static boolean setDisableAPIAnalysisBuilder(boolean disabled) {
            if (BUILD_DISABLED_FIELD != null) {
                try {
                    boolean result = (Boolean)BUILD_DISABLED_FIELD.get(null);
                    if (result != disabled) {
                        BUILD_DISABLED_FIELD.set(null, disabled);
                    }
                    return result;
                }
                catch (Exception exception) {}
            }
            return true;
        }
    }

    protected static class URIValueConverter
    extends ValueConverter {
        protected URIValueConverter() {
        }

        public Object createFromString(String literal) {
            return BaseFactory.eINSTANCE.createURI(literal);
        }
    }

    protected static class ValueConverter {
        protected ValueConverter() {
        }

        public Object createFromString(String literal) {
            return literal;
        }

        public String convertToString(Object value) {
            return value == null ? null : value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VariableAdapter
    extends AdapterImpl {
        private SetupTaskPerformer performer;

        public VariableAdapter(SetupTaskPerformer perform) {
            this.performer = perform;
        }

        public boolean isAdapterForType(Object type) {
            return type == VariableAdapter.class;
        }

        protected Set<? extends Authenticator> getAuthenticators(VariableTask variable) {
            StringExpander stringExpander = new StringExpander(){

                protected String resolve(String key) {
                    String value = this.getValue(key);
                    return StringUtil.isEmpty((String)value) ? VariableAdapter.this.performer.resolve(key) : value;
                }

                protected boolean isUnexpanded(String key) {
                    return VariableAdapter.this.performer.isUnexpanded(key) && StringUtil.isEmpty((String)this.getValue(key));
                }

                private String getValue(String key) {
                    VariableTask variable = (VariableTask)VariableAdapter.this.performer.allVariables.get(key);
                    if (variable != null) {
                        return VariableAdapter.this.performer.getPrompter().getValue(variable);
                    }
                    return null;
                }

                protected String filter(String value, String filterName) {
                    return VariableAdapter.this.performer.filter(value, filterName);
                }
            };
            return Authenticator.create(variable, stringExpander);
        }
    }

    private static class WorkspaceUtil {
        private WorkspaceUtil() {
        }

        private static boolean disableAutoBuilding() throws CoreException {
            boolean autoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (autoBuilding) {
                WorkspaceUtil.restoreAutoBuilding(false);
            }
            return autoBuilding;
        }

        private static void restoreAutoBuilding(boolean autoBuilding) throws CoreException {
            if (autoBuilding != ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
                description.setAutoBuilding(autoBuilding);
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
        }

        private static void performNeededSetupTasks(SetupTaskPerformer performer, IProgressMonitor monitor) throws Exception {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        SetupTaskPerformer.this.doPerformNeededSetupTasks(monitor);
                    }
                    catch (Throwable t) {
                        SetupCorePlugin.INSTANCE.coreException(t);
                    }
                }
            }, null, 1, monitor);
        }
    }
}

