/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.targlets.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.targlets.ImplicitDependency;
import org.eclipse.oomph.setup.targlets.SetupTargletsFactory;
import org.eclipse.oomph.setup.targlets.SetupTargletsPackage;
import org.eclipse.oomph.setup.targlets.TargletTask;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.internal.core.TargletContainer;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.WorkspaceIUImporter;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.pde.TargetPlatformRunnable;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargletTaskImpl
extends SetupTaskImpl
implements TargletTask {
    private static final String TARGET_DEFINITION_NAME = "Modular Target";
    private static final String TARGLET_CONTAINER_ID = "Oomph";
    protected EList<Targlet> targlets;
    protected EList<String> targletURIs;
    protected static final String OPERATING_SYSTEM_EDEFAULT = null;
    protected String operatingSystem = OPERATING_SYSTEM_EDEFAULT;
    protected static final String WINDOWING_SYSTEM_EDEFAULT = null;
    protected String windowingSystem = WINDOWING_SYSTEM_EDEFAULT;
    protected static final String ARCHITECTURE_EDEFAULT = null;
    protected String architecture = ARCHITECTURE_EDEFAULT;
    protected static final String LOCALE_EDEFAULT = null;
    protected String locale = LOCALE_EDEFAULT;
    protected static final String PROGRAM_ARGUMENTS_EDEFAULT = null;
    protected String programArguments = PROGRAM_ARGUMENTS_EDEFAULT;
    protected static final String VM_ARGUMENTS_EDEFAULT = null;
    protected String vMArguments = VM_ARGUMENTS_EDEFAULT;
    protected EList<ImplicitDependency> implicitDependencies;
    private ITargletContainer targletContainer;
    private ITargetDefinition targetDefinition;
    private EList<Targlet> copyTarglets;

    protected TargletTaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupTargletsPackage.Literals.TARGLET_TASK;
    }

    @Override
    public EList<Targlet> getTarglets() {
        if (this.targlets == null) {
            this.targlets = new EObjectContainmentEList(Targlet.class, (InternalEObject)this, 9);
        }
        return this.targlets;
    }

    @Override
    public EList<String> getTargletURIs() {
        if (this.targletURIs == null) {
            this.targletURIs = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 10);
        }
        return this.targletURIs;
    }

    @Override
    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public void setOperatingSystem(String newOperatingSystem) {
        String oldOperatingSystem = this.operatingSystem;
        this.operatingSystem = newOperatingSystem;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldOperatingSystem, (Object)this.operatingSystem));
        }
    }

    @Override
    public String getWindowingSystem() {
        return this.windowingSystem;
    }

    @Override
    public void setWindowingSystem(String newWindowingSystem) {
        String oldWindowingSystem = this.windowingSystem;
        this.windowingSystem = newWindowingSystem;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldWindowingSystem, (Object)this.windowingSystem));
        }
    }

    @Override
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public void setArchitecture(String newArchitecture) {
        String oldArchitecture = this.architecture;
        this.architecture = newArchitecture;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldArchitecture, (Object)this.architecture));
        }
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String newLocale) {
        String oldLocale = this.locale;
        this.locale = newLocale;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldLocale, (Object)this.locale));
        }
    }

    @Override
    public String getProgramArguments() {
        return this.programArguments;
    }

    @Override
    public void setProgramArguments(String newProgramArguments) {
        String oldProgramArguments = this.programArguments;
        this.programArguments = newProgramArguments;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldProgramArguments, (Object)this.programArguments));
        }
    }

    @Override
    public String getVMArguments() {
        return this.vMArguments;
    }

    @Override
    public void setVMArguments(String newVMArguments) {
        String oldVMArguments = this.vMArguments;
        this.vMArguments = newVMArguments;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldVMArguments, (Object)this.vMArguments));
        }
    }

    @Override
    public EList<ImplicitDependency> getImplicitDependencies() {
        if (this.implicitDependencies == null) {
            this.implicitDependencies = new EObjectContainmentEList(ImplicitDependency.class, (InternalEObject)this, 17);
        }
        return this.implicitDependencies;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getTarglets()).basicRemove((Object)otherEnd, msgs);
            }
            case 17: {
                return ((InternalEList)this.getImplicitDependencies()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getTarglets();
            }
            case 10: {
                return this.getTargletURIs();
            }
            case 11: {
                return this.getOperatingSystem();
            }
            case 12: {
                return this.getWindowingSystem();
            }
            case 13: {
                return this.getArchitecture();
            }
            case 14: {
                return this.getLocale();
            }
            case 15: {
                return this.getProgramArguments();
            }
            case 16: {
                return this.getVMArguments();
            }
            case 17: {
                return this.getImplicitDependencies();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.getTarglets().clear();
                this.getTarglets().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getTargletURIs().clear();
                this.getTargletURIs().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setOperatingSystem((String)newValue);
                return;
            }
            case 12: {
                this.setWindowingSystem((String)newValue);
                return;
            }
            case 13: {
                this.setArchitecture((String)newValue);
                return;
            }
            case 14: {
                this.setLocale((String)newValue);
                return;
            }
            case 15: {
                this.setProgramArguments((String)newValue);
                return;
            }
            case 16: {
                this.setVMArguments((String)newValue);
                return;
            }
            case 17: {
                this.getImplicitDependencies().clear();
                this.getImplicitDependencies().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.getTarglets().clear();
                return;
            }
            case 10: {
                this.getTargletURIs().clear();
                return;
            }
            case 11: {
                this.setOperatingSystem(OPERATING_SYSTEM_EDEFAULT);
                return;
            }
            case 12: {
                this.setWindowingSystem(WINDOWING_SYSTEM_EDEFAULT);
                return;
            }
            case 13: {
                this.setArchitecture(ARCHITECTURE_EDEFAULT);
                return;
            }
            case 14: {
                this.setLocale(LOCALE_EDEFAULT);
                return;
            }
            case 15: {
                this.setProgramArguments(PROGRAM_ARGUMENTS_EDEFAULT);
                return;
            }
            case 16: {
                this.setVMArguments(VM_ARGUMENTS_EDEFAULT);
                return;
            }
            case 17: {
                this.getImplicitDependencies().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.targlets != null && !this.targlets.isEmpty();
            }
            case 10: {
                return this.targletURIs != null && !this.targletURIs.isEmpty();
            }
            case 11: {
                return OPERATING_SYSTEM_EDEFAULT == null ? this.operatingSystem != null : !OPERATING_SYSTEM_EDEFAULT.equals(this.operatingSystem);
            }
            case 12: {
                return WINDOWING_SYSTEM_EDEFAULT == null ? this.windowingSystem != null : !WINDOWING_SYSTEM_EDEFAULT.equals(this.windowingSystem);
            }
            case 13: {
                return ARCHITECTURE_EDEFAULT == null ? this.architecture != null : !ARCHITECTURE_EDEFAULT.equals(this.architecture);
            }
            case 14: {
                return LOCALE_EDEFAULT == null ? this.locale != null : !LOCALE_EDEFAULT.equals(this.locale);
            }
            case 15: {
                return PROGRAM_ARGUMENTS_EDEFAULT == null ? this.programArguments != null : !PROGRAM_ARGUMENTS_EDEFAULT.equals(this.programArguments);
            }
            case 16: {
                return VM_ARGUMENTS_EDEFAULT == null ? this.vMArguments != null : !VM_ARGUMENTS_EDEFAULT.equals(this.vMArguments);
            }
            case 17: {
                return this.implicitDependencies != null && !this.implicitDependencies.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (targletURIs: ");
        result.append(this.targletURIs);
        result.append(", operatingSystem: ");
        result.append(this.operatingSystem);
        result.append(", windowingSystem: ");
        result.append(this.windowingSystem);
        result.append(", architecture: ");
        result.append(this.architecture);
        result.append(", locale: ");
        result.append(this.locale);
        result.append(", programArguments: ");
        result.append(this.programArguments);
        result.append(", vMArguments: ");
        result.append(this.vMArguments);
        result.append(')');
        return result.toString();
    }

    public Object getOverrideToken() {
        return this.createToken(TARGLET_CONTAINER_ID);
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        TargletTask targletTask = (TargletTask)overriddenSetupTask;
        this.getTarglets().addAll(targletTask.getTarglets());
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__OPERATING_SYSTEM, "operating systems");
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__WINDOWING_SYSTEM, "windowing systems");
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__ARCHITECTURE, "architectures");
        this.mergeSetting(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__LOCALE, "locales");
        this.mergeArguments(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__PROGRAM_ARGUMENTS);
        this.mergeArguments(targletTask, SetupTargletsPackage.Literals.TARGLET_TASK__VM_ARGUMENTS);
        this.getImplicitDependencies().addAll(targletTask.getImplicitDependencies());
    }

    private void mergeSetting(TargletTask overriddenTargletTask, EAttribute attribute, String errorLabel) {
        String overriddenValue;
        String overridingValue = (String)this.eGet((EStructuralFeature)attribute);
        if (!ObjectUtil.equals((Object)overridingValue, (Object)(overriddenValue = (String)overriddenTargletTask.eGet((EStructuralFeature)attribute)))) {
            if (overridingValue == null) {
                this.eSet((EStructuralFeature)attribute, overriddenValue);
            } else if (overriddenValue != null) {
                this.getAnnotations().add((Object)BaseFactory.eINSTANCE.createErrorAnnotation("The " + errorLabel + " '" + overriddenValue + "' and '" + overridingValue + "' collide."));
            }
        }
    }

    private void mergeArguments(TargletTask overriddenTargletTask, EAttribute attribute) {
        String overridingValue = this.sanitizeArguments((String)this.eGet((EStructuralFeature)attribute));
        String overriddenValue = this.sanitizeArguments((String)overriddenTargletTask.eGet((EStructuralFeature)attribute));
        if (overridingValue != null) {
            if (overriddenValue != null) {
                this.eSet((EStructuralFeature)attribute, String.valueOf(overriddenValue) + "\n" + overridingValue);
            } else {
                this.eSet((EStructuralFeature)attribute, overridingValue);
            }
        }
    }

    private String sanitizeArguments(String arguments) {
        if (StringUtil.isEmpty((String)arguments)) {
            return null;
        }
        arguments = arguments.trim();
        while (arguments.endsWith("\n") || arguments.endsWith("\r")) {
            arguments = arguments.substring(0, arguments.length() - 1).trim();
        }
        return arguments;
    }

    public void consolidate() {
        super.consolidate();
        HashSet<String> targletNames = new HashSet<String>();
        EList<Targlet> targlets = this.getTarglets();
        Iterator it = targlets.iterator();
        block0: while (it.hasNext()) {
            Targlet targlet = (Targlet)it.next();
            String name = targlet.getName();
            if (StringUtil.isEmpty((String)name) || !targletNames.add(name)) {
                it.remove();
                continue;
            }
            if (!targlet.getRequirements().isEmpty() || !targlet.getSourceLocators().isEmpty()) continue;
            String activeRepositoryList = targlet.getActiveRepositoryListName();
            for (RepositoryList repositoryList : targlet.getRepositoryLists()) {
                if (!ObjectUtil.equals((Object)activeRepositoryList, (Object)repositoryList.getName()) || !repositoryList.getRepositories().isEmpty()) continue;
                it.remove();
                continue block0;
            }
        }
        ECollections.sort(targlets, (Comparator)new Comparator<Targlet>(){

            @Override
            public int compare(Targlet o1, Targlet o2) {
                return StringUtil.safe((String)o1.getName()).compareTo(StringUtil.safe((String)o2.getName()));
            }
        });
        EList<ImplicitDependency> implicitDependencies = this.getImplicitDependencies();
        Set<NameVersionDescriptor> descriptors = TargletTaskImpl.createNameVersionDescriptors(implicitDependencies);
        implicitDependencies.clear();
        for (NameVersionDescriptor descriptor : descriptors) {
            String id = descriptor.getId();
            String version = descriptor.getVersion();
            ImplicitDependency implicitDependency = SetupTargletsFactory.eINSTANCE.createImplicitDependency(id, version);
            implicitDependencies.add((Object)implicitDependency);
        }
        ECollections.sort(implicitDependencies, (Comparator)new Comparator<ImplicitDependency>(){

            @Override
            public int compare(ImplicitDependency o1, ImplicitDependency o2) {
                int result = StringUtil.safe((String)o1.getID()).compareTo(StringUtil.safe((String)o2.getID()));
                if (result == 0) {
                    Version v2;
                    Version v1 = o1.getVersion();
                    if (v1 == null) {
                        v1 = Version.emptyVersion;
                    }
                    if ((v2 = o2.getVersion()) == null) {
                        v2 = Version.emptyVersion;
                    }
                    result = v1.compareTo((Object)v2);
                }
                return result;
            }
        });
    }

    public int getProgressMonitorWork() {
        return 100;
    }

    public boolean isNeeded(final SetupTaskContext context) throws Exception {
        this.copyTarglets = TargletFactory.eINSTANCE.copyTarglets(this.getTarglets());
        return (Boolean)TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Boolean>(){

            public Boolean run(ITargetPlatformService service) throws CoreException {
                ITargetHandle activeTargetHandle = service.getWorkspaceTargetHandle();
                TargletTaskImpl.this.targetDefinition = TargletTaskImpl.this.getTargetDefinition(service, context.getProgressMonitor(true));
                if (TargletTaskImpl.this.targetDefinition == null) {
                    return TargletTaskImpl.hasRequirements((EList<Targlet>)TargletTaskImpl.this.copyTarglets);
                }
                TargletTaskImpl.this.targletContainer = TargletTaskImpl.this.getTargletContainer();
                if (TargletTaskImpl.this.targletContainer == null) {
                    return TargletTaskImpl.hasRequirements((EList<Targlet>)TargletTaskImpl.this.copyTarglets);
                }
                if (!TargletTaskImpl.hasRequirements((EList<Targlet>)TargletTaskImpl.this.copyTarglets) && !TargletTaskImpl.hasRequirements((EList<Targlet>)TargletTaskImpl.this.targletContainer.getTarglets())) {
                    return false;
                }
                for (Targlet targlet : TargletTaskImpl.this.copyTarglets) {
                    Targlet existingTarglet = TargletTaskImpl.this.targletContainer.getTarglet(targlet.getName());
                    if (existingTarglet != null && EcoreUtil.equals((EObject)existingTarglet, (EObject)targlet)) continue;
                    return true;
                }
                if (context.getTrigger() == Trigger.MANUAL) {
                    return true;
                }
                if (!TargletTaskImpl.this.targetDefinition.getHandle().equals(activeTargetHandle)) {
                    return true;
                }
                if (!(ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getOS(), (Object)TargletTaskImpl.this.getOperatingSystem()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getWS(), (Object)TargletTaskImpl.this.getWindowingSystem()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getArch(), (Object)TargletTaskImpl.this.getArchitecture()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getNL(), (Object)TargletTaskImpl.this.getLocale()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getProgramArguments(), (Object)TargletTaskImpl.this.getProgramArguments()) && ObjectUtil.equals((Object)TargletTaskImpl.this.targetDefinition.getVMArguments(), (Object)TargletTaskImpl.this.getVMArguments()) && TargletTaskImpl.equalNameVersionDescriptors(TargletTaskImpl.this.targetDefinition.getImplicitDependencies(), (EList<ImplicitDependency>)TargletTaskImpl.this.getImplicitDependencies()))) {
                    return true;
                }
                return false;
            }
        });
    }

    public void perform(final SetupTaskContext context) throws Exception {
        for (Targlet targlet : this.copyTarglets) {
            for (Repository p2Repository : targlet.getActiveRepositories()) {
                context.log("Using " + p2Repository.getURL());
            }
        }
        boolean offline = context.isOffline();
        context.log("Offline = " + offline);
        boolean mirrors = context.isMirrors();
        context.log("Mirrors = " + mirrors);
        TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Object>(){

            public Object run(ITargetPlatformService service) throws CoreException {
                IProgressMonitor monitor = context.getProgressMonitor(true);
                monitor.beginTask("", 100 + (TargletTaskImpl.this.targetDefinition == null ? 1 : 0));
                try {
                    if (TargletTaskImpl.this.targetDefinition == null) {
                        TargletTaskImpl.this.targetDefinition = TargletTaskImpl.this.getTargetDefinition(service, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (TargletTaskImpl.this.targetDefinition == null) {
                        TargletTaskImpl.this.targetDefinition = service.newTarget();
                        TargletTaskImpl.this.targetDefinition.setName(TargletTaskImpl.TARGET_DEFINITION_NAME);
                    }
                    TargletTaskImpl.this.targetDefinition.setOS(TargletTaskImpl.this.getOperatingSystem());
                    TargletTaskImpl.this.targetDefinition.setWS(TargletTaskImpl.this.getWindowingSystem());
                    TargletTaskImpl.this.targetDefinition.setArch(TargletTaskImpl.this.getArchitecture());
                    TargletTaskImpl.this.targetDefinition.setNL(TargletTaskImpl.this.getLocale());
                    TargletTaskImpl.this.targetDefinition.setProgramArguments(TargletTaskImpl.this.getProgramArguments());
                    TargletTaskImpl.this.targetDefinition.setVMArguments(TargletTaskImpl.this.getVMArguments());
                    TargletTaskImpl.this.targetDefinition.setImplicitDependencies(TargletTaskImpl.this.getNameVersionDescriptors());
                    if (TargletTaskImpl.this.targletContainer == null) {
                        TargletTaskImpl.this.targletContainer = TargletTaskImpl.this.getTargletContainer();
                    }
                    EList targlets = TargletTaskImpl.this.copyTarglets;
                    if (TargletTaskImpl.this.targletContainer == null) {
                        ITargetLocation[] newLocations;
                        TargletTaskImpl.this.targletContainer = (ITargletContainer)new TargletContainer(TargletTaskImpl.TARGLET_CONTAINER_ID);
                        ITargetLocation[] oldLocations = TargletTaskImpl.this.targetDefinition.getTargetLocations();
                        if (oldLocations != null && oldLocations.length != 0) {
                            newLocations = new ITargetLocation[oldLocations.length + 1];
                            System.arraycopy(oldLocations, 0, newLocations, 0, oldLocations.length);
                            newLocations[oldLocations.length] = TargletTaskImpl.this.targletContainer;
                        } else {
                            newLocations = new ITargetLocation[]{TargletTaskImpl.this.targletContainer};
                        }
                        TargletTaskImpl.this.targetDefinition.setTargetLocations(newLocations);
                    }
                    boolean mirrors = context.isMirrors();
                    CacheUsageConfirmer cacheUsageConfirmer = (CacheUsageConfirmer)context.get(CacheUsageConfirmer.class);
                    CacheUsageConfirmer oldCacheUsageConfirmer = TargletsCorePlugin.INSTANCE.getCacheUsageConfirmer();
                    try {
                        TargletsCorePlugin.INSTANCE.setCacheUsageConfirmer(cacheUsageConfirmer);
                        TargletTaskImpl.this.targletContainer.setTarglets((Collection)targlets);
                        TargletTaskImpl.this.targletContainer.forceUpdate(true, mirrors, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                        try {
                            Job.getJobManager().join(WorkspaceIUImporter.WORKSPACE_IU_IMPORT_FAMILY, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                        catch (InterruptedException ex) {
                            TargletsCorePlugin.INSTANCE.coreException((Throwable)ex);
                        }
                    }
                    finally {
                        TargletsCorePlugin.INSTANCE.setCacheUsageConfirmer(oldCacheUsageConfirmer);
                    }
                    return null;
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private ITargetDefinition getTargetDefinition(ITargetPlatformService service, IProgressMonitor monitor) throws CoreException {
        ITargetHandle[] iTargetHandleArray = service.getTargets(monitor);
        int n = iTargetHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetHandle targetHandle = iTargetHandleArray[n2];
            ITargetDefinition targetDefinition = targetHandle.getTargetDefinition();
            if (TARGET_DEFINITION_NAME.equals(targetDefinition.getName())) {
                return targetDefinition;
            }
            ++n2;
        }
        return null;
    }

    private ITargletContainer getTargletContainer() {
        ITargetLocation[] locations = this.targetDefinition.getTargetLocations();
        if (locations != null) {
            ITargetLocation[] iTargetLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargletContainer targletContainer;
                ITargetLocation location = iTargetLocationArray[n2];
                if (location instanceof ITargletContainer && TARGLET_CONTAINER_ID.equals((targletContainer = (ITargletContainer)location).getID())) {
                    return targletContainer;
                }
                ++n2;
            }
        }
        return null;
    }

    private NameVersionDescriptor[] getNameVersionDescriptors() {
        EList<ImplicitDependency> implicitDependencies = this.getImplicitDependencies();
        if (implicitDependencies.isEmpty()) {
            return null;
        }
        Set<NameVersionDescriptor> descriptors = TargletTaskImpl.createNameVersionDescriptors(implicitDependencies);
        return descriptors.toArray(new NameVersionDescriptor[descriptors.size()]);
    }

    private static Set<NameVersionDescriptor> createNameVersionDescriptors(Collection<ImplicitDependency> implicitDependencies) {
        LinkedHashSet<NameVersionDescriptor> result = new LinkedHashSet<NameVersionDescriptor>();
        for (ImplicitDependency implicitDependency : implicitDependencies) {
            String id = implicitDependency.getID();
            if (StringUtil.isEmpty((String)id)) continue;
            Version version = implicitDependency.getVersion();
            result.add(new NameVersionDescriptor(id, version == null ? null : version.toString()));
        }
        return result;
    }

    private static boolean equalNameVersionDescriptors(NameVersionDescriptor[] targetImplicitDependencies, EList<ImplicitDependency> targletImplicitDependencies) {
        HashSet<NameVersionDescriptor> targetSet = new HashSet<NameVersionDescriptor>();
        if (targetImplicitDependencies != null) {
            int i = 0;
            while (i < targetImplicitDependencies.length) {
                targetSet.add(targetImplicitDependencies[i]);
                ++i;
            }
        }
        Set<NameVersionDescriptor> targletSet = TargletTaskImpl.createNameVersionDescriptors(targletImplicitDependencies);
        return targetSet.equals(targletSet);
    }

    private static boolean hasRequirements(EList<Targlet> targlets) {
        for (Targlet targlet : targlets) {
            if (targlet.getRequirements().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

