/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.manifests;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.oomph.manifests.AbstractProjectHandler;
import org.eclipse.oomph.manifests.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class OpenManifestHandler
extends AbstractProjectHandler {
    private static final ProjectType[] PROJECT_TYPES = new ProjectType[]{new ProjectType("org.eclipse.pde.PluginNature", "org.eclipse.pde.ui.manifestEditor", "META-INF/MANIFEST.MF"), new ProjectType("org.eclipse.pde.FeatureNature", "org.eclipse.pde.ui.featureEditor", "feature.xml"), new ProjectType("org.eclipse.pde.UpdateSiteNature", "org.eclipse.pde.ui.siteEditor", "site.xml")};

    protected void execute(IWorkbenchPage page, IProject project) {
        ProjectType projectType = this.getProjectType(project);
        if (projectType == null) {
            return;
        }
        IFile manifest = project.getFile((IPath)new Path(projectType.getManifestPath()));
        if (manifest.exists()) {
            try {
                FileEditorInput input = new FileEditorInput(manifest);
                page.openEditor((IEditorInput)input, projectType.getEditorID(), true);
            }
            catch (PartInitException ex) {
                Activator.getDefault().getLog().log(ex.getStatus());
            }
        }
    }

    private ProjectType getProjectType(IProject project) {
        ProjectType[] projectTypeArray = PROJECT_TYPES;
        int n = PROJECT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectType projectType = projectTypeArray[n2];
            try {
                if (project.hasNature(projectType.getNatureID())) {
                    return projectType;
                }
            }
            catch (CoreException ex) {
                Activator.getDefault().getLog().log(ex.getStatus());
            }
            ++n2;
        }
        return null;
    }

    private static final class ProjectType {
        private String natureID;
        private String editorID;
        private String manifestPath;

        public ProjectType(String natureID, String editorID, String manifestPath) {
            this.natureID = natureID;
            this.editorID = editorID;
            this.manifestPath = manifestPath;
        }

        public String getNatureID() {
            return this.natureID;
        }

        public String getEditorID() {
            return this.editorID;
        }

        public String getManifestPath() {
            return this.manifestPath;
        }
    }
}

