/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupUtil;
import org.eclipse.oomph.setup.ui.SetupEditorSupport;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RecorderTransaction {
    private static final String POLICIES_FILE_NAME = "policies.properties";
    private static final String POLICY_RECORD = "record";
    private static final String POLICY_IGNORE = "ignore";
    private static final String REMOVE_PREFERENCE_MARKER = "REMOVE_PREFERENCE_MARKER";
    private static RecorderTransaction instance;
    private static boolean policiesInitialized;
    private final Resource resource;
    private final Map<String, Boolean> cleanPolicies = new HashMap<String, Boolean>();
    private final Map<String, Boolean> policies = new HashMap<String, Boolean>();
    private final Set<URI> preferencesToRemove = new HashSet<URI>();
    private Map<URI, String> preferences;
    private CompoundTask preferenceCompound;
    private Annotation recorderAnnotation;
    private SetupTaskContainer rootObject;
    private boolean forceDirty;

    RecorderTransaction(Resource resource) {
        this.resource = resource;
        this.rootObject = (SetupTaskContainer)resource.getContents().get(0);
        this.findRecorderAnnotation(this.rootObject);
        if (this.recorderAnnotation != null) {
            EMap details = this.recorderAnnotation.getDetails();
            for (Map.Entry entry : details) {
                String value = (String)entry.getValue();
                if (POLICY_RECORD.equals(value)) {
                    this.cleanPolicies.put((String)entry.getKey(), true);
                    continue;
                }
                if (!POLICY_IGNORE.equals(value)) continue;
                this.cleanPolicies.put((String)entry.getKey(), false);
            }
        }
    }

    public void close() {
        instance = null;
    }

    public Resource getResource() {
        return this.resource;
    }

    public SetupTaskContainer getRootObject() {
        return this.rootObject;
    }

    public boolean isDirty() {
        if (this.forceDirty) {
            return true;
        }
        if (!this.policies.isEmpty()) {
            return true;
        }
        return this.preferences != null && !this.preferences.isEmpty();
    }

    public boolean isForceDirty() {
        return this.forceDirty;
    }

    public void setForceDirty(boolean forceDirty) {
        this.forceDirty = forceDirty;
    }

    public Map<String, Boolean> getPolicies(boolean clean) {
        if (clean) {
            return this.cleanPolicies;
        }
        return this.policies;
    }

    public void resetPolicies() {
        this.policies.clear();
    }

    public Boolean getPolicy(String key) {
        Boolean policy = this.policies.get(key);
        if (policy != null) {
            return policy;
        }
        return this.cleanPolicies.get(key);
    }

    public void setPolicy(String key, boolean policy) {
        Boolean cleanPolicy = this.cleanPolicies.get(key);
        if (cleanPolicy != null && cleanPolicy.equals(policy)) {
            this.policies.remove(key);
        } else {
            this.policies.put(key, policy);
        }
    }

    public void setPreferences(Map<URI, String> preferences) {
        this.preferences = preferences;
    }

    public void removePreferences(Collection<URI> keys) {
        this.preferencesToRemove.addAll(keys);
    }

    public void commit() {
        if (this.isDirty()) {
            this.doCommit();
        }
    }

    protected abstract void doCommit();

    protected final List<? extends Object> applyChanges() {
        if (this.recorderAnnotation == null) {
            this.preferenceCompound = SetupFactory.eINSTANCE.createCompoundTask("User Preferences");
            this.rootObject.getSetupTasks().add(0, (Object)this.preferenceCompound);
            this.recorderAnnotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/UserPreferences");
            this.preferenceCompound.getAnnotations().add((Object)this.recorderAnnotation);
            this.migrateOldTasks();
        }
        ArrayList<Object> recorderObjects = new ArrayList<Object>();
        if (!this.policies.isEmpty()) {
            recorderObjects.add(this.recorderAnnotation);
            EMap eMap = this.recorderAnnotation.getDetails();
            Map workspacePolicies = null;
            boolean workspacePoliciesChanged = false;
            IFile workspacePoliciesFile = RecorderTransaction.getWorkspacePropertiesFile();
            for (Map.Entry<String, Boolean> entry : this.policies.entrySet()) {
                String path = entry.getKey();
                boolean policy = entry.getValue();
                eMap.put((Object)path, (Object)(policy ? POLICY_RECORD : POLICY_IGNORE));
                this.cleanPolicies.put(path, policy);
                if (policy) continue;
                URI key = PreferencesFactory.eINSTANCE.createURI(path);
                this.preferencesToRemove.add(key);
                if (workspacePoliciesFile == null) continue;
                if (workspacePolicies == null && workspacePoliciesFile.isAccessible()) {
                    workspacePolicies = PropertiesUtil.loadProperties((File)workspacePoliciesFile.getLocation().toFile());
                }
                if (workspacePolicies == null || POLICY_IGNORE.equals(workspacePolicies.get(path))) continue;
                workspacePolicies.put(path, POLICY_IGNORE);
                workspacePoliciesChanged = true;
            }
            if (workspacePoliciesChanged) {
                try {
                    PropertiesUtil.saveProperties((File)workspacePoliciesFile.getLocation().toFile(), workspacePolicies, (boolean)true);
                    workspacePoliciesFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                }
            }
            this.policies.clear();
        }
        if (!this.preferencesToRemove.isEmpty()) {
            if (this.preferences == null) {
                this.preferences = new HashMap<URI, String>();
            }
            for (URI uRI : this.preferencesToRemove) {
                this.preferences.put(uRI, REMOVE_PREFERENCE_MARKER);
            }
        }
        if (this.preferences != null) {
            for (Map.Entry entry : this.preferences.entrySet()) {
                PreferenceTask preferenceTask;
                URI key = (URI)entry.getKey();
                String value = (String)entry.getValue();
                String pluginID = key.segment(0).toString();
                String path = PreferencesFactory.eINSTANCE.convertURI(key);
                boolean remove = value == REMOVE_PREFERENCE_MARKER;
                CompoundTask pluginCompound = (CompoundTask)RecorderTransaction.getPreferenceTask((EList<SetupTask>)this.preferenceCompound.getSetupTasks(), SetupPackage.Literals.COMPOUND_TASK__NAME, pluginID, !remove);
                if (pluginCompound == null || (preferenceTask = (PreferenceTask)RecorderTransaction.getPreferenceTask((EList<SetupTask>)pluginCompound.getSetupTasks(), SetupPackage.Literals.PREFERENCE_TASK__KEY, path, !remove)) == null) continue;
                if (remove) {
                    EcoreUtil.remove((EObject)preferenceTask);
                    if (pluginCompound.getSetupTasks().isEmpty()) {
                        recorderObjects.add(pluginCompound.eContainer());
                        EcoreUtil.remove((EObject)pluginCompound);
                        continue;
                    }
                    recorderObjects.add(pluginCompound);
                    continue;
                }
                preferenceTask.setValue(org.eclipse.oomph.setup.util.SetupUtil.escape((String)value));
                recorderObjects.add(preferenceTask);
            }
            this.preferences = null;
        }
        this.preferencesToRemove.clear();
        return recorderObjects;
    }

    protected void initializePolicies() {
        if (!policiesInitialized) {
            OomphPlugin.BundleFile policiesFile = SetupUIPlugin.INSTANCE.getRootFile().getChild(POLICIES_FILE_NAME);
            if (policiesFile != null) {
                String contents = policiesFile.getContentsString();
                String[] lines = contents.split("[\n\r]");
                int i = 0;
                while (i < lines.length) {
                    String key;
                    int pos;
                    String line = lines[i].trim();
                    if (line.length() != 0 && (pos = line.lastIndexOf(61)) != -1 && !this.cleanPolicies.containsKey(key = line.substring(0, pos).trim())) {
                        String value = line.substring(pos + 1).trim();
                        if (POLICY_RECORD.equals(value)) {
                            this.setPolicy(key, true);
                        } else if (POLICY_IGNORE.equals(value)) {
                            this.setPolicy(key, false);
                        }
                    }
                    ++i;
                }
                this.commit();
            }
            policiesInitialized = true;
        }
    }

    private void findRecorderAnnotation(SetupTaskContainer container) {
        if (container instanceof CompoundTask) {
            CompoundTask compound = (CompoundTask)container;
            this.recorderAnnotation = compound.getAnnotation("http://www.eclipse.org/oomph/setup/UserPreferences");
            if (this.recorderAnnotation != null) {
                this.preferenceCompound = compound;
                return;
            }
        }
        for (SetupTask setupTask : container.getSetupTasks()) {
            if (!(setupTask instanceof SetupTaskContainer)) continue;
            this.findRecorderAnnotation((SetupTaskContainer)setupTask);
            if (this.recorderAnnotation == null) continue;
            return;
        }
    }

    private void migrateOldTasks() {
        this.migrateOldTasksRecursively(this.rootObject);
        EList pluginCompounds = this.preferenceCompound.getSetupTasks();
        ECollections.sort((EList)pluginCompounds, (Comparator)new Comparator<SetupTask>(){

            @Override
            public int compare(SetupTask o1, SetupTask o2) {
                String n1 = StringUtil.safe((String)((CompoundTask)o1).getName()).toLowerCase();
                String n2 = StringUtil.safe((String)((CompoundTask)o2).getName()).toLowerCase();
                return n1.compareTo(n2);
            }
        });
        for (SetupTask pluginCompound : pluginCompounds) {
            EList preferenceTasks = ((CompoundTask)pluginCompound).getSetupTasks();
            ECollections.sort((EList)preferenceTasks, (Comparator)new Comparator<SetupTask>(){

                @Override
                public int compare(SetupTask o1, SetupTask o2) {
                    String n1 = StringUtil.safe((String)((PreferenceTask)o1).getKey()).toLowerCase();
                    String n2 = StringUtil.safe((String)((PreferenceTask)o2).getKey()).toLowerCase();
                    return n1.compareTo(n2);
                }
            });
        }
    }

    private void migrateOldTasksRecursively(SetupTaskContainer container) {
        if (container == this.preferenceCompound) {
            return;
        }
        Object[] objectArray = container.getSetupTasks().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof PreferenceTask) {
                PreferenceTask preferenceTask = (PreferenceTask)object;
                EObject eContainer = preferenceTask.eContainer();
                String pluginID = URI.createURI((String)preferenceTask.getKey()).segment(1).toString();
                CompoundTask pluginCompound = (CompoundTask)RecorderTransaction.getPreferenceTask((EList<SetupTask>)this.preferenceCompound.getSetupTasks(), SetupPackage.Literals.COMPOUND_TASK__NAME, pluginID, true);
                pluginCompound.getSetupTasks().add((Object)preferenceTask);
                while (eContainer instanceof CompoundTask) {
                    CompoundTask oldCompound = (CompoundTask)eContainer;
                    if (oldCompound.getSetupTasks().isEmpty()) {
                        eContainer = oldCompound.eContainer();
                        EcoreUtil.remove((EObject)oldCompound);
                        continue;
                    }
                    break;
                }
            } else if (object instanceof SetupTaskContainer) {
                this.migrateOldTasksRecursively((SetupTaskContainer)object);
            }
            ++n2;
        }
    }

    private static SetupTask getPreferenceTask(EList<SetupTask> tasks, EAttribute key, String value, boolean createOnDemand) {
        int position = 0;
        String value1 = StringUtil.safe((String)value).toLowerCase();
        for (SetupTask task : tasks) {
            String value2 = StringUtil.safe((String)((String)task.eGet((EStructuralFeature)key))).toLowerCase();
            int compare = value2.compareTo(value1);
            if (compare == 0) {
                return task;
            }
            if (compare >= 0) continue;
            ++position;
        }
        if (!createOnDemand) {
            return null;
        }
        EClass eClass = key.getEContainingClass();
        SetupTask task = (SetupTask)EcoreUtil.create((EClass)eClass);
        task.eSet((EStructuralFeature)key, (Object)value);
        tasks.add(position, (Object)task);
        return task;
    }

    private static IFile getWorkspacePropertiesFile() {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.oomph.setup.ui").getFile(POLICIES_FILE_NAME);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static RecorderTransaction open() {
        if (instance == null) {
            final IEditorPart[] editor = new IEditorPart[1];
            final CountDownLatch editorLoadedLatch = new CountDownLatch(1);
            IWorkbench workbench = null;
            try {
                workbench = PlatformUI.getWorkbench();
            }
            catch (Exception exception) {}
            if (workbench != null) {
                IWorkbenchPage page;
                IWorkbenchWindow[] windows;
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null && (windows = workbench.getWorkbenchWindows()).length != 0) {
                    window = windows[0];
                }
                IWorkbenchPage iWorkbenchPage = page = window != null ? window.getActivePage() : null;
                if (page != null) {
                    UIUtil.syncExec((Runnable)new Runnable(){

                        public void run() {
                            editor[0] = SetupEditorSupport.getEditor(page, SetupContext.USER_SETUP_URI, false, new SetupEditorSupport.LoadHandler(){

                                protected void loaded(IEditorPart editor, EditingDomain domain, Resource resource) {
                                    instance = (RecorderTransaction)new EditorTransaction(editor, domain, resource);
                                    editorLoadedLatch.countDown();
                                }
                            });
                        }
                    });
                }
            }
            if (editor[0] != null) {
                try {
                    editorLoadedLatch.await();
                }
                catch (InterruptedException ex) {
                    throw new Error(ex);
                }
            } else {
                ResourceSet resourceSet = SetupUtil.createResourceSet();
                Resource resource = resourceSet.getResource(SetupContext.USER_SETUP_URI, true);
                instance = new ResourceTransaction(resource);
            }
        }
        return instance;
    }

    static RecorderTransaction getInstance() {
        return instance;
    }

    public static final class EditorTransaction
    extends RecorderTransaction {
        private final IEditorPart editor;
        private final EditingDomain domain;
        private final boolean editorWasClean;

        private EditorTransaction(IEditorPart editor, EditingDomain domain, Resource resource) {
            super(resource);
            this.editor = editor;
            this.domain = domain;
            this.editorWasClean = !editor.isDirty();
            this.initializePolicies();
        }

        protected void doCommit() {
            ISelection selection = ((ISelectionProvider)this.editor).getSelection();
            final List oldSelection = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.emptyList();
            ChangeCommand command = new ChangeCommand((Notifier)this.domain.getResourceSet()){
                List<? extends Object> recorderObjects;
                List<? extends Object> affectedObjects;
                {
                    super($anonymous0);
                    this.recorderObjects = Collections.emptyList();
                    this.affectedObjects = Collections.emptyList();
                }

                public String getLabel() {
                    return "Record Preferences";
                }

                public String getDescription() {
                    return "Records the preferences changes as preference tasks";
                }

                public Collection<?> getAffectedObjects() {
                    return this.affectedObjects;
                }

                protected void doExecute() {
                    this.recorderObjects = EditorTransaction.this.applyChanges();
                    this.affectedObjects = this.recorderObjects;
                }

                public void undo() {
                    super.undo();
                    this.affectedObjects = oldSelection;
                }

                public void redo() {
                    super.redo();
                    this.affectedObjects = this.recorderObjects;
                }
            };
            CommandStack commandStack = this.domain.getCommandStack();
            commandStack.execute((Command)command);
            if (this.editorWasClean && this.editor.isDirty()) {
                UIUtil.syncExec((Runnable)new Runnable(){

                    public void run() {
                        EditorTransaction.this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                });
            }
        }
    }

    public static final class ResourceTransaction
    extends RecorderTransaction {
        private ResourceTransaction(Resource resource) {
            super(resource);
            this.initializePolicies();
        }

        protected void doCommit() {
            List<? extends Object> recorderObjects = this.applyChanges();
            if (recorderObjects != null) {
                try {
                    this.getResource().save(null);
                }
                catch (IOException ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                }
            }
        }
    }
}

