/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TsuperReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;

public class TSuperMessageSend
extends MessageSend {
    public TsuperReference tsuperReference;

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = super.analyseCode(currentScope, flowContext, flowInfo);
        if (this.binding.isCallin()) {
            MethodBinding tsuperMethod = this.binding;
            if (tsuperMethod.copyInheritanceSrc != null) {
                tsuperMethod = tsuperMethod.copyInheritanceSrc;
            }
            if (!MethodModel.hasCallinFlag(tsuperMethod, 8)) {
                MethodDeclaration callinMethod = (MethodDeclaration)currentScope.methodScope().referenceContext;
                LocalVariableBinding trackingVariable = callinMethod.baseCallTrackingVariable.binding;
                if (MethodModel.hasCallinFlag(tsuperMethod, 16)) {
                    if (flowInfo.isDefinitelyAssigned(trackingVariable) || flowInfo.isPotentiallyAssigned(trackingVariable)) {
                        currentScope.problemReporter().potentiallyDuplicateBasecall(this);
                    } else {
                        FlowInfo potential = flowInfo.copy();
                        potential.markAsDefinitelyAssigned(trackingVariable);
                        flowInfo = FlowInfo.conditional(flowInfo.initsWhenTrue(), potential.initsWhenTrue());
                    }
                } else {
                    if (flowInfo.isDefinitelyAssigned(trackingVariable)) {
                        currentScope.problemReporter().definitelyDuplicateBasecall(this);
                    } else if (flowInfo.isPotentiallyAssigned(trackingVariable)) {
                        currentScope.problemReporter().potentiallyDuplicateBasecall(this);
                    }
                    if (!flowInfo.isDefinitelyAssigned(trackingVariable)) {
                        flowInfo.markAsDefinitelyAssigned(trackingVariable);
                    }
                }
            }
        }
        return flowInfo;
    }

    @Override
    protected void findMethodBinding(BlockScope scope, TypeBinding[] argumentTypes) {
        ReferenceBinding receiverRole;
        AbstractMethodDeclaration context = scope.methodScope().referenceMethod();
        if (context == null || !CharOperation.equals(this.selector, context.selector) || context.binding.parameters.length != argumentTypes.length) {
            scope.problemReporter().tsuperCallsWrongMethod(this);
            return;
        }
        if (!(this.actualReceiverType instanceof ReferenceBinding) || !(receiverRole = (ReferenceBinding)this.actualReceiverType).isSourceRole()) {
            scope.problemReporter().tsuperOutsideRole(context, this, this.actualReceiverType);
            return;
        }
        ReferenceBinding[] tsuperRoleBindings = receiverRole.roleModel.getTSuperRoleBindings();
        if (tsuperRoleBindings.length == 0) {
            scope.problemReporter().tsuperCallWithoutTsuperRole(receiverRole, this);
            return;
        }
        this.tsuperReference.resolveType(scope);
        if (this.tsuperReference.qualification != null) {
            TypeBinding tsuperRole = this.tsuperReference.resolvedType;
            if (tsuperRole == null || !tsuperRole.isRole()) {
                return;
            }
            this.binding = scope.getMethod(tsuperRole, this.selector, argumentTypes, this);
            if (!this.binding.isValidBinding() && ((ProblemMethodBinding)this.binding).declaringClass == null) {
                this.binding.declaringClass = (ReferenceBinding)tsuperRole;
            }
            TSuperMessageSend.resolvePolyExpressionArguments(this, this.binding, argumentTypes, scope);
            return;
        }
        MethodBinding bestMatch = null;
        int i = tsuperRoleBindings.length - 1;
        while (i >= 0) {
            ReferenceBinding tsuperRole = tsuperRoleBindings[i];
            MethodBinding candidate = scope.getMethod(tsuperRole, this.selector, argumentTypes, this);
            if (candidate.isValidBinding()) {
                if (scope.parameterCompatibilityLevel(candidate, argumentTypes) != 0) {
                    scope.problemReporter().tsuperCallsWrongMethod(this);
                    return;
                }
                this.binding = candidate;
                TSuperMessageSend.resolvePolyExpressionArguments(this, this.binding, argumentTypes, scope);
                return;
            }
            if (bestMatch == null || ((Binding)bestMatch).problemId() == 1 && candidate.problemId() != 1) {
                bestMatch = candidate;
            }
            --i;
        }
        if (bestMatch == null) {
            bestMatch = new ProblemMethodBinding(this.selector, argumentTypes, 1);
        }
        if (bestMatch.declaringClass == null) {
            bestMatch.declaringClass = (ReferenceBinding)this.tsuperReference.resolvedType;
        }
        this.binding = bestMatch;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int len = this.binding.parameters.length;
        TypeBinding[] extendedParameters = new TypeBinding[len + 1];
        System.arraycopy(this.binding.parameters, 0, extendedParameters, 0, len);
        char[] tSuperMarkName = TSuperHelper.getTSuperMarkName(this.tsuperReference.resolvedType.enclosingType());
        extendedParameters[len] = currentScope.getType(tSuperMarkName);
        MethodBinding codegenBinding = currentScope.getMethod(this.actualReceiverType, this.selector, extendedParameters, this);
        if (codegenBinding.problemId() == 1) {
            ReferenceBinding superRole = ((ReferenceBinding)this.receiver.resolvedType).superclass();
            codegenBinding = this.getAlternateMethod(currentScope, superRole, extendedParameters);
            if (codegenBinding == null) {
                codegenBinding = this.getAlternateMethod(currentScope, superRole, this.binding.parameters);
            }
            if (codegenBinding == null) {
                throw new InternalCompilerError("cannot find real method binding for tsuper call!");
            }
            this.receiver = new SuperReference(this.receiver.sourceStart, this.receiver.sourceEnd);
            this.receiver.resolvedType = superRole;
            this.receiver.constant = Constant.NotAConstant;
            this.actualReceiverType = superRole;
        }
        MethodBinding tsuperMethod = this.binding;
        this.binding = codegenBinding;
        try {
            super.generateCode(currentScope, codeStream, valueRequired);
        }
        finally {
            this.binding = tsuperMethod;
        }
        if (valueRequired && this.binding.isCallin() && this.resolvedType != null && this.resolvedType.isValidBinding()) {
            if (this.resolvedType.isBaseType()) {
                char[][] boxtypeName = AstGenerator.boxTypeName((BaseTypeBinding)this.resolvedType);
                codeStream.checkcast(currentScope.getType(boxtypeName, 3));
                codeStream.generateUnboxingConversion(this.resolvedType.id);
            } else {
                codeStream.checkcast(this.resolvedType);
            }
        }
    }

    @Override
    public void generateArguments(MethodBinding binding, Expression[] arguments, BlockScope currentScope, CodeStream codeStream) {
        TypeBinding tsuperMarkerBinding;
        super.generateArguments(binding, arguments, currentScope, codeStream);
        TypeBinding[] parameters = this.binding.parameters;
        TypeBinding typeBinding = tsuperMarkerBinding = parameters.length == 0 ? null : parameters[parameters.length - 1];
        if (tsuperMarkerBinding == null || !TSuperHelper.isMarkerInterface(tsuperMarkerBinding)) {
            return;
        }
        codeStream.aconst_null();
        codeStream.checkcast(tsuperMarkerBinding);
    }

    private MethodBinding getAlternateMethod(Scope scope, ReferenceBinding superRole, TypeBinding[] argumentTypes) {
        MethodBinding alternateMethod = scope.getMethod(superRole, this.selector, argumentTypes, this);
        if (alternateMethod.problemId() == 2) {
            return alternateMethod;
        }
        MethodBinding alternateSrc = alternateMethod.copyInheritanceSrc;
        if (alternateSrc != null && this.isRoleOfSuperTeam(alternateSrc.declaringClass, scope)) {
            return alternateMethod;
        }
        return null;
    }

    @Override
    protected boolean isAnySuperAccess() {
        return true;
    }

    private boolean isRoleOfSuperTeam(ReferenceBinding roleClass, Scope scope) {
        SourceTypeBinding site = scope.enclosingSourceType();
        if (!site.isRole()) {
            return false;
        }
        return site.enclosingType().superclass().isCompatibleWith(roleClass.enclosingType());
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding answer = super.resolveType(scope);
        if (this.binding != null && this.binding.isCallin()) {
            this.resolvedType = MethodModel.getReturnType(this.binding);
            return this.resolvedType;
        }
        return answer;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.tsuperReference != null && this.tsuperReference.qualification != null) {
            this.tsuperReference.qualification.printExpression(indent, output);
            output.append(".");
        }
        output.append("tsuper.");
        return super.printExpression(indent, output);
    }
}

