/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFBaseAdapterFactory.java,v 1.1 2007/03/18 08:10:09 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.eodm.rdf.rdfbase.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage
 * @generated
 */
public class RDFBaseAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static RDFBasePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFBaseAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = RDFBasePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RDFBaseSwitch modelSwitch =
		new RDFBaseSwitch() {
			public Object caseBlankNode(BlankNode object) {
				return createBlankNodeAdapter();
			}
			public Object caseRDFSResource(RDFSResource object) {
				return createRDFSResourceAdapter();
			}
			public Object caseRDFProperty(RDFProperty object) {
				return createRDFPropertyAdapter();
			}
			public Object casePlainLiteral(PlainLiteral object) {
				return createPlainLiteralAdapter();
			}
			public Object caseRDFSLiteral(RDFSLiteral object) {
				return createRDFSLiteralAdapter();
			}
			public Object caseURIReference(URIReference object) {
				return createURIReferenceAdapter();
			}
			public Object caseRDFStatement(RDFStatement object) {
				return createRDFStatementAdapter();
			}
			public Object caseUniformResourceIdentifier(UniformResourceIdentifier object) {
				return createUniformResourceIdentifierAdapter();
			}
			public Object caseGraph(RDFGraph object) {
				return createGraphAdapter();
			}
			public Object caseURIReferenceNode(URIReferenceNode object) {
				return createURIReferenceNodeAdapter();
			}
			public Object caseTypedLiteral(TypedLiteral object) {
				return createTypedLiteralAdapter();
			}
			public Object caseRDFXMLLiteral(RDFXMLLiteral object) {
				return createRDFXMLLiteralAdapter();
			}
			public Object defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target) {
		return (Adapter)modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.BlankNode <em>Blank Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.BlankNode
	 * @generated
	 */
	public Adapter createBlankNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource <em>RDFS Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource
	 * @generated
	 */
	public Adapter createRDFSResourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty <em>RDF Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty
	 * @generated
	 */
	public Adapter createRDFPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.PlainLiteral <em>Plain Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.PlainLiteral
	 * @generated
	 */
	public Adapter createPlainLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFSLiteral <em>RDFS Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSLiteral
	 * @generated
	 */
	public Adapter createRDFSLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.URIReference <em>URI Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference
	 * @generated
	 */
	public Adapter createURIReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement <em>RDF Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFStatement
	 * @generated
	 */
	public Adapter createRDFStatementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier <em>Uniform Resource Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier
	 * @generated
	 */
	public Adapter createUniformResourceIdentifierAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFGraph <em>RDFGraph</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFGraph
	 * @generated
	 */
	public Adapter createGraphAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.URIReferenceNode <em>URI Reference Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReferenceNode
	 * @generated
	 */
	public Adapter createURIReferenceNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.TypedLiteral <em>Typed Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.TypedLiteral
	 * @generated
	 */
	public Adapter createTypedLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral <em>RDFXML Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral
	 * @generated
	 */
	public Adapter createRDFXMLLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //RDFBaseAdapterFactory
