/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: Test.java,v 1.3 2007/04/03 09:50:42 lzhang Exp $
 */

package org.eclipse.eodm.owl.reasoner.structural;

import java.util.Iterator;
import java.util.List;
import java.util.Random;

import org.eclipse.eodm.OWLFactory;
import org.eclipse.eodm.owl.owlbase.IntersectionClass;
import org.eclipse.eodm.owl.owlbase.OWLClass;
import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLObjectProperty;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.UnionClass;

public class Test {
    
    public static void main(String argv[]) {
    	testNormalize();
    	
    	testDNFandCNFs();
        testNormalizeDC();
        testResolution();
    	
        testToAllForms();
    	
    	testTBox();
    	
    	testReasoner();
    }
    
    private static void testReasoner() {
    	OWLFactory factory = OWLFactory.eINSTANCE;
    	
    	try {
    		OWLGraph graph = factory.createOWLGraph("http://graph.test.org");
    		OWLOntology ontology = factory.createOWLOntology(graph,"http://test.org");
    		ontology.getOwlGraph().add(graph);
    		
    		OWLClass a = factory.createOWLClass(graph,"http://test.org#A");
    		OWLClass b = factory.createOWLClass(graph,"http://test.org#B");
    		OWLClass c = factory.createOWLClass(graph,"http://test.org#C");
    		OWLClass d = factory.createOWLClass(graph,"http://test.org#D");
    		OWLClass e = factory.createOWLClass(graph,"http://test.org#E");
    		OWLClass f = factory.createOWLClass(graph,"http://test.org#F");
    		
    		IntersectionClass in = factory.createIntersectionClass(graph);
    		in.getOWLintersectionOf().add(b);
    		in.getOWLintersectionOf().add(c);
    		
    		a.getEquivalentClass().add(in);
    		
    		UnionClass un = factory.createUnionClass(graph);
    		un.getOWLunionOf().add(b);
    		un.getOWLunionOf().add(c);
    		d.getEquivalentClass().add(un);
    		
    		OWLObjectProperty p1 = factory.createOWLObjectProperty(graph,"http://test.org#p1");
    		OWLObjectProperty p2 = factory.createOWLObjectProperty(graph,"http://test.org#p2");
    		p1.getSubProperty().add(p2);
    		
    		SomeValuesFromRestriction aP1A = factory.createSomeValuesFromRestriction(graph);
    		aP1A.setOWLonProperty(p1);
    		aP1A.setSomeValuesFromClass(a);
    		e.getEquivalentClass().add(aP1A);

    		SomeValuesFromRestriction aP2A = factory.createSomeValuesFromRestriction(graph);
    		aP2A.setOWLonProperty(p2);
    		aP2A.setSomeValuesFromClass(a);
    		f.getEquivalentClass().add(aP2A);
    		
    		OWLStructuralSubsumptionReasoner reasoner = new OWLStructuralSubsumptionReasoner();
    		
    		reasoner.initialize(ontology);
    		
    		if(reasoner.isSubPropertyOf(p2,p1)) {
    			System.out.println("p2 is subproperty of p1" );
    		} else {
    			System.out.println("p2 is not subproperty of p1" );
    		}
    		
    		
    		List l = reasoner.getDescendantClasses(e);
    		
    		for(Iterator it=l.iterator();it.hasNext();){
    			OWLClass clazz = (OWLClass)it.next();
    			
    			System.out.println(clazz.getURI());
    		}
    		//show(reasoner.tbox);
    		
    	} catch (Exception e) {
    		e.printStackTrace();
    	}
    	
    	
    }
    
    private static void testTBox(){
    	
    	TBox tbox = new TBox(rbox);

//    	for(int i=0;i<2;i++){
//    		Concept c = createRandomClass(2);
//    		
//    		System.out.println(ReasonerUtil.toString(c));
//    		//Concept forms[] = ReasonerUtil.getAllForms(c, rbox);
//    		
//    		tbox.addConcept(c);
//    	}
    	
    	Intersection AandB = TermFactory.instance().createIntersect(A,B);
    	Union AorB = TermFactory.instance().createUnion(A,B);
    	AllValueFrom aRA = TermFactory.instance().createAll(R,A);
    	AllValueFrom aSA = TermFactory.instance().createAll(S,A);
    	
    	tbox.addConcept(AandB);
    	tbox.addConcept(AorB);
    	tbox.addConcept(aRA);
    	tbox.addConcept(aSA);
    	
    	show(tbox);
    	
    }
    
    private static void testToAllForms(){
    	//Role[] plist = createRandomProperties(1);
    	
    	for(int i=0;i<4;i++){
    		Concept c = createRandomClass(10);
    		Concept forms[] = ReasonerUtil.getAllForms(c, rbox);
    		System.out.println("Orignal: " + ReasonerUtil.toString(c) 
    				+ "\ntoMinDNF: " + ReasonerUtil.toString(forms[0]) 
    				+ "\ntoMaxCNF: " + ReasonerUtil.toString(forms[1])
    		);
    	}
    	
    	
    }
    
    private static void testNormalizeDC() {       
        Concept BandC = TermFactory.instance().createIntersect(B,C);
        Concept eq1 = TermFactory.instance().createUnion(A,BandC);
        
        System.out.println("Orignal: " + ReasonerUtil.toString(eq1)
                + "\ntoDNF:" + ReasonerUtil.toString(ReasonerUtil.toDNF(eq1,false)) 
                + "\nCNF:" + ReasonerUtil.toString(ReasonerUtil.toCNF(eq1,false))
                );
        
    }
    
    private static void testNormalize() {
        Concept A = TermFactory.instance().createPrim("A");
        Concept B = TermFactory.instance().createPrim("B");
        //Concept C = TermFactory.instance().createPrim("C");
        //Concept D = TermFactory.instance().createPrim("D");
        
        RBox rbox = new RBox();
        Role r = TermFactory.instance().createObjectProp("r");
        Role s = TermFactory.instance().createObjectProp("s");
        rbox.addSubPropertyOfAxiom(s,r);
        

        // R1
        AllValueFrom arA = TermFactory.instance().createAll(r,A);
        AllValueFrom asB = TermFactory.instance().createAll(s,B);
        Intersection arAandasB = TermFactory.instance().createIntersect(arA,asB);
        System.out.println("R1 Orignal: " + ReasonerUtil.toString(arAandasB) + "\ntoMinimalDNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandasB,rbox)) );
        
        //R3
        SomeValueFrom ssB = TermFactory.instance().createSome(s,B);
        Intersection arAandssB = TermFactory.instance().createIntersect(arA,ssB);
        System.out.println("R3 Orignal: " + ReasonerUtil.toString(arAandssB) + "\ntoMinimalDNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandssB,rbox)) );
  
        // R3'
        MinCardinality mnsB = TermFactory.instance().createMinCardinality(s,2,B);
        Intersection arAandmnsB = TermFactory.instance().createIntersect(arA,mnsB);
        System.out.println("R3' Orignal: " + ReasonerUtil.toString(arAandmnsB) + "\ntoMinimalDNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandmnsB,rbox)) );
        
        // R5
        Cardinality ensB = TermFactory.instance().createCardinality(s,5,B);
        Intersection arAandensB = TermFactory.instance().createIntersect(arA,ensB);
        System.out.println("R5 Orignal: " + ReasonerUtil.toString(arAandensB) + "\ntoMinimalDNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandensB,rbox)) );
        
        // R7
        MaxCardinality maxnsB = TermFactory.instance().createMaxCardinality(s,5,B);
        Intersection arAandmaxnsB = TermFactory.instance().createIntersect(arA,maxnsB);
        System.out.println("R7 Orignal: " + ReasonerUtil.toString(arAandmaxnsB) + "\ntoMinimalDNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(arAandmaxnsB,rbox)) );
        
        
        System.out.println();
        
        // R2
        SomeValueFrom srA = TermFactory.instance().createSome(r,A);
        ssB = TermFactory.instance().createSome(s,B);
        Union srAorssB = TermFactory.instance().createUnion(srA,ssB);
        System.out.println("R2 Orignal: " + ReasonerUtil.toString(srAorssB) + "\ntoMaximalCNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(srAorssB,rbox)) );
        
        // R2'
        MinCardinality m1rA = TermFactory.instance().createMinCardinality(r,1,A);
        mnsB = TermFactory.instance().createMinCardinality(s,2,B);
        Union m1rAormnsB = TermFactory.instance().createUnion(m1rA,mnsB);
        System.out.println("R2' Orignal: " + ReasonerUtil.toString(m1rAormnsB) + "\ntoMaximalCNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(m1rAormnsB,rbox)) );

        // R4
        asB = TermFactory.instance().createAll(s,B);
        Union srAorasB = TermFactory.instance().createUnion(srA,asB);
        System.out.println("R4 Orignal: " + ReasonerUtil.toString(srAorasB) + "\ntoMaximalCNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(srAorasB,rbox)) );
 
        // R4'
        asB = TermFactory.instance().createAll(s,B);
        Union m1rAorasB = TermFactory.instance().createUnion(m1rA,asB);
        System.out.println("R4' Orignal: " + ReasonerUtil.toString(m1rAorasB) + "\ntoMaximalCNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(m1rAorasB,rbox)) );

        // R6
        ensB = TermFactory.instance().createCardinality(s,5,B);
        Union m1rAorensB = TermFactory.instance().createUnion(m1rA,ensB);
        System.out.println("R6 Orignal: " + ReasonerUtil.toString(m1rAorensB) + "\ntoMaximalCNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(m1rAorensB,rbox)) );
        
        // R6'
        ensB = TermFactory.instance().createCardinality(s,5,B);
        Union srAorensB = TermFactory.instance().createUnion(srA,ensB);
        System.out.println("R6' Orignal: " + ReasonerUtil.toString(srAorensB) + "\ntoMaximalCNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(srAorensB,rbox)) );
        
        // R8
        maxnsB = TermFactory.instance().createMaxCardinality(s,5,B);
        Union m1rAormaxnsB = TermFactory.instance().createUnion(m1rA,maxnsB);
        System.out.println("R8 Orignal: " + ReasonerUtil.toString(m1rAormaxnsB) + "\ntoMaximalCNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(m1rAormaxnsB,rbox)) );
        
        // R8'
        maxnsB = TermFactory.instance().createMaxCardinality(s,5,B);
        Union srAormaxnsB = TermFactory.instance().createUnion(srA,maxnsB);
        System.out.println("R8' Orignal: " + ReasonerUtil.toString(srAormaxnsB) + "\ntoMaximalCNF:" 
                + ReasonerUtil.toString(ReasonerUtil.toMaximalCNF(srAormaxnsB,rbox)) );
        
        
//        AllValueFrom arB = TermFactory.instance().createAll(r,B);
//        AllValueFrom arD = TermFactory.instance().createAll(r,D);
//        SomeValueFrom srA = TermFactory.instance().createSome(r,A);
//        SomeValueFrom srC = TermFactory.instance().createSome(r,C);
//        Intersection i1 = TermFactory.instance().createIntersect(srA,arB);
//        Intersection i2 = TermFactory.instance().createIntersect(srC,arD);
//              
//        Union u1 = TermFactory.instance().createUnion(i1,i2);
//               
//        Concept cnf = ReasonerUtil.toCNF(u1,true);
//        Concept tcnf = ReasonerUtil.toMaximalCNF(cnf,rbox);
//        Concept tcnf2dnf = ReasonerUtil.toDNF(tcnf,true);
//        Concept t_tcnf2dnf = ReasonerUtil.toMinimalDNF(tcnf2dnf,rbox);
//        
//        Concept t1 = ReasonerUtil.toMinimalDNF(u1,rbox);
//        Concept t1cnf = ReasonerUtil.toCNF(t1,true);
//        Concept t_t1cnf = ReasonerUtil.toMaximalCNF(t1cnf,rbox);
//        
//        System.out.println("Orignal: " + ReasonerUtil.toString(u1)
//                + "\ntoMinimalDNF:" + ReasonerUtil.toString(t1) 
//                + "\nCNF:" + ReasonerUtil.toString(t1cnf) 
//                + "\nMaximalCNF" + ReasonerUtil.toString(t_t1cnf)
//                + "\nMinimalDNF" + ReasonerUtil.toString(t_tcnf2dnf)
//                );
        

//        System.out.println(ReasonerUtil.toString( ReasonerUtil.toDNF(u1,true) ));
//        System.out.println(ReasonerUtil.toString( ReasonerUtil.toCNF(u1,true) ));
        
//        // random test        
//        int depth = 4;
//        int numAtoms = 5;
//        
//        RBox rbox = new RBox();
//        Property[] plist = createRandomProperties(2);
//        Concept classes[][] = new Concept[depth][];
//        
//        // generate atoms classes
//        classes[0] = createRandomClassesList(numAtoms,0,classes, plist);
//        
//        for(int i=1;i<depth;i++) {
//            classes[i] = createRandomClassesList(numAtoms,i,classes, plist);
//        }
//        
//        for(int i=0;i<numAtoms;i++) {
//            Concept c = classes[depth-1][i];
//            System.out.println("Orignal: " + ReasonerUtil.toString(c));
//            System.out.println("toMinimalDNF: " + ReasonerUtil.toString(ReasonerUtil.toMinimalDNF(c,rbox) ));
//        }
        
    }
    
//    private static Concept[] createRandomClassesList(int size, int depth,Concept[][]classes, Role[] plist) {
//        Concept[] result = new Concept[size];
//        
//        for(int i=0;i<size;i++) {
//            if(depth==0) {
//                result[i] = TermFactory.instance().createPrim("c"+i);
//            } else {
//                //int type = TermUtil.C_INTERSECT + random.nextInt(TermUtil.C_CARD - TermUtil.C_INTERSECT);
//                int type = 0;
//                
//                int rate = random.nextInt(18);
//                if(rate<5) {
//                    type = TermUtil.C_INTERSECT;
//                } else if(rate<10) {
//                    type = TermUtil.C_UNION;
//                } else if(rate<13) {
//                    type = TermUtil.C_ALL;
//                } else if(rate<15) {
//                    type = TermUtil.C_SOME;
//                } else if(rate<16) {
//                    type = TermUtil.C_MIN;
//                } else if(rate<17) {
//                    type = TermUtil.C_MAX;
//                } else  {
//                    type = TermUtil.C_CARD;
//                }
//                
//                
//                switch(type) {
//                case TermUtil.C_INTERSECT:
//                    int left = random.nextInt(depth);
//                    int right = depth - left - 1;
//                    result[i] = TermFactory.instance().createIntersect(getRandomClass(classes[left]),getRandomClass(classes[right]));
//                    break;
//                case TermUtil.C_UNION:
//                    left = random.nextInt(depth);
//                    right = depth - left - 1;
//                    result[i] = TermFactory.instance().createUnion(getRandomClass(classes[left]),getRandomClass(classes[right]));
//                    break;
//                case TermUtil.C_SOME:
//                    result[i] = TermFactory.instance().createSome(getRandomProperty(plist),getRandomClass(classes[depth-1]));
//                    break;
//                case TermUtil.C_ALL:
//                    result[i] = TermFactory.instance().createAll(getRandomProperty(plist),getRandomClass(classes[depth-1]));
//                    break;
//                case TermUtil.C_MIN:
//                    result[i] = TermFactory.instance().createMinCardinality(getRandomProperty(plist),random.nextInt(4),getRandomClass(classes[depth-1]));
//                    break;
//                case TermUtil.C_MAX:
//                    result[i] = TermFactory.instance().createMaxCardinality(getRandomProperty(plist),random.nextInt(4),getRandomClass(classes[depth-1]));
//                    break;
//                case TermUtil.C_CARD:
//                    result[i] = TermFactory.instance().createCardinality(getRandomProperty(plist),random.nextInt(4),getRandomClass(classes[depth-1]));
//                    break;
//                }               
//            }
//        }
//        
//        return result;
//    }
    
//    private static Role getRandomProperty(Role[] plist) {
//        return plist[random.nextInt(plist.length)];
//    }
//    
//    private static Concept getRandomClass(Concept[] clist) {
//        return clist[random.nextInt(clist.length)];
//    }
    
    public static void testResolution() {
        Concept C = TermFactory.instance().createPrim("C");
        Concept D = TermFactory.instance().createPrim("D");
        Concept E = TermFactory.instance().createPrim("E");
        
        Negation NC = TermFactory.instance().createNegation(C);
        Negation ND = TermFactory.instance().createNegation(D);
        Negation NE = TermFactory.instance().createNegation(E);
        
        Intersection CandD = TermFactory.instance().createIntersect(C,D);
        Union NDorNE = TermFactory.instance().createUnion(ND,NE);
        Union NCorE = TermFactory.instance().createUnion(NC,E);
        
        Intersection term = TermFactory.instance().createIntersect(CandD,NDorNE);
        term.addIntersectOf(NCorE);
        System.out.println( ReasonerUtil.toString( ReasonerUtil.toDNF(term, true) ) );
        
    }
    
    private static void testDNFandCNFs() {
        Concept prim1 = TermFactory.instance().createPrim("1");
        Concept prim2 = TermFactory.instance().createPrim("2");
        Concept prim3 = TermFactory.instance().createPrim("3");
//        Concept prim4 = TermFactory.instance().createPrim("4");
//        Concept prim5 = TermFactory.instance().createPrim("5");
//        Concept prim6 = TermFactory.instance().createPrim("6");
//        Concept prim7 = TermFactory.instance().createPrim("7");
//        Concept prim8 = TermFactory.instance().createPrim("8");
//        Concept prim9 = TermFactory.instance().createPrim("9");      
               
        Intersection and1 = TermFactory.instance().createIntersect(prim1,prim2);
        
        Intersection and2 = TermFactory.instance().createIntersect(prim1,prim2);
        and2.addIntersectOf(prim3);
        
        Union term = TermFactory.instance().createUnion(and1,and2);
        
        System.out.println("Orignal: " + ReasonerUtil.toString(term));
        System.out.println("toDNF: " + ReasonerUtil.toString(ReasonerUtil.toDNF(term,true) ));
        System.out.println("toCNF: " + ReasonerUtil.toString(ReasonerUtil.toCNF(term,true) ));
    }
    
//    private static Role[] createRandomProperties(int size) {
//        Role prop[] = new Role[size];
//
//        for (int i = 0; i < size; i++) {
//            prop[i] = TermFactory.instance().createObjectProp("p"+ pid++);
//        }
//        
//        return prop;
//    }
    
    public static Role getRandomProperty() {
    	Role r = TermFactory.instance().createObjectProp( String.valueOf((char) ('R' + random.nextInt(3))) );
        return r;
    }
    
//    private static Resource createRandomInstance() {
//        return TermFactory.instance().createIndividual("i" + rid++);
//    }
    
//    private static Concept createRandomClass(int depth, Role p) {
//        Concept c = null;
//        if(depth<=1) {
//            int type = TermUtil.C_MIN + random.nextInt(TermUtil.C_PRIM - TermUtil.C_MIN);
//            switch(type) {
//            case TermUtil.C_MIN:
//                c = TermFactory.instance().createMinCardinality(p,random.nextInt(5),null);
//                break;
//            case TermUtil.C_MAX:
//                c = TermFactory.instance().createMaxCardinality(p,random.nextInt(5),null);
//                break;
//            case TermUtil.C_CARD:
//                c = TermFactory.instance().createCardinality(p,random.nextInt(5),null);
//                break;
//            case TermUtil.C_VALUE:
//                c = TermFactory.instance().createHasValue(p,createRandomInstance());
//                break;
//            case TermUtil.C_PRIM:
//                c = TermFactory.instance().createPrim("r" + cid++); 
//                break;
//            }           
//        }
//        else {
//            int type = TermUtil.C_NEGATION + random.nextInt(TermUtil.C_ALL - TermUtil.C_NEGATION);
//            int sect = random.nextInt(depth-1);
//            switch(type) {
//            case TermUtil.C_NEGATION:
//                c = TermFactory.instance().createNegation(createRandomClass(depth-1,p));
//                break;
//            case TermUtil.C_INTERSECT:
//                c = TermFactory.instance().createIntersect(createRandomClass(sect,p),createRandomClass(depth - sect -1,p));
//                break;
//            case TermUtil.C_UNION:
//                c = TermFactory.instance().createUnion(createRandomClass(sect,p),createRandomClass(depth - sect -1,p));
//                break;
//            case TermUtil.C_SOME:
//                c = TermFactory.instance().createSome(p,createRandomClass(depth-1,p));
//                break;
//            case TermUtil.C_ALL:
//                c = TermFactory.instance().createAll(p,createRandomClass(depth-1,p));
//                break;
//            }
//        }
//        return c;
//    }

    public static Concept createRandomClass(int size) {
        if (size == 1) {
            if (random.nextInt(16) == 0) {
                if (random.nextBoolean()) {
                    return ReasonerUtil.cloneConcept(ReasonerUtil.TOP);
                } else {
                    return ReasonerUtil.cloneConcept(ReasonerUtil.BOTTOM);
                }
            }
            //int index = random.nextInt(10);
            Concept c = TermFactory.instance().createPrim( "C" + String.valueOf(index++) );

            return c;
        }
        if (size == 2 || random.nextInt(10) < 4) {
            if (random.nextBoolean()) {
                AllValueFrom c =  TermFactory.instance().createAll(getRandomProperty(),createRandomClass(size - 1) );
                return c;
            } else {
                SomeValueFrom c = TermFactory.instance().createSome(getRandomProperty(), createRandomClass(size - 1) );
                return c;
            }
        } else {
            Concept c;
            List l;
            if (random.nextBoolean()) {
                c = TermFactory.instance().createIntersect();
                l = ((Intersection) c).getIntersectOf();
            } else {
                c = TermFactory.instance().createUnion();
                l = ((Union) c).getUnionOf();
            }
            size--;
            int r = random.nextInt(sum[size][1] - 1);
            int min = 1;
            while (size > 0) {
                for (int i = min; i <= size; i++) {
                    if (r < sum[size][i] - sum[size][i + 1]) {
                        l.add(createRandomClass(i));
                        size -= i;
                        min = i;
                        break;
                    } else {
                        r -= sum[size][i] - sum[size][i + 1];
                    }
                }
            }
            return c;
        }
    }
    
    
	public static void show(TBox tbox) {
		int size = tbox.nodeList.size();
		int[][] containments = new int[size][size];
		for (int i = 0; i < size; i++) {
			System.out.print("Node No." + i + ":  ");
			//System.out.println("-----------------------------------------");
			CTNode node = (CTNode) tbox.nodeList.get(i);
			Iterator iter = node.getCIDSet().iterator();
			while (iter.hasNext()) {
				System.out.println( ReasonerUtil.toString(tbox.getConceptByID(((Integer) iter.next()).intValue()) ) );
				//ReasonerUtil.show(getOWLClass(((Integer) iter.next()).intValue()), 0);

			}
			iter = node.containmentLinks.iterator();
			while (iter.hasNext()) {
				containments[i][((ContainmentLink) iter.next()).getTarget().topologicalPosition]++;
			}
			System.out.println("-----------------------------------------");
		}
		MyNumberFormat format = new MyNumberFormat(3);
		for (int i = 0; i < size; i++) {
			System.out.print(format.format(i) + "|");
			for (int j = 0; j < size; j++) {
				System.out.print(format.format(containments[i][j]));
			}
			System.out.println();
		}
		System.out.print("   +");
		for (int i = 0; i < size; i++) {
			System.out.print("---");
		}
		System.out.println("--");
		System.out.print("    ");
		for (int i = 0; i < size; i++) {
			System.out.print(format.format(i));
		}
		System.out.println();
	}
	
    
    
    static int index = 0;
    
    private static int[][] sum = new int[100][100];
    static {
        for (int i = 0; i < 100; i++) {
            sum[0][i] = 1;
        }
        for (int i = 1; i < 100; i++) {
            for (int j = i; j >= 1; j--) {
                sum[i][j] = sum[i - j][j];
                if (j < i) {
                    sum[i][j] += sum[i][j + 1];
                }
            }
            for (int j = i + 1; j < 100; j++) {
                sum[i][j] = 0;
            }
        }
    }
    

    
    static ObjectProp R = TermFactory.instance().createObjectProp("R");
    static ObjectProp S = TermFactory.instance().createObjectProp("S");
    static RBox rbox = new RBox(); 
    
    static Concept A = TermFactory.instance().createPrim("A");
    static Concept B = TermFactory.instance().createPrim("B");
    static Concept C = TermFactory.instance().createPrim("C");
    static Concept D = TermFactory.instance().createPrim("D");
    
    static {
    	rbox.addSubPropertyOfAxiom(R,S);
    }
    
    private static Random random = new Random(3);//System.currentTimeMillis());
    
//    private static int cid = 0;
//    private static int pid = 0;
//    private static int rid = 0;
    
	private static class MyNumberFormat {
		public MyNumberFormat(int length) {
			this.length = length;
		}

		public String format(int number) {
			String s = String.valueOf(number);
			if (s.length() < length) {
				StringBuffer sb = new StringBuffer();
				for (int i = s.length(); i < length; i++) {
					sb.append(' ');
				}
				sb.append(s);
				return sb.toString();
			} else {
				return s;
			}
		}

		private int length;
	}
}
