/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt;

import java.util.List;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.Expression;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.internal.Utils;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.Statement;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.GenericVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.VoidVisitor;

public final class ForStmt
extends Statement {
    private List<Expression> init;
    private Expression compare;
    private List<Expression> update;
    private Statement body;

    public ForStmt() {
    }

    public ForStmt(List<Expression> init, Expression compare, List<Expression> update, Statement body) {
        this.setCompare(compare);
        this.setInit(init);
        this.setUpdate(update);
        this.setBody(body);
    }

    public ForStmt(int beginLine, int beginColumn, int endLine, int endColumn, List<Expression> init, Expression compare, List<Expression> update, Statement body) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setCompare(compare);
        this.setInit(init);
        this.setUpdate(update);
        this.setBody(body);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Statement getBody() {
        return this.body;
    }

    public Expression getCompare() {
        return this.compare;
    }

    public List<Expression> getInit() {
        this.init = Utils.ensureNotNull(this.init);
        return this.init;
    }

    public List<Expression> getUpdate() {
        this.update = Utils.ensureNotNull(this.update);
        return this.update;
    }

    public void setBody(Statement body) {
        this.body = body;
        this.setAsParentNodeOf(this.body);
    }

    public void setCompare(Expression compare) {
        this.compare = compare;
        this.setAsParentNodeOf(this.compare);
    }

    public void setInit(List<Expression> init) {
        this.init = init;
        this.setAsParentNodeOf(this.init);
    }

    public void setUpdate(List<Expression> update) {
        this.update = update;
        this.setAsParentNodeOf(this.update);
    }
}

