/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.xtend.typesystem.AbstractTypeImpl;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.emf.EClassType;
import org.eclipse.xtend.typesystem.emf.EDataTypeType;
import org.eclipse.xtend.typesystem.emf.EcoreUtil2;
import org.eclipse.xtend.typesystem.emf.EmfRegistryMetaModel;
import org.eclipse.xtend.typesystem.xsd.XMLTypeMapper;
import org.eclipse.xtend.typesystem.xsd.builder.OawXSDResourceSet;
import org.eclipse.xtend.typesystem.xsd.builder.XSDManager;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureMapEntryTypeImpl;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureMapTypeImpl;
import org.eclipse.xtend.typesystem.xsd.type.EFeatureType;
import org.eclipse.xtend.typesystem.xsd.type.EMapEntryType;
import org.eclipse.xtend.typesystem.xsd.type.EMapType;
import org.eclipse.xtend.typesystem.xsd.type.QNameType;
import org.eclipse.xtend.typesystem.xsd.type.XMLEClassType;
import org.eclipse.xtend.typesystem.xsd.type.XMLFeatureMapTypeImpl;
import org.eclipse.xtend.typesystem.xsd.util.Msg;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDMetaModel
extends EmfRegistryMetaModel {
    public static final String EFEATURE = "EFeature";
    private static final String EFEATURE_MAP = "XMLFeatureMap";
    public static final String EFEATURE_MAP_ENTRY = "EFeatureMapEntry";
    private static final String EMAP = "EMap";
    private static final String EMAP_ENTRY = "EMapEntry";
    private static Map<String, XSDMetaModel> mmRegistry = new HashMap<String, XSDMetaModel>();
    private Cache<EClassifier, EMapType> eMapCache = new Cache<EClassifier, EMapType>(){

        protected EMapType createNew(EClassifier c) {
            return new EMapType(XSDMetaModel.this, XSDMetaModel.EMAP, c);
        }
    };
    private Cache<EClass, XMLFeatureMapTypeImpl> featueMapCache = new Cache<EClass, XMLFeatureMapTypeImpl>(){

        protected XMLFeatureMapTypeImpl createNew(EClass c) {
            return new XMLFeatureMapTypeImpl(XSDMetaModel.this, XSDMetaModel.EFEATURE_MAP, c);
        }
    };
    private EFeatureMapEntryTypeImpl featureMapEntry;
    private EFeatureType featureType;
    private boolean registerPackagesGlobally = false;
    protected Log log = XSDLog.getLog(((Object)((Object)this)).getClass());
    private Cache<EClassifier, EMapEntryType> mapEntryCache = new Cache<EClassifier, EMapEntryType>(){

        protected EMapEntryType createNew(EClassifier arg0) {
            return new EMapEntryType(XSDMetaModel.this.getTypeSystem(), XSDMetaModel.EMAP_ENTRY, arg0);
        }
    };
    private QNameType qnameType;
    private Cache<EClassType, XMLEClassType> xmlClassCache = new Cache<EClassType, XMLEClassType>(){

        protected XMLEClassType createNew(EClassType arg0) {
            try {
                Field f = arg0.getClass().getDeclaredField("eClass");
                f.setAccessible(true);
                EClass cls = (EClass)f.get(arg0);
                return new XMLEClassType(XSDMetaModel.this, arg0.getName(), cls);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private XSDManager xsdManager;
    protected Set<EPackage> savedPackages = new HashSet<EPackage>();
    protected String savePackagesPath = null;

    public static XSDMetaModel getInstance(String id) {
        return mmRegistry.get(id);
    }

    public XSDMetaModel() {
        this.xsdManager = new OawXSDResourceSet();
    }

    public XSDMetaModel(XSDManager manager) {
        this.xsdManager = manager;
    }

    public void addSchemaFile(String uri) {
        this.log.info((Object)Msg.create("Loading XSDSchema from ").uri(uri));
        this.xsdManager.loadAndGenerate(EcoreUtil2.getURI((String)uri));
        this.registerNewPackages();
        this.saveNewPackages();
    }

    public EPackage[] allPackages() {
        ArrayList<EPackage> pkgs = new ArrayList<EPackage>(this.xsdManager.getPackages());
        for (Object o : EPackage.Registry.INSTANCE.values()) {
            if (!(o instanceof EPackage)) continue;
            pkgs.add((EPackage)o);
        }
        return pkgs.toArray(new EPackage[pkgs.size()]);
    }

    public EFeatureMapEntryTypeImpl getEFeatureMapEntryType() {
        if (this.featureMapEntry == null) {
            this.featureMapEntry = new EFeatureMapEntryTypeImpl(this, EFEATURE_MAP_ENTRY);
        }
        return this.featureMapEntry;
    }

    public XMLFeatureMapTypeImpl getEFeatureMapType(EClass aClass) {
        return (XMLFeatureMapTypeImpl)((Object)this.featueMapCache.get((Object)aClass));
    }

    public EFeatureType getEFeatureType() {
        if (this.featureType == null) {
            this.featureType = new EFeatureType(this.getTypeSystem(), EFEATURE);
        }
        return this.featureType;
    }

    public EMapEntryType getEMapEntryType(EClassifier innerType) {
        return (EMapEntryType)((Object)this.mapEntryCache.get((Object)innerType));
    }

    public EMapType getEMapType(EClassifier innerType) {
        return (EMapType)((Object)this.eMapCache.get((Object)innerType));
    }

    public Set<Type> getKnownTypes() {
        Set r = super.getKnownTypes();
        return r;
    }

    public QNameType getQNameType() {
        if (this.qnameType == null) {
            this.qnameType = new QNameType(this.getTypeSystem(), "type::QName");
        }
        return this.qnameType;
    }

    public Type getType(Object obj) {
        AbstractTypeImpl r = null;
        if (obj instanceof FeatureMap) {
            FeatureMap m = (FeatureMap)obj;
            EClass c = ((EStructuralFeature.Setting)m).getEObject().eClass();
            r = this.getEFeatureMapType(c);
        } else if (obj instanceof FeatureMap.Entry) {
            r = this.getEFeatureMapEntryType();
        } else if (obj instanceof EStructuralFeature) {
            r = this.getEFeatureType();
        } else if (EMapType.isEMapObject(obj)) {
            EClassifier c = ((EStructuralFeature.Setting)obj).getEStructuralFeature().getEType();
            r = this.getEMapType(c);
        } else if (EMapEntryType.isEMapEntryObject(obj)) {
            EClass i = obj instanceof EObject ? ((EObject)obj).eClass() : null;
            r = this.getEMapEntryType((EClassifier)i);
        } else {
            r = obj instanceof QName ? this.getQNameType() : super.getType(obj);
        }
        return r;
    }

    public Type getTypeForEClassifier(EClassifier element) {
        Type r = super.getTypeForEClassifier(element);
        if (r == null || r instanceof EDataTypeType) {
            r = XMLTypeMapper.instance().get(this, element, this.getTypeSystem());
        } else if (r instanceof EClassType) {
            r = (Type)this.xmlClassCache.get((Object)((EClassType)r));
        }
        return r;
    }

    public Type getTypeForETypedElement(ETypedElement typedElement) {
        EClassifier c = typedElement.getEType();
        if (c == null) {
            return this.getTypeSystem().getVoidType();
        }
        if (EFeatureMapTypeImpl.isFeatureMap(typedElement)) {
            return this.getEFeatureMapType((EClass)typedElement.eContainer());
        }
        if (EMapType.isEMap(typedElement)) {
            return this.getEMapType(typedElement.getEType());
        }
        if (EMapEntryType.isEMapEntry(typedElement)) {
            return this.getEMapEntryType(typedElement.getEType());
        }
        Type t = null;
        t = typedElement.getEType() instanceof EClassifier ? this.getTypeForEClassifier(typedElement.getEType()) : this.getTypeSystem().getTypeForName(XSDMetaModel.getFullyQualifiedName((ENamedElement)typedElement.getEType()));
        if (typedElement.isMany()) {
            return this.getTypeSystem().getListType(t);
        }
        return t;
    }

    public Type getTypeForName(String typeName) {
        AbstractTypeImpl r;
        if (this.getQNameType().getName().equals(typeName)) {
            r = this.getQNameType();
        } else if (EMAP_ENTRY.equals(typeName)) {
            r = this.getEMapEntryType(null);
        } else if (EFEATURE_MAP.equals(typeName)) {
            r = this.getEFeatureMapType(null);
        } else if (EFEATURE_MAP_ENTRY.equals(typeName)) {
            r = this.getEFeatureMapEntryType();
        } else if (EFEATURE.equals(typeName)) {
            r = this.getEFeatureType();
        } else {
            r = super.getTypeForName(typeName);
            if (r instanceof EClassType) {
                r = (Type)this.xmlClassCache.get((Object)((EClassType)r));
            }
        }
        return r;
    }

    public XSDManager getXsdManager() {
        return this.xsdManager;
    }

    public boolean isRegisterPackagesGlobally() {
        return this.registerPackagesGlobally;
    }

    public boolean isSaveEPackages() {
        return this.savePackagesPath != null;
    }

    protected void registerNewPackages() {
        if (!this.isRegisterPackagesGlobally()) {
            return;
        }
        EPackage.Registry reg = EPackage.Registry.INSTANCE;
        for (EPackage pkg : this.xsdManager.getPackages()) {
            if (reg.containsKey((Object)pkg.getNsURI())) continue;
            this.log.info((Object)Msg.create("Registering ").pkg(pkg).txt(" globally."));
            reg.put((Object)pkg.getNsURI(), (Object)pkg);
        }
    }

    protected void saveNewPackages() {
        if (!this.isSaveEPackages()) {
            return;
        }
        for (EPackage pkg : this.xsdManager.getPackages()) {
            if (this.savedPackages.contains(pkg)) continue;
            this.savedPackages.add(pkg);
            URI u = URI.createURI((String)(String.valueOf(this.savePackagesPath) + "/" + pkg.getName() + ".ecore"));
            this.log.info((Object)Msg.create("Saving ").pkg(pkg).txt(" to ").uri(u));
            XMIResourceImpl r = new XMIResourceImpl(u);
            r.getContents().add((Object)EcoreUtil.copy((EObject)pkg));
            try {
                r.save(new HashMap());
            }
            catch (IOException e) {
                this.log.error((Object)Msg.create("Error saving ").uri(u), (Throwable)e);
            }
        }
    }

    public void setId(String id) {
        mmRegistry.put(id, this);
    }

    public void setRegisterPackagesGlobally(boolean registerPackagesGlobally) {
        this.registerPackagesGlobally = registerPackagesGlobally;
        this.registerNewPackages();
    }

    public void setSavePackagesPath(String path) {
        this.savePackagesPath = path;
        this.saveNewPackages();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "-" + this.xsdManager;
    }
}

