/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.inspectors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jet.internal.xpath.inspectors.AbstractResourceAttribute;
import org.eclipse.jet.internal.xpath.inspectors.IWrappedAttribute;

public class ResourceAttributeFactory {
    public static final int FILE_EXTENSION = 1;
    public static final int FULL_PATH = 2;
    public static final int LOCAL_TIMESTAMP = 3;
    public static final int LOCATION = 4;
    public static final int LOCATION_URI = 5;
    public static final int MODIFICATION_STAMP = 6;
    public static final int NAME = 7;
    public static final int PROJECT = 8;
    public static final int PROJECT_RELATIVE_PATH = 9;
    public static final int RAW_LOCATION = 10;
    public static final int RAW_LOCATION_URI = 11;
    public static final int DERIVED = 12;
    public static final int LINKED = 13;
    public static final int PHANTOM = 14;
    public static final int READ_ONLY = 15;
    public static final int TEAM_PRIVATE_MEMBER = 16;
    private static final Map attributeKindByName = new HashMap();

    static {
        attributeKindByName.put("fileExtension", new Integer(1));
        attributeKindByName.put("fullPath", new Integer(2));
        attributeKindByName.put("localTimeStamp", new Integer(3));
        attributeKindByName.put("location", new Integer(4));
        attributeKindByName.put("locationURI", new Integer(5));
        attributeKindByName.put("modificationStamp", new Integer(6));
        attributeKindByName.put("name", new Integer(7));
        attributeKindByName.put("project", new Integer(8));
        attributeKindByName.put("projectRelativePath", new Integer(9));
        attributeKindByName.put("rawLocation", new Integer(10));
        attributeKindByName.put("rawLocationURI", new Integer(11));
        attributeKindByName.put("derived", new Integer(12));
        attributeKindByName.put("linked", new Integer(13));
        attributeKindByName.put("phantom", new Integer(14));
        attributeKindByName.put("readOnly", new Integer(15));
        attributeKindByName.put("teamPrivateMember", new Integer(16));
    }

    public IWrappedAttribute create(int kind, IResource parent) {
        switch (kind) {
            case 1: {
                return new FileExtensionAttribute(parent);
            }
            case 2: {
                return new FullPathAttribute(parent);
            }
            case 3: {
                return new LocalTimeStampAttribute(parent);
            }
            case 4: {
                return new LocationAttribute(parent);
            }
            case 5: {
                return new LocationURIAttribute(parent);
            }
            case 6: {
                return new ModificationStampAttribute(parent);
            }
            case 7: {
                return new NameAttribute(parent);
            }
            case 8: {
                return new ProjectAttribute(parent);
            }
            case 9: {
                return new ProjectRelativePathAttribute(parent);
            }
            case 10: {
                return new RawLocationAttribute(parent);
            }
            case 11: {
                return new RawLocationURIAttribute(parent);
            }
            case 12: {
                return new DerivedAttributed(parent);
            }
            case 13: {
                return new LinkedAttribute(parent);
            }
            case 14: {
                return new PhantomAttribute(parent);
            }
            case 15: {
                return new ReadOnlyAttribute(parent);
            }
            case 16: {
                return new TeamPrivateMemberAttribute(parent);
            }
        }
        return null;
    }

    public IWrappedAttribute create(String name, IResource resource) {
        Integer kind = (Integer)attributeKindByName.get(name);
        if (kind != null) {
            return this.create(kind, resource);
        }
        return null;
    }

    private static final class TeamPrivateMemberAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "teamPrivateMember";

        private TeamPrivateMemberAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return String.valueOf(this.getResource().isTeamPrivateMember());
        }
    }

    private static final class ReadOnlyAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "readOnly";

        private ReadOnlyAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return String.valueOf(this.getResource().isPhantom());
        }
    }

    private static final class PhantomAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "phantom";

        private PhantomAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return String.valueOf(this.getResource().isPhantom());
        }
    }

    private static final class LinkedAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "linked";

        private LinkedAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return String.valueOf(this.getResource().isLinked());
        }
    }

    private static final class DerivedAttributed
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "derived";

        private DerivedAttributed(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return String.valueOf(this.getResource().isDerived());
        }
    }

    private static final class RawLocationURIAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "rawLocationURI";

        private RawLocationURIAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return this.getResource().getRawLocationURI() == null ? this.getResource().getLocationURI().toString() : this.getResource().getRawLocationURI().toString();
        }
    }

    private static final class RawLocationAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "rawLocation";

        private RawLocationAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return this.getResource().getRawLocation() == null ? this.getResource().getLocation().toString() : this.getResource().getRawLocation().toString();
        }
    }

    private static final class ProjectRelativePathAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "projectRelativePath";

        private ProjectRelativePathAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return this.getResource().getProjectRelativePath().toString();
        }
    }

    private static final class ProjectAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "project";

        private ProjectAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            IProject containingProject = this.getResource().getProject();
            return containingProject != null ? containingProject.getName() : "";
        }
    }

    private static final class NameAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "name";

        private NameAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return this.getResource().getName();
        }
    }

    private static final class ModificationStampAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "modificationStamp";

        private ModificationStampAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return String.valueOf(this.getResource().getModificationStamp());
        }
    }

    private static final class LocationURIAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "locationURI";

        private LocationURIAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return this.getResource().getLocationURI().toString();
        }
    }

    private static final class LocationAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "location";

        private LocationAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return this.getResource().getLocation().toString();
        }
    }

    private static final class LocalTimeStampAttribute
    extends AbstractResourceAttribute {
        private static final String ATTRIBUTE_NAME = "localTimeStamp";

        private LocalTimeStampAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return String.valueOf(this.getResource().getLocalTimeStamp());
        }
    }

    private static final class FullPathAttribute
    extends AbstractResourceAttribute {
        public static final String ATTRIBUTE_NAME = "fullPath";

        private FullPathAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            return this.getResource().getFullPath().toString();
        }
    }

    private static final class FileExtensionAttribute
    extends AbstractResourceAttribute {
        public static final String ATTRIBUTE_NAME = "fileExtension";

        private FileExtensionAttribute(IResource parent) {
            super(parent, ATTRIBUTE_NAME);
        }

        public String getStringValue() {
            String fileExtension = this.getResource().getFileExtension();
            return fileExtension == null ? "" : fileExtension;
        }
    }
}

