/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gef;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.runtime.lite.commands.WrappingCommand;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.gef.AbstractDiagramEditorTest;
import org.eclipse.gmf.tests.lite.setup.LibraryConstrainedSetup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExternalNodeLabelsTest
extends AbstractDiagramEditorTest {
    public ExternalNodeLabelsTest(String name) {
        super(name);
        PlatformUI.getWorkbench().getEditorRegistry();
        this.myDefaultSetup = LibraryConstrainedSetup.getInstance();
    }

    public void testExternalNodeLabelsPosition() throws Exception {
        GenNode nodeB = this.getSetup().getGenModel().getNodeB();
        GenExternalNodeLabel firstExternalNodeLabel = this.getFirstExternalNodeLabel(nodeB);
        ExternalNodeLabelsTest.assertNotNull((String)"Incorrect setup: expected ", (Object)firstExternalNodeLabel);
        Node nodeBInstance = this.createNode((GenCommonBase)nodeB, (View)this.getDiagram());
        View extLabelInstance = ExternalNodeLabelsTest.findChildView((View)nodeBInstance, (GenCommonBase)firstExternalNodeLabel);
        ExternalNodeLabelsTest.assertTrue((String)"External node label was not created automatically", (boolean)(extLabelInstance instanceof Node));
        GraphicalEditPart nodeBEP = (GraphicalEditPart)this.findEditPart((View)nodeBInstance);
        ExternalNodeLabelsTest.assertNotNull((Object)nodeBEP);
        GraphicalEditPart extLabelEP = (GraphicalEditPart)this.findEditPart(extLabelInstance);
        ExternalNodeLabelsTest.assertNotNull((Object)extLabelEP);
        ((GraphicalEditPart)this.getViewerConfiguration().getViewer().getRootEditPart()).getFigure().validate();
        this.checkExternalNodeLabelBounds(nodeBEP, extLabelEP);
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setMoveDelta(new Point(5, 5));
        req.setSizeDelta(new Dimension(7, 7));
        req.setEditParts((EditPart)nodeBEP);
        req.setResizeDirection(9);
        org.eclipse.gef.commands.Command cmd = nodeBEP.getCommand((Request)req);
        ExternalNodeLabelsTest.assertNotNull((String)"No resize command", (Object)cmd);
        ExternalNodeLabelsTest.assertTrue((String)"Can't execute resize command", (boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        ((GraphicalEditPart)this.getViewerConfiguration().getViewer().getRootEditPart()).getFigure().validate();
        this.checkExternalNodeLabelBounds(nodeBEP, extLabelEP);
        req.setMoveDelta(new Point(0, 0));
        req.setSizeDelta(new Dimension(7, 7));
        req.setEditParts((EditPart)nodeBEP);
        req.setResizeDirection(20);
        cmd = nodeBEP.getCommand((Request)req);
        ExternalNodeLabelsTest.assertNotNull((String)"No resize command", (Object)cmd);
        ExternalNodeLabelsTest.assertTrue((String)"Can't execute resize command", (boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        this.checkExternalNodeLabelBounds(nodeBEP, extLabelEP);
    }

    private void checkExternalNodeLabelBounds(GraphicalEditPart nodeEP, GraphicalEditPart extLabelEP) {
        Rectangle nodeBounds = nodeEP.getFigure().getBounds();
        Rectangle labelBounds = extLabelEP.getFigure().getBounds();
        Node extLabelNode = (Node)extLabelEP.getModel();
        Location location = (Location)extLabelNode.getLayoutConstraint();
        ExternalNodeLabelsTest.assertNotNull((String)"External label does not have layout constraint", (Object)location);
        Dimension tolerance = labelBounds.getSize().scale(0.3333333333333333);
        Point nodeBottom = nodeBounds.getBottom();
        Point labelTop = labelBounds.getTop();
        ExternalNodeLabelsTest.assertEquals((String)"Unexpected position of external node label", (float)(nodeBottom.x + location.getX()), (float)labelTop.x, (float)tolerance.width);
        ExternalNodeLabelsTest.assertEquals((String)"Unexpected position of external node label", (float)(nodeBottom.y + location.getY()), (float)labelTop.y, (float)tolerance.height);
    }

    private GenExternalNodeLabel getFirstExternalNodeLabel(GenNode genNode) {
        for (GenNodeLabel next : genNode.getLabels()) {
            if (!(next instanceof GenExternalNodeLabel)) continue;
            return (GenExternalNodeLabel)next;
        }
        return null;
    }

    public void testExternalNodeLabelsWithZoom() throws Exception {
        ZoomManager zoomManager = (ZoomManager)this.getDiagramEditPart().getViewer().getProperty(ZoomManager.class.toString());
        ExternalNodeLabelsTest.assertNotNull((Object)zoomManager);
        zoomManager.setZoom(4.0);
        this.testExternalNodeLabelsPosition();
    }

    public void testDefaultFont() throws Exception {
        IPreferenceStore preferenceStore;
        GenNode nodeB = this.getSetup().getGenModel().getNodeB();
        GenExternalNodeLabel firstExternalNodeLabel = this.getFirstExternalNodeLabel(nodeB);
        ExternalNodeLabelsTest.assertNotNull((String)"Incorrect setup: expected ", (Object)firstExternalNodeLabel);
        Node nodeBInstance = this.createNode((GenCommonBase)nodeB, (View)this.getDiagram());
        View extLabelInstance = ExternalNodeLabelsTest.findChildView((View)nodeBInstance, (GenCommonBase)firstExternalNodeLabel);
        ExternalNodeLabelsTest.assertTrue((String)"External node label was not created automatically", (boolean)(extLabelInstance instanceof Node));
        GraphicalEditPart nodeBEP = (GraphicalEditPart)this.findEditPart((View)nodeBInstance);
        ExternalNodeLabelsTest.assertNotNull((Object)nodeBEP);
        GraphicalEditPart extLabelEP = (GraphicalEditPart)this.findEditPart(extLabelInstance);
        ExternalNodeLabelsTest.assertNotNull((Object)extLabelEP);
        FontStyle style = (FontStyle)nodeBInstance.getStyle(NotationPackage.eINSTANCE.getFontStyle());
        ExternalNodeLabelsTest.assertNotNull((String)"Font style should not be null here", (Object)style);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)style);
        Command create = SetCommand.create((EditingDomain)domain, (Object)style, (Object)NotationPackage.eINSTANCE.getFontStyle_FontName(), null);
        this.execute((org.eclipse.gef.commands.Command)new WrappingCommand(domain, create));
        ExternalNodeLabelsTest.assertNull((String)"Command failed to execute", (Object)style.getFontName());
        try {
            Class activatorClazz = this.getSetup().loadGeneratedClass(this.getSetup().getGenModel().getGenDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName());
            AbstractUIPlugin pluginInstance = (AbstractUIPlugin)activatorClazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            preferenceStore = pluginInstance.getPreferenceStore();
        }
        catch (Throwable throwable) {
            ExternalNodeLabelsTest.fail((String)"Failed to obtain default preferences");
            return;
        }
        FontData[] defaultFont = PreferenceConverter.getFontDataArray((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
        String defaultName = defaultFont[0].getName();
        ExternalNodeLabelsTest.assertEquals((String)defaultName, (String)extLabelEP.getFigure().getFont().getFontData()[0].getName());
        FontData[] fonts = Display.getDefault().getFontList(null, true);
        ExternalNodeLabelsTest.assertTrue((fonts.length > 1 ? 1 : 0) != 0);
        int index = (int)(Math.random() * (double)fonts.length);
        while (fonts[index].getName().equals(defaultName)) {
            index = (int)(Math.random() * (double)fonts.length);
        }
        PreferenceConverter.setValue((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont", (FontData)fonts[index]);
        ExternalNodeLabelsTest.assertEquals((String)fonts[index].getName(), (String)extLabelEP.getFigure().getFont().getFontData()[0].getName());
    }
}

