/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.Arrays;
import org.eclipse.net4j.core.ClientChallengeNegotiator;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.core.NegotiationException;
import org.eclipse.net4j.core.impl.AbstractChallengeNegotiator;

public abstract class AbstractClientChallengeNegotiator
extends AbstractChallengeNegotiator
implements ClientChallengeNegotiator {
    public void negotiate(Connector connector) throws NegotiationException {
        byte[] result;
        ClientChallengeNegotiator.LoginCredentials credentials = this.getLoginCredentials();
        if (credentials == null) {
            throw new NegotiationException("Could not retrieve login credentials");
        }
        String userName = credentials.getUserName();
        char[] password = credentials.getPassword().toCharArray();
        if (this.isDebugEnabled()) {
            this.debug("Waiting for token...");
        }
        byte[] token = connector.receiveNegotiation();
        if (this.isDebugEnabled()) {
            this.debug("Received token");
        }
        byte[] cryptedToken = this.encrypt(token, password);
        byte[] loginBytes = userName.getBytes();
        if (this.isDebugEnabled()) {
            this.debug("Transmitting cryptedToken");
        }
        connector.transmitNegotiation(cryptedToken);
        if (this.isDebugEnabled()) {
            this.debug("Transmitting userName");
        }
        connector.transmitNegotiation(loginBytes);
        if (this.isDebugEnabled()) {
            this.debug("Waiting for result...");
        }
        if (!Arrays.equals(result = connector.receiveNegotiation(), NEGOTIATION_SUCCESS)) {
            if (this.isDebugEnabled()) {
                this.debug("Received failure");
            }
            throw new NegotiationException("User " + userName + " could not be authenticated");
        }
        if (this.isDebugEnabled()) {
            this.debug("Received success");
        }
        connector.setUserName(userName);
    }
}

