/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.sections;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.providers.TabbedPropertiesLabelProvider;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractListPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets.CSingleObjectChooser;
import org.eclipse.emf.ecoretools.tabbedproperties.utils.TextChangeListener;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EOperationParameterSection
extends AbstractListPropertySection {
    private Text parameterNameTxt;
    private CSingleObjectChooser typeChooser;
    private boolean isRefreshing = false;
    private Group groupDetails;

    protected void createWidgets(Composite composite) {
        super.createWidgets(composite);
        this.groupDetails = this.getWidgetFactory().createGroup(composite, Messages.EOperationParameterSection_ParameterDetails);
        this.groupDetails.setLayout((Layout)new GridLayout());
        this.createGroupContents((Composite)this.groupDetails);
    }

    protected void setSectionData(Composite composite) {
        super.setSectionData(composite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.getTable(), 4);
        this.groupDetails.setLayoutData((Object)data);
    }

    protected void createGroupContents(Composite parent) {
        TabbedPropertySheetWidgetFactory widgetFactory = this.getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        widgetFactory.createLabel(composite, Messages.EOperationParameterSection_Name);
        this.parameterNameTxt = widgetFactory.createText(composite, "", 2048);
        this.parameterNameTxt.setLayoutData((Object)new GridData(768));
        widgetFactory.createLabel(composite, Messages.EOperationParameterSection_Type);
        this.typeChooser = new CSingleObjectChooser(composite, this.getWidgetFactory(), 0);
        this.typeChooser.setLabelProvider((ILabelProvider)this.getLabelProvider());
        this.typeChooser.setSection((AbstractTabbedPropertySection)this);
        this.typeChooser.setLayoutData((Object)new GridData(768));
    }

    protected void hookListeners() {
        TextChangeListener parameterNameListener = new TextChangeListener(){

            public void textChanged(Control control) {
                String newText = EOperationParameterSection.this.parameterNameTxt.getText();
                EParameter parameter = (EParameter)EOperationParameterSection.this.getTable().getSelectionItem();
                if (parameter != null && !newText.equals(parameter.getName())) {
                    EOperationParameterSection.this.getEditingDomain().getCommandStack().execute(SetCommand.create((EditingDomain)EOperationParameterSection.this.getEditingDomain(), (Object)parameter, (Object)EcorePackage.Literals.ENAMED_ELEMENT__NAME, (Object)newText));
                }
                EOperationParameterSection.this.refresh();
            }
        };
        parameterNameListener.startListeningTo((Control)this.parameterNameTxt);
        parameterNameListener.startListeningForEnter((Control)this.parameterNameTxt);
        this.typeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EOperationParameterSection.this.handleComboModified();
            }
        });
    }

    protected void handleComboModified() {
        if (!this.isRefreshing && this.getParameterType() != this.typeChooser.getSelection()) {
            EditingDomain editingDomain = this.getEditingDomain();
            EParameter parameter = (EParameter)this.getTable().getSelectionItem();
            if (this.getEObjectList().size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)parameter, (Object)EcorePackage.Literals.ETYPED_ELEMENT__ETYPE, (Object)this.typeChooser.getSelection()));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.getEObjectList()) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)EcorePackage.Literals.ETYPED_ELEMENT__ETYPE, (Object)this.typeChooser.getSelection()));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new TabbedPropertiesLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory());
    }

    protected Object getListValues() {
        return ((EOperation)this.getEObject()).getEParameters();
    }

    protected EStructuralFeature getFeature() {
        return EcorePackage.Literals.EOPERATION__EPARAMETERS;
    }

    protected String getLabelText() {
        return Messages.EOperationParameterSection_Parameters;
    }

    public void refresh() {
        this.isRefreshing = true;
        super.refresh();
        this.typeChooser.setChoices(this.getComboFeatureValues());
        this.typeChooser.setSelection(this.getParameterType());
        EParameter parameter = (EParameter)this.getTable().getSelectionItem();
        String nameToDisplay = this.getEParameterName(parameter);
        this.parameterNameTxt.setText(nameToDisplay);
        this.isRefreshing = false;
    }

    public void updateSelection(Object data) {
        if (data instanceof EParameter) {
            EParameter parameter = (EParameter)data;
            String nameToDisplay = this.getEParameterName(parameter);
            this.parameterNameTxt.setText(nameToDisplay);
            this.typeChooser.setSelection(this.getParameterType());
        }
    }

    private String getEParameterName(EParameter parameter) {
        return parameter == null ? "" : (parameter.getName() != null ? parameter.getName() : "");
    }

    private Object[] getComboFeatureValues() {
        for (Adapter adapter : this.getEObject().eAdapters()) {
            IItemPropertyDescriptor descriptor;
            if (!(adapter instanceof ItemProviderAdapter) || (descriptor = ((ItemProviderAdapter)adapter).getPropertyDescriptor((Object)this.getEObject(), (Object)EcorePackage.Literals.ETYPED_ELEMENT__ETYPE.getName())) == null) continue;
            return descriptor.getChoiceOfValues((Object)this.getEObject()).toArray();
        }
        return new String[]{""};
    }

    private Object getParameterType() {
        EParameter parameter = (EParameter)this.getTable().getSelectionItem();
        if (parameter != null) {
            return parameter.getEType();
        }
        return null;
    }
}

