/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.diff.api.IDiffEngine;
import org.eclipse.emf.compare.diff.engine.GenericDiffEngine;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffExtensionDescriptor;
import org.eclipse.emf.compare.diff.service.EngineDescriptor;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.util.EMFCompareMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffService {
    private static final String ALL_EXTENSIONS = "*";
    private static final String DEFAULT_EXTENSION = "ecore";
    private static final String DIFF_ENGINES_EXTENSION_POINT = "org.eclipse.emf.compare.diff.engine";
    private static final Map<String, ArrayList<DiffExtensionDescriptor>> PARSED_DIFF_EXTENSIONS = new EMFCompareMap();
    private static final Map<String, ArrayList<EngineDescriptor>> PARSED_ENGINES = new EMFCompareMap();
    private static final String TAG_DIFF_EXTENSION = "diff_extension";
    private static final String TAG_ENGINE = "diffengine";

    static {
        DiffService.parseExtensionMetadata();
    }

    private DiffService() {
    }

    public static DiffModel doDiff(MatchModel match) {
        return DiffService.doDiff(match, false);
    }

    public static DiffModel doDiff(MatchModel match, boolean threeWay) {
        String extension = DEFAULT_EXTENSION;
        if (match.getLeftModel() != null && match.getLeftModel().lastIndexOf(46) > 0) {
            extension = match.getLeftModel().substring(match.getLeftModel().lastIndexOf(46) + 1);
        }
        IDiffEngine engine = DiffService.getBestDiffEngine(extension);
        DiffModel diff = engine.doDiff(match, threeWay);
        Collection<AbstractDiffExtension> extensions = DiffService.getCorrespondingDiffExtensions(extension);
        for (AbstractDiffExtension ext : extensions) {
            if (ext == null) continue;
            ext.visit(diff);
        }
        return diff;
    }

    public static IDiffEngine getBestDiffEngine(String extension) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            EngineDescriptor desc = DiffService.getBestDescriptor(extension);
            return desc.getEngineInstance();
        }
        return new GenericDiffEngine();
    }

    public static Collection<AbstractDiffExtension> getCorrespondingDiffExtensions(String extension) {
        ArrayList<AbstractDiffExtension> result = new ArrayList<AbstractDiffExtension>();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            Collection descs;
            if (PARSED_DIFF_EXTENSIONS.containsKey(ALL_EXTENSIONS)) {
                for (DiffExtensionDescriptor extensionDesc : PARSED_DIFF_EXTENSIONS.get(ALL_EXTENSIONS)) {
                    result.add(extensionDesc.getDiffExtensionInstance());
                }
            }
            if ((descs = (Collection)PARSED_DIFF_EXTENSIONS.get(extension)) != null) {
                for (DiffExtensionDescriptor desc : descs) {
                    result.add(desc.getDiffExtensionInstance());
                }
            }
        }
        return result;
    }

    private static EngineDescriptor getBestDescriptor(String extension) {
        EngineDescriptor descriptor = null;
        if (PARSED_ENGINES.containsKey(extension)) {
            descriptor = DiffService.getHighestDescriptor((List<EngineDescriptor>)PARSED_ENGINES.get(extension));
        } else if (PARSED_ENGINES.containsKey(ALL_EXTENSIONS)) {
            descriptor = DiffService.getHighestDescriptor((List<EngineDescriptor>)PARSED_ENGINES.get(ALL_EXTENSIONS));
        }
        return descriptor;
    }

    private static EngineDescriptor getHighestDescriptor(List<EngineDescriptor> set) {
        Collections.sort(set, Collections.reverseOrder());
        if (set.size() > 0) {
            return set.get(0);
        }
        return null;
    }

    private static DiffExtensionDescriptor parseDiffExtension(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_DIFF_EXTENSION)) {
            return null;
        }
        DiffExtensionDescriptor desc = new DiffExtensionDescriptor(configElement);
        return desc;
    }

    private static EngineDescriptor parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        EngineDescriptor desc = new EngineDescriptor(configElement);
        return desc;
    }

    private static void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            Object desc;
            int j;
            IConfigurationElement[] configElements;
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(DIFF_ENGINES_EXTENSION_POINT).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                configElements = extensions[i].getConfigurationElements();
                j = 0;
                while (j < configElements.length) {
                    desc = DiffService.parseEngine(configElements[j]);
                    DiffService.storeEngineDescriptor((EngineDescriptor)desc);
                    ++j;
                }
                ++i;
            }
            extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.compare.diff", TAG_DIFF_EXTENSION).getExtensions();
            i = 0;
            while (i < extensions.length) {
                configElements = extensions[i].getConfigurationElements();
                j = 0;
                while (j < configElements.length) {
                    desc = DiffService.parseDiffExtension(configElements[j]);
                    DiffService.storeDiffExtensionDescriptor((DiffExtensionDescriptor)desc);
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void storeDiffExtensionDescriptor(DiffExtensionDescriptor desc) {
        String[] extensions;
        if (desc.getFileExtension() == null) {
            return;
        }
        String[] stringArray = extensions = desc.getFileExtension().split(",");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String engineExtension = stringArray[n2];
            if (!PARSED_DIFF_EXTENSIONS.containsKey(engineExtension)) {
                PARSED_DIFF_EXTENSIONS.put(engineExtension, new ArrayList());
            }
            List set = PARSED_DIFF_EXTENSIONS.get(engineExtension);
            set.add(desc);
            ++n2;
        }
    }

    private static void storeEngineDescriptor(EngineDescriptor desc) {
        String[] extensions;
        if (desc.getFileExtension() == null) {
            return;
        }
        String[] stringArray = extensions = desc.getFileExtension().split(",");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String engineExtension = stringArray[n2];
            if (!PARSED_ENGINES.containsKey(engineExtension)) {
                PARSED_ENGINES.put(engineExtension, new ArrayList());
            }
            List set = PARSED_ENGINES.get(engineExtension);
            set.add(desc);
            ++n2;
        }
    }
}

