/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.CDOFetchRule;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.internal.cdo.session.CDORevisionManagerImpl;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadRevisionRequest
extends CDOClientRequest<List<InternalCDORevision>> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionRequest.class);
    private Collection<CDOID> ids;
    private int referenceChunk;

    public LoadRevisionRequest(CDOClientProtocol protocol, Collection<CDOID> ids, int referenceChunk) {
        this(protocol, 7, ids, referenceChunk);
    }

    public LoadRevisionRequest(CDOClientProtocol protocol, short signalID, Collection<CDOID> ids, int referenceChunk) {
        super(protocol, signalID);
        this.ids = ids;
        this.referenceChunk = referenceChunk;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing referenceChunk: {0}", new Object[]{this.referenceChunk});
        }
        out.writeInt(this.referenceChunk);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} IDs", new Object[]{this.ids.size()});
        }
        out.writeInt(this.ids.size());
        for (CDOID id : this.ids) {
            if (TRACER.isEnabled()) {
                TRACER.format("Writing ID: {0}", new Object[]{id});
            }
            out.writeCDOID(id);
        }
        CDORevisionManagerImpl revisionManager = (CDORevisionManagerImpl)this.getSession().getRevisionManager();
        CDOFetchRuleManager ruleManager = revisionManager.getRuleManager();
        List<CDOFetchRule> fetchRules = ruleManager.getFetchRules(this.ids);
        if (fetchRules == null || fetchRules.size() <= 0) {
            out.writeInt(0);
        } else {
            int fetchSize = fetchRules.size();
            CDOID contextID = ruleManager.getContext();
            out.writeInt(fetchSize);
            out.writeInt(ruleManager.getCollectionLoadingPolicy().getInitialChunkSize());
            out.writeCDOID(contextID);
            for (CDOFetchRule fetchRule : fetchRules) {
                fetchRule.write(out);
            }
        }
    }

    @Override
    protected List<InternalCDORevision> confirming(CDODataInput in) throws IOException {
        int idSize = this.ids.size();
        ArrayList<InternalCDORevision> revisions = new ArrayList<InternalCDORevision>(idSize);
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} revisions", new Object[]{idSize});
        }
        int i = 0;
        while (i < idSize) {
            InternalCDORevision revision = (InternalCDORevision)in.readCDORevision();
            revisions.add(revision);
            ++i;
        }
        int additionalSize = in.readInt();
        if (additionalSize != 0) {
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} additional revisions", new Object[]{additionalSize});
            }
            CDORevisionManagerImpl revisionManager = (CDORevisionManagerImpl)this.getSession().getRevisionManager();
            int i2 = 0;
            while (i2 < additionalSize) {
                InternalCDORevision revision = (InternalCDORevision)in.readCDORevision();
                if (revision != null) {
                    revisionManager.addCachedRevision(revision);
                }
                ++i2;
            }
        }
        return revisions;
    }

    public Collection<CDOID> getIds() {
        return this.ids;
    }

    public int getReferenceChunk() {
        return this.referenceChunk;
    }

    public String toString() {
        return MessageFormat.format("{0}(ids={1}, referenceChunk={2})", ((Object)((Object)this)).getClass().getSimpleName(), this.ids, this.referenceChunk);
    }
}

