/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.eclipse.microprofile.openapi.tck.AppTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapWithSize;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class OASConfigSchemaTest
extends AppTestBase {
    @Deployment(name="petstore", testable=false)
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"petstore.war")).addPackages(true, new String[]{"org.eclipse.microprofile.openapi.apps.petstore"})).addAsWebInfResource("schema-microprofile-config.properties", "classes/META-INF/microprofile-config.properties");
    }

    @Test(dataProvider="formatProvider")
    public void testSchemaConfigApplied(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("components.schemas.EpochSeconds", this.epochSecondsSchema(), new Object[0]);
        vr.body("components.schemas.Lizard.properties.birthInstant", (Matcher)Matchers.anyOf(this.epochSecondsSchema(), this.epochSecondsRef()), new Object[0]);
    }

    private Matcher<Map<? extends String, ? extends String>> epochSecondsSchema() {
        return Matchers.allOf((Matcher)IsMapWithSize.aMapWithSize((int)4), (Matcher)Matchers.hasEntry((Object)"title", (Object)"Epoch Seconds"), (Matcher)Matchers.hasEntry((Object)"type", (Object)"number"), (Matcher)Matchers.hasEntry((Object)"format", (Object)"int64"), (Matcher)Matchers.hasEntry((Object)"description", (Object)"Number of seconds from the epoch of 1970-01-01T00:00:00Z"));
    }

    private Matcher<Map<? extends String, ? extends String>> epochSecondsRef() {
        return Matchers.allOf((Matcher)IsMapWithSize.aMapWithSize((int)1), (Matcher)Matchers.hasEntry((Object)"$ref", (Object)"#/components/schemas/EpochSeconds"));
    }
}

