/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.util;

import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jface.viewers.LabelProvider;

public class EnumerationLabelProvider<T extends Enum<T>>
extends LabelProvider {
    private Class<T> type;
    private Map<T, String> labels;

    private EnumerationLabelProvider(Class<T> type) {
        this.type = type;
        this.labels = new EnumMap<T, String>(type);
    }

    public static <T extends Enum<T>> EnumerationLabelProvider<T> of(Class<T> type) {
        return new EnumerationLabelProvider<T>(type);
    }

    public EnumerationLabelProvider<T> label(T value, String label) {
        this.labels.put(value, label);
        return this;
    }

    public EnumerationLabelProvider<T> labels(String ... label) {
        Enum[] values = (Enum[])this.type.getEnumConstants();
        int i = 0;
        while (i < values.length && i < label.length) {
            if (label != null) {
                this.labels.put(values[i], label[i]);
            }
            ++i;
        }
        return this;
    }

    public String getText(Object element) {
        String result = this.labels.get(element);
        if (result == null) {
            result = super.getText(element);
        }
        return result;
    }
}

