/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.ui.actions.UML2AbstractAction;
import org.eclipse.mdht.uml.ui.internal.Logger;
import org.eclipse.mdht.uml.ui.internal.l10n.UML2UIMessages;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Stereotype;

public class AddUMLConstraintAction
extends UML2AbstractAction {
    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.isReadOnly()) {
            action.setEnabled(false);
        }
    }

    public void run(IAction action) {
        try {
            final Element element = this.getSelectedElement();
            if (element != null) {
                AbstractEMFOperation operation = new AbstractEMFOperation(this.editingDomain, UML2UIMessages.AddUMLConstraint_operation_title){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                        Constraint constraint = null;
                        if (element instanceof Namespace) {
                            constraint = ((Namespace)element).createOwnedRule(null);
                        } else if (element.getOwner() instanceof Namespace) {
                            Namespace ns = (Namespace)element.getOwner();
                            constraint = ns.createOwnedRule(null);
                            if (element instanceof NamedElement) {
                                constraint.setName(((NamedElement)element).getName());
                            }
                        }
                        constraint.getConstrainedElements().add((Object)element);
                        AddUMLConstraintAction.this.handleDefaultStereotypes(constraint);
                        if (AddUMLConstraintAction.this.activePart instanceof ISetSelectionTarget) {
                            ((ISetSelectionTarget)AddUMLConstraintAction.this.activePart).selectReveal((ISelection)new StructuredSelection((Object)constraint));
                        }
                        return Status.OK_STATUS;
                    }
                };
                try {
                    IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)this.editingDomain.getCommandStack();
                    operation.addContext(commandStack.getDefaultUndoContext());
                    commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.activePart);
                }
                catch (ExecutionException ee) {
                    Logger.logException(ee);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void handleDefaultStereotypes(Constraint constraint) {
        EObject instance;
        EStructuralFeature code;
        Stereotype diagnostic = constraint.getApplicableStereotype("Validation::Diagnostic");
        if (diagnostic != null && (code = (instance = constraint.applyStereotype(diagnostic)).eClass().getEStructuralFeature("code")) != null) {
            instance.eUnset(code);
        }
    }
}

