/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import traceability.LogEntry;
import traceability.Traces;
import traceability.presentation.GroupOrganizer;
import traceability.presentation.TraceabilityEditor;
import traceability.presentation.Tracing;
import traceability.presentation.table.TraceabilityViewer;
import traceability.presentation.table.TracebilityColumn;

public class ReflectiveTraceabilityEditor
extends TraceabilityEditor {
    private static final String COLUMN_NAMESPACE = "trace";
    protected static XViewerColumn FanOut_Col = new TracebilityColumn("trace.fanout", "Fan-Out Element", 350, XViewerAlign.Left, true, SortDataType.String, false, null);
    protected static XViewerColumn Error_Col = new TracebilityColumn("trace.error", "Error", 400, XViewerAlign.Left, true, SortDataType.String, false, null);
    protected static XViewerColumn ErrorCode_Col = new TracebilityColumn("trace.errorcode", "Code", 40, XViewerAlign.Left, true, SortDataType.Integer, false, null);
    protected List<XViewerColumn> dynamicColumns = new ArrayList<XViewerColumn>();
    protected Map<XViewerColumn, EObject> modelOfColumn = new HashMap<XViewerColumn, EObject>();

    @Override
    protected void createViews() {
        ArrayList<XViewerColumn> overviewColumns = new ArrayList<XViewerColumn>(this.getAllColumns());
        overviewColumns.remove(FanOut_Col);
        this.createView("Overview", -1, "OverviewTable", overviewColumns.toArray(new XViewerColumn[0]));
        for (XViewerColumn col : this.dynamicColumns) {
            ArrayList<XViewerColumn> cols = new ArrayList<XViewerColumn>(this.getAllColumns());
            cols.remove(col);
            cols.remove(FanOut_Col);
            cols.add(0, col);
            this.createView(String.valueOf(col.getDisplayName()) + " Tree", 3, null, cols.toArray(new XViewerColumn[0]));
        }
        this.createView("Fan-Out", 3, "FanOutViewTable", this.getAllColumns().toArray(new XViewerColumn[0]));
    }

    @Override
    public String getNamespace() {
        return COLUMN_NAMESPACE;
    }

    @Override
    protected void organizeTreeForColumn(XViewerColumn column, List<Object> parents) {
        if (column == FanOut_Col) {
            GroupOrganizer.organizeTreeByFanOut(parents, this.tracing);
        } else {
            GroupOrganizer.organizeTreeByContainment(parents, this.tracing, this.modelOfColumn.get(column));
        }
    }

    @Override
    protected List<XViewerColumn> getAllColumns() {
        if (this.dynamicColumns.isEmpty()) {
            this.getOrCreateTracing();
            HashSet<EObject> handledModels = new HashSet<EObject>();
            for (EObject model : this.tracing.sourceModels) {
                while (model != null && handledModels.add(model)) {
                    this.createDynamicColumn(model);
                    int index = this.tracing.sourceModels.indexOf(model);
                    if (index == -1) continue;
                    model = this.tracing.targetModels.get(index);
                }
            }
            for (EObject model : this.tracing.targetModels) {
                if (model == null || !handledModels.add(model)) continue;
                this.createDynamicColumn(model);
            }
        }
        ArrayList<XViewerColumn> result = new ArrayList<XViewerColumn>(this.dynamicColumns);
        result.add(0, FanOut_Col);
        result.add(Error_Col);
        result.add(ErrorCode_Col);
        return result;
    }

    @Override
    public XViewerColumn getRedirectedColumn(Object element, XViewerColumn xCol) {
        if (xCol.equals((Object)FanOut_Col)) {
            EObject model = this.tracing.modelOfElement.get(element);
            for (XViewerColumn col : this.getAllColumns()) {
                if (model != this.modelOfColumn.get(col)) continue;
                return col;
            }
        }
        return xCol;
    }

    @Override
    public List<XViewerColumn> excludedColsFromDiffing() {
        return Arrays.asList(FanOut_Col);
    }

    @Override
    public List<XViewerColumn> alwaysPrintColumns() {
        return Arrays.asList(Error_Col, ErrorCode_Col);
    }

    @Override
    public String getLabel(Object element, XViewerColumn xCol, int columnIndex) {
        EObject eObject;
        Adapter provider;
        LogEntry error;
        if (xCol.equals((Object)Error_Col) && (error = this.tracing.getError(element)) != null) {
            return String.valueOf(error.getMessage()) + (this.tracing.getErrors(element).size() >= 2 ? "..." : "");
        }
        if (xCol.equals((Object)ErrorCode_Col) && (error = this.tracing.getError(element)) != null) {
            return "" + error.getMessageType();
        }
        Object cellData = this.getCellData(xCol, element);
        if (cellData instanceof EObject && (provider = this.adapterFactory.adapt((Notifier)(eObject = (EObject)cellData), IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            IItemLabelProvider iItemLabelProvider = (IItemLabelProvider)provider;
            return iItemLabelProvider.getText((Object)eObject);
        }
        return null;
    }

    @Override
    public String adjustStyledText(XViewerColumn col, Object element, String text) {
        Object cellData = this.getCellData(col, element);
        if (cellData instanceof EObject && ((EObject)cellData).eIsProxy()) {
            return text;
        }
        return text.replace("<", "&lt;").replace(">", "&gt;");
    }

    @Override
    public Object getCellData(XViewerColumn viewerColumn, Object element) {
        element = TraceabilityViewer.getRedirectedElement(element);
        if (viewerColumn.equals((Object)Error_Col)) {
            return this.tracing.getError(element);
        }
        EObject model = this.modelOfColumn.get(viewerColumn);
        if (model != null && element instanceof EObject) {
            EObject eObject = (EObject)element;
            return this.tracing.findModel(model, eObject);
        }
        return null;
    }

    private void createDynamicColumn(EObject model) {
        String name = new ReflectiveItemProvider(null).getText((Object)model);
        if (name == null) {
            name = model.toString();
        }
        TracebilityColumn col = new TracebilityColumn(String.valueOf(this.getNamespace()) + "." + name, name, 200, XViewerAlign.Left, true, SortDataType.String, false, null);
        this.dynamicColumns.add(col);
        this.modelOfColumn.put(col, model);
    }

    public String getName(Object namedObject) {
        try {
            Method m = namedObject.getClass().getMethod("getName", new Class[0]);
            return (String)m.invoke(namedObject, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected Tracing createTracing() {
        Tracing result = super.createTracing();
        for (LogEntry logEntry : result.errorsRev.keySet()) {
            Traces traces = result.getTraceContainer((EObject)logEntry);
            for (EObject eObject : logEntry.getParticipants()) {
                result.goForward(null, null, result.rows, eObject, null);
                if (traces == null) continue;
                result.modelOfElement.put(eObject, traces.getSourceModel());
            }
        }
        return result;
    }

    @Override
    public boolean isErrorCol(XViewerColumn xCol) {
        return xCol.equals((Object)Error_Col);
    }
}

