/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValidationKind implements Enumerator
{
    OPEN(0, "OPEN", "OPEN"),
    CLOSED(1, "CLOSED", "CLOSED");

    public static final int OPEN_VALUE = 0;
    public static final int CLOSED_VALUE = 1;
    private static final ValidationKind[] VALUES_ARRAY;
    public static final List<ValidationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValidationKind[]{OPEN, CLOSED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValidationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValidationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValidationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValidationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValidationKind get(int value) {
        switch (value) {
            case 0: {
                return OPEN;
            }
            case 1: {
                return CLOSED;
            }
        }
        return null;
    }

    private ValidationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

