/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.properties.internal.sections;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.ui.properties.sections.WrapperAwareModelerPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class PropertyDefaultSection
extends WrapperAwareModelerPropertySection {
    private Property property;
    private Text defaultValueText;
    private CCombo defaultValueCombo;
    private boolean defaultValueModified = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (PropertyDefaultSection.this.defaultValueText == event.getSource()) {
                PropertyDefaultSection.this.defaultValueModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                PropertyDefaultSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            PropertyDefaultSection.this.modifyFields();
        }
    };

    private void modifyFields() {
        if (!this.defaultValueModified) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (PropertyDefaultSection.this.defaultValueModified) {
                        PropertyDefaultSection.this.defaultValueModified = false;
                        this.setLabel("Set Default Value");
                        if (PropertyDefaultSection.this.property.getDefaultValue() != null) {
                            PropertyDefaultSection.this.property.getDefaultValue().destroy();
                        }
                        String newValue = null;
                        newValue = PropertyDefaultSection.this.property.getType() instanceof Enumeration ? PropertyDefaultSection.this.defaultValueCombo.getText() : PropertyDefaultSection.this.defaultValueText.getText();
                        if (newValue != null && newValue.trim().length() > 0) {
                            LiteralString literal = UMLFactory.eINSTANCE.createLiteralString();
                            literal.setValue(newValue);
                            PropertyDefaultSection.this.property.setDefaultValue((ValueSpecification)literal);
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        this.defaultValueCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        this.defaultValueCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertyDefaultSection.this.defaultValueModified = true;
                PropertyDefaultSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyDefaultSection.this.defaultValueModified = true;
                PropertyDefaultSection.this.modifyFields();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment(30, 0);
        data.top = new FormAttachment(0, 1);
        this.defaultValueCombo.setLayoutData((Object)data);
        this.defaultValueText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.right = new FormAttachment(70, 0);
        data.top = new FormAttachment(0, 1);
        this.defaultValueText.setLayoutData((Object)data);
        CLabel defaultValueLabel = this.getWidgetFactory().createCLabel(composite, "Default Value:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.defaultValueCombo, -5);
        data.top = new FormAttachment((Control)this.defaultValueCombo, 0, 0x1000000);
        defaultValueLabel.setLayoutData((Object)data);
    }

    @Override
    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.property != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.property)) != null && editingDomain.isReadOnly(this.property.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        if (element instanceof View) {
            element = ((View)element).getElement();
        }
        if (element instanceof Association) {
            element = UMLUtil.getNavigableEnd((Association)((Association)element));
        }
        this.property = element instanceof Property ? (Property)element : null;
    }

    public void dispose() {
        super.dispose();
        this.property = null;
    }

    public void refresh() {
        String defaultValue = "";
        if (this.property.getDefaultValue() != null && this.property.getDefaultValue().stringValue() != null) {
            defaultValue = this.property.getDefaultValue().stringValue();
        }
        if (this.property.getType() instanceof Enumeration) {
            EList literals = ((Enumeration)this.property.getType()).getOwnedLiterals();
            String[] literalLabels = new String[literals.size()];
            int i = 0;
            while (i < literals.size()) {
                literalLabels[i] = ((EnumerationLiteral)literals.get(i)).getName();
                ++i;
            }
            this.defaultValueCombo.setItems(literalLabels);
            this.defaultValueCombo.setText(defaultValue);
            this.defaultValueText.setVisible(false);
            this.defaultValueCombo.setVisible(true);
        } else {
            this.defaultValueText.removeModifyListener(this.modifyListener);
            this.defaultValueText.removeKeyListener(this.keyListener);
            this.defaultValueText.removeFocusListener(this.focusListener);
            if (this.property.getType() == null) {
                this.defaultValueText.setEditable(false);
            } else {
                this.defaultValueText.setEditable(true);
            }
            this.defaultValueText.setText(defaultValue);
            this.defaultValueText.addModifyListener(this.modifyListener);
            this.defaultValueText.addKeyListener(this.keyListener);
            this.defaultValueText.addFocusListener(this.focusListener);
            this.defaultValueCombo.setVisible(false);
            this.defaultValueText.setVisible(true);
        }
        if (this.isReadOnly()) {
            this.defaultValueText.setEnabled(false);
            this.defaultValueCombo.setEnabled(false);
        } else {
            this.defaultValueText.setEnabled(true);
            this.defaultValueCombo.setEnabled(true);
        }
    }

    public void update(final Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!PropertyDefaultSection.this.isDisposed() && !PropertyDefaultSection.this.isNotifierDeleted(notification)) {
                        PropertyDefaultSection.this.refresh();
                    }
                }
            });
        }
    }
}

