/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.core.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StatusKind implements Enumerator
{
    ACTIVE(0, "Active", "Active"),
    INACTIVE(1, "Inactive", "Inactive");

    public static final int ACTIVE_VALUE = 0;
    public static final int INACTIVE_VALUE = 1;
    private static final StatusKind[] VALUES_ARRAY;
    public static final List<StatusKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StatusKind[]{ACTIVE, INACTIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StatusKind get(int value) {
        switch (value) {
            case 0: {
                return ACTIVE;
            }
            case 1: {
                return INACTIVE;
            }
        }
        return null;
    }

    public static StatusKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StatusKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StatusKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StatusKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private StatusKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

