(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver-types", "dockerfile-ast"], factory);
    }
})(function (require, exports) {
    /* --------------------------------------------------------------------------------------------
     * Copyright (c) Remy Suen. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     * ------------------------------------------------------------------------------------------ */
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DockerLinks = void 0;
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var dockerfile_ast_1 = require("dockerfile-ast");
    var DockerLinks = /** @class */ (function () {
        function DockerLinks() {
        }
        DockerLinks.prototype.getLinks = function (content) {
            var dockerfile = dockerfile_ast_1.DockerfileParser.parse(content);
            var links = [];
            var stages = dockerfile.getFROMs().reduce(function (accumulator, from) {
                var stage = from.getBuildStage();
                if (stage !== null) {
                    accumulator.push(stage);
                }
                return accumulator;
            }, []);
            for (var _i = 0, _a = dockerfile.getFROMs(); _i < _a.length; _i++) {
                var from = _a[_i];
                var name = from.getImageName();
                var registry = from.getRegistry();
                if (registry === "ghcr.io") {
                    var idx = name.lastIndexOf("/");
                    if (idx === -1) {
                        continue;
                    }
                    links.push({
                        range: vscode_languageserver_types_1.Range.create(from.getRegistryRange().start, from.getImageNameRange().end),
                        target: "https://github.com/".concat(name, "/pkgs/container/").concat(name.substring(idx + 1))
                    });
                    continue;
                }
                if (registry === "mcr.microsoft.com") {
                    links.push({
                        range: vscode_languageserver_types_1.Range.create(from.getRegistryRange().start, from.getImageNameRange().end),
                        target: "https://mcr.microsoft.com/artifact/mar/" + name
                    });
                    continue;
                }
                if (registry === "quay.io") {
                    links.push({
                        range: vscode_languageserver_types_1.Range.create(from.getRegistryRange().start, from.getImageNameRange().end),
                        target: "https://quay.io/repository/" + name
                    });
                    continue;
                }
                if (name !== null && stages.indexOf(name) === -1) {
                    if (name.indexOf('/') === -1) {
                        links.push({
                            range: from.getImageNameRange(),
                            data: "_/" + name + '/'
                        });
                    }
                    else {
                        links.push({
                            range: from.getImageNameRange(),
                            data: "r/" + name + '/'
                        });
                    }
                }
            }
            return links;
        };
        DockerLinks.prototype.resolveLink = function (link) {
            if (link.data) {
                link.target = "https://hub.docker.com/" + link.data;
            }
            return link;
        };
        return DockerLinks;
    }());
    exports.DockerLinks = DockerLinks;
});
