/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.AttachedNetwork;

final class ImmutableAttachedNetwork
implements AttachedNetwork {
    @Nullable
    private final List<String> aliases;
    @Nullable
    private final String networkId;
    private final String endpointId;
    private final String gateway;
    private final String ipAddress;
    private final Integer ipPrefixLen;
    private final String ipv6Gateway;
    private final String globalIPv6Address;
    private final Integer globalIPv6PrefixLen;
    private final String macAddress;

    private ImmutableAttachedNetwork(@Nullable List<String> aliases, @Nullable String networkId, String endpointId, String gateway, String ipAddress, Integer ipPrefixLen, String ipv6Gateway, String globalIPv6Address, Integer globalIPv6PrefixLen, String macAddress) {
        this.aliases = aliases;
        this.networkId = networkId;
        this.endpointId = endpointId;
        this.gateway = gateway;
        this.ipAddress = ipAddress;
        this.ipPrefixLen = ipPrefixLen;
        this.ipv6Gateway = ipv6Gateway;
        this.globalIPv6Address = globalIPv6Address;
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
        this.macAddress = macAddress;
    }

    @Override
    @JsonProperty(value="Aliases")
    @Nullable
    public List<String> aliases() {
        return this.aliases;
    }

    @Override
    @JsonProperty(value="NetworkID")
    @Nullable
    public String networkId() {
        return this.networkId;
    }

    @Override
    @JsonProperty(value="EndpointID")
    public String endpointId() {
        return this.endpointId;
    }

    @Override
    @JsonProperty(value="Gateway")
    public String gateway() {
        return this.gateway;
    }

    @Override
    @JsonProperty(value="IPAddress")
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    @JsonProperty(value="IPPrefixLen")
    public Integer ipPrefixLen() {
        return this.ipPrefixLen;
    }

    @Override
    @JsonProperty(value="IPv6Gateway")
    public String ipv6Gateway() {
        return this.ipv6Gateway;
    }

    @Override
    @JsonProperty(value="GlobalIPv6Address")
    public String globalIPv6Address() {
        return this.globalIPv6Address;
    }

    @Override
    @JsonProperty(value="GlobalIPv6PrefixLen")
    public Integer globalIPv6PrefixLen() {
        return this.globalIPv6PrefixLen;
    }

    @Override
    @JsonProperty(value="MacAddress")
    public String macAddress() {
        return this.macAddress;
    }

    public final ImmutableAttachedNetwork withAliases(String ... elements) {
        if (elements == null) {
            return new ImmutableAttachedNetwork(null, this.networkId, this.endpointId, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableAttachedNetwork.createUnmodifiableList(false, ImmutableAttachedNetwork.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAttachedNetwork(newValue, this.networkId, this.endpointId, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableAttachedNetwork withAliases(@Nullable Iterable<String> elements) {
        if (this.aliases == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableAttachedNetwork.createUnmodifiableList(false, ImmutableAttachedNetwork.createSafeList(elements, true, false));
        return new ImmutableAttachedNetwork(newValue, this.networkId, this.endpointId, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableAttachedNetwork withNetworkId(@Nullable String value) {
        if (Objects.equals(this.networkId, value)) {
            return this;
        }
        return new ImmutableAttachedNetwork(this.aliases, value, this.endpointId, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableAttachedNetwork withEndpointId(String value) {
        String newValue = Objects.requireNonNull(value, "endpointId");
        if (this.endpointId.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachedNetwork(this.aliases, this.networkId, newValue, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableAttachedNetwork withGateway(String value) {
        String newValue = Objects.requireNonNull(value, "gateway");
        if (this.gateway.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachedNetwork(this.aliases, this.networkId, this.endpointId, newValue, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableAttachedNetwork withIpAddress(String value) {
        String newValue = Objects.requireNonNull(value, "ipAddress");
        if (this.ipAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachedNetwork(this.aliases, this.networkId, this.endpointId, this.gateway, newValue, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableAttachedNetwork withIpPrefixLen(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "ipPrefixLen");
        if (this.ipPrefixLen.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachedNetwork(this.aliases, this.networkId, this.endpointId, this.gateway, this.ipAddress, newValue, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableAttachedNetwork withIpv6Gateway(String value) {
        String newValue = Objects.requireNonNull(value, "ipv6Gateway");
        if (this.ipv6Gateway.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachedNetwork(this.aliases, this.networkId, this.endpointId, this.gateway, this.ipAddress, this.ipPrefixLen, newValue, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableAttachedNetwork withGlobalIPv6Address(String value) {
        String newValue = Objects.requireNonNull(value, "globalIPv6Address");
        if (this.globalIPv6Address.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachedNetwork(this.aliases, this.networkId, this.endpointId, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, newValue, this.globalIPv6PrefixLen, this.macAddress);
    }

    public final ImmutableAttachedNetwork withGlobalIPv6PrefixLen(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "globalIPv6PrefixLen");
        if (this.globalIPv6PrefixLen.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachedNetwork(this.aliases, this.networkId, this.endpointId, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, newValue, this.macAddress);
    }

    public final ImmutableAttachedNetwork withMacAddress(String value) {
        String newValue = Objects.requireNonNull(value, "macAddress");
        if (this.macAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableAttachedNetwork(this.aliases, this.networkId, this.endpointId, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttachedNetwork && this.equalTo(0, (ImmutableAttachedNetwork)another);
    }

    private boolean equalTo(int synthetic, ImmutableAttachedNetwork another) {
        return Objects.equals(this.aliases, another.aliases) && Objects.equals(this.networkId, another.networkId) && this.endpointId.equals(another.endpointId) && this.gateway.equals(another.gateway) && this.ipAddress.equals(another.ipAddress) && this.ipPrefixLen.equals(another.ipPrefixLen) && this.ipv6Gateway.equals(another.ipv6Gateway) && this.globalIPv6Address.equals(another.globalIPv6Address) && this.globalIPv6PrefixLen.equals(another.globalIPv6PrefixLen) && this.macAddress.equals(another.macAddress);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.aliases);
        h += (h << 5) + Objects.hashCode(this.networkId);
        h += (h << 5) + this.endpointId.hashCode();
        h += (h << 5) + this.gateway.hashCode();
        h += (h << 5) + this.ipAddress.hashCode();
        h += (h << 5) + this.ipPrefixLen.hashCode();
        h += (h << 5) + this.ipv6Gateway.hashCode();
        h += (h << 5) + this.globalIPv6Address.hashCode();
        h += (h << 5) + this.globalIPv6PrefixLen.hashCode();
        h += (h << 5) + this.macAddress.hashCode();
        return h;
    }

    public String toString() {
        return "AttachedNetwork{aliases=" + this.aliases + ", networkId=" + this.networkId + ", endpointId=" + this.endpointId + ", gateway=" + this.gateway + ", ipAddress=" + this.ipAddress + ", ipPrefixLen=" + this.ipPrefixLen + ", ipv6Gateway=" + this.ipv6Gateway + ", globalIPv6Address=" + this.globalIPv6Address + ", globalIPv6PrefixLen=" + this.globalIPv6PrefixLen + ", macAddress=" + this.macAddress + "}";
    }

    public static ImmutableAttachedNetwork copyOf(AttachedNetwork instance) {
        if (instance instanceof ImmutableAttachedNetwork) {
            return (ImmutableAttachedNetwork)instance;
        }
        return ImmutableAttachedNetwork.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_ENDPOINT_ID = 1L;
        private static final long INIT_BIT_GATEWAY = 2L;
        private static final long INIT_BIT_IP_ADDRESS = 4L;
        private static final long INIT_BIT_IP_PREFIX_LEN = 8L;
        private static final long INIT_BIT_IPV6_GATEWAY = 16L;
        private static final long INIT_BIT_GLOBAL_I_PV6_ADDRESS = 32L;
        private static final long INIT_BIT_GLOBAL_I_PV6_PREFIX_LEN = 64L;
        private static final long INIT_BIT_MAC_ADDRESS = 128L;
        private long initBits = 255L;
        private List<String> aliases = null;
        private String networkId;
        private String endpointId;
        private String gateway;
        private String ipAddress;
        private Integer ipPrefixLen;
        private String ipv6Gateway;
        private String globalIPv6Address;
        private Integer globalIPv6PrefixLen;
        private String macAddress;

        private Builder() {
        }

        public final Builder from(AttachedNetwork instance) {
            String networkIdValue;
            Objects.requireNonNull(instance, "instance");
            List<String> aliasesValue = instance.aliases();
            if (aliasesValue != null) {
                this.addAllAliases(aliasesValue);
            }
            if ((networkIdValue = instance.networkId()) != null) {
                this.networkId(networkIdValue);
            }
            this.endpointId(instance.endpointId());
            this.gateway(instance.gateway());
            this.ipAddress(instance.ipAddress());
            this.ipPrefixLen(instance.ipPrefixLen());
            this.ipv6Gateway(instance.ipv6Gateway());
            this.globalIPv6Address(instance.globalIPv6Address());
            this.globalIPv6PrefixLen(instance.globalIPv6PrefixLen());
            this.macAddress(instance.macAddress());
            return this;
        }

        public final Builder aliase(String element) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            this.aliases.add(Objects.requireNonNull(element, "aliases element"));
            return this;
        }

        public final Builder aliases(String ... elements) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            for (String element : elements) {
                this.aliases.add(Objects.requireNonNull(element, "aliases element"));
            }
            return this;
        }

        @JsonProperty(value="Aliases")
        public final Builder aliases(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.aliases = null;
                return this;
            }
            this.aliases = new ArrayList<String>();
            return this.addAllAliases(elements);
        }

        public final Builder addAllAliases(Iterable<String> elements) {
            Objects.requireNonNull(elements, "aliases element");
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            for (String element : elements) {
                this.aliases.add(Objects.requireNonNull(element, "aliases element"));
            }
            return this;
        }

        @JsonProperty(value="NetworkID")
        public final Builder networkId(@Nullable String networkId) {
            this.networkId = networkId;
            return this;
        }

        @JsonProperty(value="EndpointID")
        public final Builder endpointId(String endpointId) {
            this.endpointId = Objects.requireNonNull(endpointId, "endpointId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Gateway")
        public final Builder gateway(String gateway) {
            this.gateway = Objects.requireNonNull(gateway, "gateway");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="IPAddress")
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = Objects.requireNonNull(ipAddress, "ipAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="IPPrefixLen")
        public final Builder ipPrefixLen(Integer ipPrefixLen) {
            this.ipPrefixLen = Objects.requireNonNull(ipPrefixLen, "ipPrefixLen");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="IPv6Gateway")
        public final Builder ipv6Gateway(String ipv6Gateway) {
            this.ipv6Gateway = Objects.requireNonNull(ipv6Gateway, "ipv6Gateway");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="GlobalIPv6Address")
        public final Builder globalIPv6Address(String globalIPv6Address) {
            this.globalIPv6Address = Objects.requireNonNull(globalIPv6Address, "globalIPv6Address");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="GlobalIPv6PrefixLen")
        public final Builder globalIPv6PrefixLen(Integer globalIPv6PrefixLen) {
            this.globalIPv6PrefixLen = Objects.requireNonNull(globalIPv6PrefixLen, "globalIPv6PrefixLen");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="MacAddress")
        public final Builder macAddress(String macAddress) {
            this.macAddress = Objects.requireNonNull(macAddress, "macAddress");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableAttachedNetwork build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAttachedNetwork(this.aliases == null ? null : ImmutableAttachedNetwork.createUnmodifiableList(true, this.aliases), this.networkId, this.endpointId, this.gateway, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.macAddress);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("endpointId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("gateway");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ipAddress");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ipPrefixLen");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("ipv6Gateway");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("globalIPv6Address");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("globalIPv6PrefixLen");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("macAddress");
            }
            return "Cannot build AttachedNetwork, some of required attributes are not set " + attributes;
        }
    }
}

