/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ProgressDetail;

final class ImmutableProgressDetail
implements ProgressDetail {
    @Nullable
    private final Long current;
    @Nullable
    private final Long start;
    @Nullable
    private final Long total;

    private ImmutableProgressDetail(@Nullable Long current, @Nullable Long start, @Nullable Long total) {
        this.current = current;
        this.start = start;
        this.total = total;
    }

    @Override
    @JsonProperty(value="current")
    @Nullable
    public Long current() {
        return this.current;
    }

    @Override
    @JsonProperty(value="start")
    @Nullable
    public Long start() {
        return this.start;
    }

    @Override
    @JsonProperty(value="total")
    @Nullable
    public Long total() {
        return this.total;
    }

    public final ImmutableProgressDetail withCurrent(@Nullable Long value) {
        if (Objects.equals(this.current, value)) {
            return this;
        }
        return new ImmutableProgressDetail(value, this.start, this.total);
    }

    public final ImmutableProgressDetail withStart(@Nullable Long value) {
        if (Objects.equals(this.start, value)) {
            return this;
        }
        return new ImmutableProgressDetail(this.current, value, this.total);
    }

    public final ImmutableProgressDetail withTotal(@Nullable Long value) {
        if (Objects.equals(this.total, value)) {
            return this;
        }
        return new ImmutableProgressDetail(this.current, this.start, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProgressDetail && this.equalTo(0, (ImmutableProgressDetail)another);
    }

    private boolean equalTo(int synthetic, ImmutableProgressDetail another) {
        return Objects.equals(this.current, another.current) && Objects.equals(this.start, another.start) && Objects.equals(this.total, another.total);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.current);
        h += (h << 5) + Objects.hashCode(this.start);
        h += (h << 5) + Objects.hashCode(this.total);
        return h;
    }

    public String toString() {
        return "ProgressDetail{current=" + this.current + ", start=" + this.start + ", total=" + this.total + "}";
    }

    public static ImmutableProgressDetail copyOf(ProgressDetail instance) {
        if (instance instanceof ImmutableProgressDetail) {
            return (ImmutableProgressDetail)instance;
        }
        return ImmutableProgressDetail.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private Long current;
        private Long start;
        private Long total;

        private Builder() {
        }

        public final Builder from(ProgressDetail instance) {
            Long totalValue;
            Long startValue;
            Objects.requireNonNull(instance, "instance");
            Long currentValue = instance.current();
            if (currentValue != null) {
                this.current(currentValue);
            }
            if ((startValue = instance.start()) != null) {
                this.start(startValue);
            }
            if ((totalValue = instance.total()) != null) {
                this.total(totalValue);
            }
            return this;
        }

        @JsonProperty(value="current")
        public final Builder current(@Nullable Long current) {
            this.current = current;
            return this;
        }

        @JsonProperty(value="start")
        public final Builder start(@Nullable Long start) {
            this.start = start;
            return this;
        }

        @JsonProperty(value="total")
        public final Builder total(@Nullable Long total) {
            this.total = total;
            return this;
        }

        public ImmutableProgressDetail build() {
            return new ImmutableProgressDetail(this.current, this.start, this.total);
        }
    }
}

