/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerVersion;
import org.mandas.docker.client.messages.Version;

public class DockerVersion
implements IDockerVersion {
    private IDockerConnection parent;
    private String apiVersion;
    private String arch;
    private String gitCommit;
    private String goVersion;
    private String kernelVersion;
    private String os;
    private String version;

    public DockerVersion(IDockerConnection connection, Version version) {
        this.parent = connection;
        this.apiVersion = version.apiVersion();
        this.arch = version.arch();
        this.gitCommit = version.gitCommit();
        this.goVersion = version.goVersion();
        this.kernelVersion = version.kernelVersion();
        this.os = version.os();
        this.version = version.version();
    }

    @Override
    public IDockerConnection getConnection() {
        return this.parent;
    }

    @Override
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String arch() {
        return this.arch;
    }

    @Override
    public String gitCommit() {
        return this.gitCommit;
    }

    @Override
    public String goVersion() {
        return this.goVersion;
    }

    @Override
    public String kernelVersion() {
        return this.kernelVersion;
    }

    @Override
    public String os() {
        return this.os;
    }

    @Override
    public String version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerVersion version1 = (DockerVersion)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(version1.apiVersion) : version1.apiVersion != null) {
            return false;
        }
        if (this.arch != null ? !this.arch.equals(version1.arch) : version1.arch != null) {
            return false;
        }
        if (this.gitCommit != null ? !this.gitCommit.equals(version1.gitCommit) : version1.gitCommit != null) {
            return false;
        }
        if (this.goVersion != null ? !this.goVersion.equals(version1.goVersion) : version1.goVersion != null) {
            return false;
        }
        if (this.kernelVersion != null ? !this.kernelVersion.equals(version1.kernelVersion) : version1.kernelVersion != null) {
            return false;
        }
        if (this.os != null ? !this.os.equals(version1.os) : version1.os != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(version1.version) : version1.version != null);
    }

    public int hashCode() {
        int result = this.apiVersion != null ? this.apiVersion.hashCode() : 0;
        result = 31 * result + (this.arch != null ? this.arch.hashCode() : 0);
        result = 31 * result + (this.gitCommit != null ? this.gitCommit.hashCode() : 0);
        result = 31 * result + (this.goVersion != null ? this.goVersion.hashCode() : 0);
        result = 31 * result + (this.kernelVersion != null ? this.kernelVersion.hashCode() : 0);
        result = 31 * result + (this.os != null ? this.os.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Version: apiVersion=" + this.apiVersion + "\narch" + this.arch + "\ngitCommit" + this.gitCommit + "\ngoVersion" + this.goVersion + "\nkernelVersion" + this.kernelVersion + "\nos" + this.os + "\nversion" + this.version + "\n";
    }
}

